/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.resolution;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.SwitchStmt;
import java.util.Optional;
import java.util.function.Predicate;

public final class Navigator {
    private Navigator() {
    }

    public static ClassOrInterfaceDeclaration demandClass(CompilationUnit cu, String qualifiedName) {
        ClassOrInterfaceDeclaration cd2 = Navigator.demandClassOrInterface(cu, qualifiedName);
        if (cd2.isInterface()) {
            throw new IllegalStateException("Type is not a class");
        }
        return cd2;
    }

    public static ClassOrInterfaceDeclaration demandClassOrInterface(CompilationUnit compilationUnit, String qualifiedName) {
        return Navigator.findType(compilationUnit, qualifiedName).map(res -> res.toClassOrInterfaceDeclaration().orElseThrow(() -> new IllegalStateException("Type is not a class or an interface, it is " + res.getClass().getCanonicalName()))).orElseThrow(() -> new IllegalStateException("No type named '" + qualifiedName + "'found"));
    }

    public static ConstructorDeclaration demandConstructor(TypeDeclaration<?> td, int index) {
        ConstructorDeclaration found = null;
        int i = 0;
        for (BodyDeclaration<?> bd : td.getMembers()) {
            if (!(bd instanceof ConstructorDeclaration)) continue;
            ConstructorDeclaration cd2 = (ConstructorDeclaration)bd;
            if (i == index) {
                found = cd2;
                break;
            }
            ++i;
        }
        if (found == null) {
            throw new IllegalStateException("No constructor with index " + index);
        }
        return found;
    }

    public static EnumDeclaration demandEnum(CompilationUnit cu, String qualifiedName) {
        Optional<TypeDeclaration<?>> res = Navigator.findType(cu, qualifiedName);
        if (!res.isPresent()) {
            throw new IllegalStateException("No type found");
        }
        if (!(res.get() instanceof EnumDeclaration)) {
            throw new IllegalStateException("Type is not an enum");
        }
        return (EnumDeclaration)res.get();
    }

    public static VariableDeclarator demandField(ClassOrInterfaceDeclaration cd2, String name) {
        for (BodyDeclaration<?> bd : cd2.getMembers()) {
            if (!(bd instanceof FieldDeclaration)) continue;
            FieldDeclaration fd = (FieldDeclaration)bd;
            for (VariableDeclarator vd : fd.getVariables()) {
                if (!vd.getName().getId().equals(name)) continue;
                return vd;
            }
        }
        throw new IllegalStateException("No field with given name");
    }

    public static ClassOrInterfaceDeclaration demandInterface(CompilationUnit cu, String qualifiedName) {
        ClassOrInterfaceDeclaration cd2 = Navigator.demandClassOrInterface(cu, qualifiedName);
        if (!cd2.isInterface()) {
            throw new IllegalStateException("Type is not an interface");
        }
        return cd2;
    }

    public static MethodDeclaration demandMethod(TypeDeclaration<?> cd2, String name) {
        MethodDeclaration found = null;
        for (BodyDeclaration<?> bd : cd2.getMembers()) {
            MethodDeclaration md;
            if (!(bd instanceof MethodDeclaration) || !(md = (MethodDeclaration)bd).getNameAsString().equals(name)) continue;
            if (found != null) {
                throw new IllegalStateException("Ambiguous getName");
            }
            found = md;
        }
        if (found == null) {
            throw new IllegalStateException("No method called " + name);
        }
        return found;
    }

    public static <N extends Node> N demandNodeOfGivenClass(Node node, Class<N> clazz) {
        return (N)((Node)node.findFirst(clazz).orElseThrow(IllegalArgumentException::new));
    }

    public static Node demandParentNode(Node node) {
        return node.getParentNode().orElseThrow(() -> new IllegalStateException("Parent not found, the node does not appear to be inserted in a correct AST"));
    }

    public static Node demandParentNode(Node node, Predicate<Node> isAcceptedParentNode) {
        Node parent = node;
        while (!isAcceptedParentNode.test(parent = Navigator.demandParentNode(parent))) {
        }
        return parent;
    }

    public static ReturnStmt demandReturnStmt(MethodDeclaration method) {
        return Navigator.demandNodeOfGivenClass(method, ReturnStmt.class);
    }

    public static SwitchStmt demandSwitch(Node node) {
        return Navigator.findSwitchHelper(node).orElseThrow(IllegalArgumentException::new);
    }

    public static Optional<VariableDeclarator> demandVariableDeclaration(Node node, String name) {
        return node.findFirst(VariableDeclarator.class, n -> n.getNameAsString().equals(name));
    }

    public static Optional<MethodCallExpr> findMethodCall(Node node, String methodName) {
        return node.findFirst(MethodCallExpr.class, n -> n.getNameAsString().equals(methodName));
    }

    public static Optional<NameExpr> findNameExpression(Node node, String name) {
        return node.findFirst(NameExpr.class, n -> n.getNameAsString().equals(name));
    }

    @Deprecated
    public static <N extends Node> N findNodeOfGivenClass(Node node, Class<N> clazz) {
        return Navigator.demandNodeOfGivenClass(node, clazz);
    }

    @Deprecated
    public static ReturnStmt findReturnStmt(MethodDeclaration method) {
        return Navigator.demandReturnStmt(method);
    }

    public static Optional<SimpleName> findSimpleName(Node node, String name) {
        return node.findFirst(SimpleName.class, n -> n.asString().equals(name));
    }

    @Deprecated
    public static SwitchStmt findSwitch(Node node) {
        return Navigator.demandSwitch(node);
    }

    private static Optional<SwitchStmt> findSwitchHelper(Node node) {
        if (node instanceof SwitchStmt) {
            return Optional.of((SwitchStmt)node);
        }
        return node.findFirst(SwitchStmt.class);
    }

    public static Optional<TypeDeclaration<?>> findType(CompilationUnit cu, String qualifiedName) {
        if (cu.getTypes().isEmpty()) {
            return Optional.empty();
        }
        String typeName = Navigator.getOuterTypeName(qualifiedName);
        Optional<TypeDeclaration<?>> type = cu.getTypes().stream().filter(t2 -> t2.getName().getId().equals(typeName)).findFirst();
        String innerTypeName = Navigator.getInnerTypeName(qualifiedName);
        if (type.isPresent() && !innerTypeName.isEmpty()) {
            return Navigator.findType(type.get(), innerTypeName);
        }
        return type;
    }

    public static Optional<TypeDeclaration<?>> findType(TypeDeclaration<?> td, String qualifiedName) {
        String typeName = Navigator.getOuterTypeName(qualifiedName);
        Optional<TypeDeclaration<?>> type = Optional.empty();
        for (Node node : td.getMembers()) {
            if (!(node instanceof TypeDeclaration) || !((TypeDeclaration)node).getName().getId().equals(typeName)) continue;
            type = Optional.of((TypeDeclaration)node);
            break;
        }
        String innerTypeName = Navigator.getInnerTypeName(qualifiedName);
        if (type.isPresent() && !innerTypeName.isEmpty()) {
            return Navigator.findType(type.get(), innerTypeName);
        }
        return type;
    }

    private static String getInnerTypeName(String qualifiedName) {
        if (qualifiedName.contains(".")) {
            return qualifiedName.split("\\.", 2)[1];
        }
        return "";
    }

    private static String getOuterTypeName(String qualifiedName) {
        return qualifiedName.split("\\.", 2)[0];
    }

    @Deprecated
    public static Node requireParentNode(Node node) {
        return Navigator.demandParentNode(node);
    }
}

