/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.resolution.logic;

import com.github.javaparser.resolution.MethodAmbiguityException;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.logic.MethodResolutionLogic;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ConstructorResolutionLogic {
    private static List<ResolvedType> groupVariadicParamValues(List<ResolvedType> argumentsTypes, int startVariadic, ResolvedType variadicType) {
        ArrayList<ResolvedType> res = new ArrayList<ResolvedType>(argumentsTypes.subList(0, startVariadic));
        List<ResolvedType> variadicValues = argumentsTypes.subList(startVariadic, argumentsTypes.size());
        if (variadicValues.isEmpty()) {
            res.add(variadicType);
        } else {
            ResolvedType componentType = ConstructorResolutionLogic.findCommonType(variadicValues);
            res.add(new ResolvedArrayType(componentType));
        }
        return res;
    }

    private static ResolvedType findCommonType(List<ResolvedType> variadicValues) {
        if (variadicValues.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return variadicValues.get(0);
    }

    public static boolean isApplicable(ResolvedConstructorDeclaration constructor, List<ResolvedType> argumentsTypes, TypeSolver typeSolver) {
        return ConstructorResolutionLogic.isApplicable(constructor, argumentsTypes, typeSolver, false);
    }

    private static boolean isApplicable(ResolvedConstructorDeclaration constructor, List<ResolvedType> argumentsTypes, TypeSolver typeSolver, boolean withWildcardTolerance) {
        if (constructor.hasVariadicParameter()) {
            int pos = constructor.getNumberOfParams() - 1;
            if (constructor.getNumberOfParams() == argumentsTypes.size()) {
                ResolvedType actualType;
                ResolvedType expectedType = constructor.getLastParam().getType();
                if (!expectedType.isAssignableBy(actualType = argumentsTypes.get(pos))) {
                    for (ResolvedTypeParameterDeclaration tp : constructor.getTypeParameters()) {
                        expectedType = MethodResolutionLogic.replaceTypeParam(expectedType, tp, typeSolver);
                    }
                    if (!expectedType.isAssignableBy(actualType)) {
                        if (actualType.isArray() && expectedType.isAssignableBy(actualType.asArrayType().getComponentType())) {
                            argumentsTypes.set(pos, actualType.asArrayType().getComponentType());
                        } else {
                            argumentsTypes = ConstructorResolutionLogic.groupVariadicParamValues(argumentsTypes, pos, constructor.getLastParam().getType());
                        }
                    }
                }
            } else {
                if (pos > argumentsTypes.size()) {
                    return false;
                }
                argumentsTypes = ConstructorResolutionLogic.groupVariadicParamValues(argumentsTypes, pos, constructor.getLastParam().getType());
            }
        }
        if (constructor.getNumberOfParams() != argumentsTypes.size()) {
            return false;
        }
        HashMap<String, ResolvedType> matchedParameters = new HashMap<String, ResolvedType>();
        boolean needForWildCardTolerance = false;
        for (int i = 0; i < constructor.getNumberOfParams(); ++i) {
            boolean isAssignableWithoutSubstitution;
            ResolvedType expectedType = constructor.getParam(i).getType();
            ResolvedType actualType = argumentsTypes.get(i);
            if (expectedType.isTypeVariable() && !expectedType.isWildcard() && expectedType.asTypeParameter().declaredOnMethod()) {
                matchedParameters.put(expectedType.asTypeParameter().getName(), actualType);
                continue;
            }
            boolean bl = isAssignableWithoutSubstitution = expectedType.isAssignableBy(actualType) || constructor.getParam(i).isVariadic() && new ResolvedArrayType(expectedType).isAssignableBy(actualType);
            if (!isAssignableWithoutSubstitution && expectedType.isReferenceType() && actualType.isReferenceType()) {
                isAssignableWithoutSubstitution = MethodResolutionLogic.isAssignableMatchTypeParameters(expectedType.asReferenceType(), actualType.asReferenceType(), matchedParameters);
            }
            if (isAssignableWithoutSubstitution) continue;
            for (ResolvedTypeParameterDeclaration tp : constructor.getTypeParameters()) {
                expectedType = MethodResolutionLogic.replaceTypeParam(expectedType, tp, typeSolver);
            }
            for (ResolvedTypeParameterDeclaration tp : constructor.declaringType().getTypeParameters()) {
                expectedType = MethodResolutionLogic.replaceTypeParam(expectedType, tp, typeSolver);
            }
            if (expectedType.isAssignableBy(actualType)) continue;
            if (actualType.isWildcard() && withWildcardTolerance && !expectedType.isPrimitive()) {
                needForWildCardTolerance = true;
                continue;
            }
            if (constructor.hasVariadicParameter() && i == constructor.getNumberOfParams() - 1 && new ResolvedArrayType(expectedType).isAssignableBy(actualType)) continue;
            return false;
        }
        return !withWildcardTolerance || needForWildCardTolerance;
    }

    public static SymbolReference<ResolvedConstructorDeclaration> findMostApplicable(List<ResolvedConstructorDeclaration> constructors, List<ResolvedType> argumentsTypes, TypeSolver typeSolver) {
        SymbolReference<ResolvedConstructorDeclaration> res = ConstructorResolutionLogic.findMostApplicable(constructors, argumentsTypes, typeSolver, false);
        if (res.isSolved()) {
            return res;
        }
        return ConstructorResolutionLogic.findMostApplicable(constructors, argumentsTypes, typeSolver, true);
    }

    public static SymbolReference<ResolvedConstructorDeclaration> findMostApplicable(List<ResolvedConstructorDeclaration> constructors, List<ResolvedType> argumentsTypes, TypeSolver typeSolver, boolean wildcardTolerance) {
        List applicableConstructors = constructors.stream().filter(m4 -> ConstructorResolutionLogic.isApplicable(m4, argumentsTypes, typeSolver, wildcardTolerance)).collect(Collectors.toList());
        if (applicableConstructors.isEmpty()) {
            return SymbolReference.unsolved();
        }
        if (applicableConstructors.size() == 1) {
            return SymbolReference.solved((ResolvedDeclaration)applicableConstructors.get(0));
        }
        ResolvedConstructorDeclaration winningCandidate = (ResolvedConstructorDeclaration)applicableConstructors.get(0);
        ResolvedConstructorDeclaration other = null;
        boolean possibleAmbiguity = false;
        for (int i = 1; i < applicableConstructors.size(); ++i) {
            other = (ResolvedConstructorDeclaration)applicableConstructors.get(i);
            if (ConstructorResolutionLogic.isMoreSpecific(winningCandidate, other, typeSolver)) {
                possibleAmbiguity = false;
            } else if (ConstructorResolutionLogic.isMoreSpecific(other, winningCandidate, typeSolver)) {
                possibleAmbiguity = false;
                winningCandidate = other;
            } else if (winningCandidate.declaringType().getQualifiedName().equals(other.declaringType().getQualifiedName())) {
                possibleAmbiguity = true;
            }
            if (!possibleAmbiguity || MethodResolutionLogic.isExactMatch(winningCandidate, argumentsTypes)) continue;
            if (MethodResolutionLogic.isExactMatch(other, argumentsTypes)) {
                winningCandidate = other;
                continue;
            }
            throw new MethodAmbiguityException("Ambiguous constructor call: cannot find a most applicable constructor: " + winningCandidate + ", " + other);
        }
        return SymbolReference.solved(winningCandidate);
    }

    private static boolean isMoreSpecific(ResolvedConstructorDeclaration constructorA, ResolvedConstructorDeclaration constructorB, TypeSolver typeSolver) {
        boolean oneMoreSpecificFound = false;
        if (constructorA.getNumberOfParams() < constructorB.getNumberOfParams()) {
            return true;
        }
        if (constructorA.getNumberOfParams() > constructorB.getNumberOfParams()) {
            return false;
        }
        for (int i = 0; i < constructorA.getNumberOfParams(); ++i) {
            ResolvedType tdA = constructorA.getParam(i).getType();
            ResolvedType tdB = constructorB.getParam(i).getType();
            if (tdB.isAssignableBy(tdA) && !tdA.isAssignableBy(tdB)) {
                oneMoreSpecificFound = true;
            }
            if (tdA.isAssignableBy(tdB) && !tdB.isAssignableBy(tdA)) {
                return false;
            }
            if (!tdA.isArray() && tdB.isArray()) {
                return true;
            }
            if (i != constructorA.getNumberOfParams() - 1 || tdA.arrayLevel() <= tdB.arrayLevel()) continue;
            return true;
        }
        return oneMoreSpecificFound;
    }
}

