/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.resolution.logic;

import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class FunctionalInterfaceLogic {
    private static String JAVA_LANG_FUNCTIONAL_INTERFACE = FunctionalInterface.class.getCanonicalName();
    private static List<String> OBJECT_PUBLIC_METHODS_SIGNATURES = Arrays.stream(Object.class.getDeclaredMethods()).filter(m4 -> Modifier.isPublic(m4.getModifiers())).map(method -> FunctionalInterfaceLogic.getSignature(method)).collect(Collectors.toList());

    private FunctionalInterfaceLogic() {
    }

    public static Optional<MethodUsage> getFunctionalMethod(ResolvedType type) {
        Optional<ResolvedReferenceTypeDeclaration> optionalTypeDeclaration = type.asReferenceType().getTypeDeclaration();
        if (!optionalTypeDeclaration.isPresent()) {
            return Optional.empty();
        }
        ResolvedReferenceTypeDeclaration typeDeclaration = optionalTypeDeclaration.get();
        if (type.isReferenceType() && typeDeclaration.isInterface()) {
            return FunctionalInterfaceLogic.getFunctionalMethod(typeDeclaration);
        }
        return Optional.empty();
    }

    public static Optional<MethodUsage> getFunctionalMethod(ResolvedReferenceTypeDeclaration typeDeclaration) {
        Set methods = typeDeclaration.getAllMethods().stream().filter(m4 -> m4.getDeclaration().isAbstract()).filter(m4 -> !FunctionalInterfaceLogic.isPublicMemberOfObject(m4)).collect(Collectors.toSet());
        if (methods.size() == 0) {
            return Optional.empty();
        }
        Iterator iterator = methods.iterator();
        MethodUsage methodUsage = (MethodUsage)iterator.next();
        while (iterator.hasNext()) {
            MethodUsage otherMethodUsage = (MethodUsage)iterator.next();
            if (!(methodUsage.isSameSignature(otherMethodUsage) || methodUsage.isSubSignature(otherMethodUsage) || otherMethodUsage.isSubSignature(methodUsage))) {
                methodUsage = null;
                break;
            }
            if (methodUsage.isReturnTypeSubstituable(otherMethodUsage)) continue;
            methodUsage = null;
            break;
        }
        return Optional.ofNullable(methodUsage);
    }

    public static boolean isFunctionalInterfaceType(ResolvedType type) {
        Optional<ResolvedReferenceTypeDeclaration> optionalTypeDeclaration;
        if (type.isReferenceType() && (optionalTypeDeclaration = type.asReferenceType().getTypeDeclaration()).isPresent() && optionalTypeDeclaration.get().hasAnnotation(JAVA_LANG_FUNCTIONAL_INTERFACE)) {
            return true;
        }
        return FunctionalInterfaceLogic.getFunctionalMethod(type).isPresent();
    }

    private static String getSignature(Method m4) {
        return String.format("%s(%s)", m4.getName(), String.join((CharSequence)", ", Arrays.stream(m4.getParameters()).map(p -> FunctionalInterfaceLogic.toSignature(p)).collect(Collectors.toList())));
    }

    private static String toSignature(Parameter p) {
        return p.getType().getCanonicalName();
    }

    private static boolean isPublicMemberOfObject(MethodUsage m4) {
        return OBJECT_PUBLIC_METHODS_SIGNATURES.contains(m4.getDeclaration().getSignature());
    }
}

