/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.cache;

import com.github.javaparser.resolution.cache.CacheStats;
import com.google.common.math.LongMath;
import java.util.Arrays;
import javax.annotation.CheckForNull;

public class DefaultCacheStats
implements CacheStats {
    private final long hitCount;
    private final long missCount;
    private final long loadSuccessCount;
    private final long loadExceptionCount;
    private final long totalLoadTime;
    private final long evictionCount;

    public DefaultCacheStats() {
        this.hitCount = 0L;
        this.missCount = 0L;
        this.loadSuccessCount = 0L;
        this.loadExceptionCount = 0L;
        this.totalLoadTime = 0L;
        this.evictionCount = 0L;
    }

    public DefaultCacheStats(long hitCount, long missCount, long loadSuccessCount, long loadExceptionCount, long totalLoadTime, long evictionCount) {
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.loadSuccessCount = loadSuccessCount;
        this.loadExceptionCount = loadExceptionCount;
        this.totalLoadTime = totalLoadTime;
        this.evictionCount = evictionCount;
    }

    @Override
    public long requestCount() {
        return LongMath.saturatedAdd(this.hitCount, this.missCount);
    }

    @Override
    public long hitCount() {
        return this.hitCount;
    }

    @Override
    public double hitRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount / (double)requestCount;
    }

    @Override
    public long missCount() {
        return this.missCount;
    }

    @Override
    public double missRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount / (double)requestCount;
    }

    @Override
    public long loadCount() {
        return LongMath.saturatedAdd(this.loadSuccessCount, this.loadExceptionCount);
    }

    @Override
    public long loadSuccessCount() {
        return this.loadSuccessCount;
    }

    @Override
    public long loadExceptionCount() {
        return this.loadExceptionCount;
    }

    @Override
    public double loadExceptionRate() {
        long totalLoadCount = LongMath.saturatedAdd(this.loadSuccessCount, this.loadExceptionCount);
        return totalLoadCount == 0L ? 0.0 : (double)this.loadExceptionCount / (double)totalLoadCount;
    }

    @Override
    public long totalLoadTime() {
        return this.totalLoadTime;
    }

    @Override
    public double averageLoadPenalty() {
        long totalLoadCount = LongMath.saturatedAdd(this.loadSuccessCount, this.loadExceptionCount);
        return totalLoadCount == 0L ? 0.0 : (double)this.totalLoadTime / (double)totalLoadCount;
    }

    @Override
    public long evictionCount() {
        return this.evictionCount;
    }

    @Override
    public CacheStats minus(CacheStats other) {
        return new DefaultCacheStats(Math.max(0L, LongMath.saturatedSubtract(this.hitCount, other.hitCount())), Math.max(0L, LongMath.saturatedSubtract(this.missCount, other.missCount())), Math.max(0L, LongMath.saturatedSubtract(this.loadSuccessCount, other.loadSuccessCount())), Math.max(0L, LongMath.saturatedSubtract(this.loadExceptionCount, other.loadExceptionCount())), Math.max(0L, LongMath.saturatedSubtract(this.totalLoadTime, other.totalLoadTime())), Math.max(0L, LongMath.saturatedSubtract(this.evictionCount, other.evictionCount())));
    }

    @Override
    public CacheStats plus(CacheStats other) {
        return new DefaultCacheStats(LongMath.saturatedAdd(this.hitCount, other.hitCount()), LongMath.saturatedAdd(this.missCount, other.missCount()), LongMath.saturatedAdd(this.loadSuccessCount, other.loadSuccessCount()), LongMath.saturatedAdd(this.loadExceptionCount, other.loadExceptionCount()), LongMath.saturatedAdd(this.totalLoadTime, other.totalLoadTime()), LongMath.saturatedAdd(this.evictionCount, other.evictionCount()));
    }

    public int hashCode() {
        return Arrays.hashCode(new long[]{this.hitCount, this.missCount, this.loadSuccessCount, this.loadExceptionCount, this.totalLoadTime, this.evictionCount});
    }

    public boolean equals(@CheckForNull Object object) {
        if (object instanceof CacheStats) {
            CacheStats other = (CacheStats)object;
            return this.hitCount == other.hitCount() && this.missCount == other.missCount() && this.loadSuccessCount == other.loadSuccessCount() && this.loadExceptionCount == other.loadExceptionCount() && this.totalLoadTime == other.totalLoadTime() && this.evictionCount == other.evictionCount();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(": ");
        return sb.append("hitCount").append(this.hitCount).append(",").append("missCount").append(this.missCount).append(",").append("loadSuccessCount").append(this.loadSuccessCount).append(",").append("loadExceptionCount").append(this.loadExceptionCount).append(",").append("totalLoadTime").append(this.totalLoadTime).append(",").append("evictionCount").append(this.evictionCount).append(",").toString();
    }
}

