/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.BreakStmt;
import com.github.javaparser.ast.stmt.ContinueStmt;
import com.github.javaparser.ast.stmt.DoStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.LabeledStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.SwitchEntry;
import com.github.javaparser.ast.stmt.SwitchStmt;
import com.github.javaparser.ast.stmt.SynchronizedStmt;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.stmt.WhileStmt;
import com.github.javaparser.ast.stmt.YieldStmt;
import com.github.javaparser.ast.visitor.GenericVisitorWithDefaults;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import java.util.List;
import java.util.Optional;

public class NormalCompletionVisitor
extends GenericVisitorWithDefaults<Boolean, Void> {
    private static String[] nonEnhancedSwitchTypes = new String[]{"java.lang.Byte", "java.lang.Character", "java.lang.Integer", "java.lang.Short", "java.lang.String"};

    @Override
    public Boolean defaultAction(Node n, Void unused) {
        return true;
    }

    @Override
    public Boolean visit(BreakStmt breakStmt, Void unused) {
        return false;
    }

    @Override
    public Boolean visit(ContinueStmt continueStmt, Void unused) {
        return false;
    }

    @Override
    public Boolean visit(ReturnStmt returnStmt, Void unused) {
        return false;
    }

    @Override
    public Boolean visit(ThrowStmt throwStmt, Void unused) {
        return false;
    }

    @Override
    public Boolean visit(YieldStmt yieldStmt, Void unused) {
        return false;
    }

    @Override
    public Boolean visit(BlockStmt block, Void unused) {
        return block.getStatements().isEmpty() || block.getStatements().getLast().get().accept(this, unused) != false;
    }

    @Override
    public Boolean visit(LabeledStmt labeledStmt, Void unused) {
        if (labeledStmt.getStatement().accept(this, unused).booleanValue()) {
            return true;
        }
        List<BreakStmt> matchingBreaks = labeledStmt.findAll(BreakStmt.class, breakStmt -> breakStmt.getLabel().isPresent() && breakStmt.getLabel().get().getIdentifier().equals(labeledStmt.getLabel().getIdentifier()));
        return !matchingBreaks.isEmpty();
    }

    @Override
    public Boolean visit(IfStmt ifStmt, Void unused) {
        if (!ifStmt.getElseStmt().isPresent()) {
            return true;
        }
        return ifStmt.getThenStmt().accept(this, unused) != false || ifStmt.getElseStmt().get().accept(this, unused) != false;
    }

    @Override
    public Boolean visit(WhileStmt whileStmt, Void unused) {
        return true;
    }

    @Override
    public Boolean visit(DoStmt doStmt, Void unused) {
        return true;
    }

    @Override
    public Boolean visit(ForStmt forStmt, Void unused) {
        return true;
    }

    @Override
    public Boolean visit(SynchronizedStmt synchronizedStmt, Void unused) {
        return synchronizedStmt.getBody().accept(this, unused);
    }

    @Override
    public Boolean visit(TryStmt tryStmt, Void unused) {
        if (tryStmt.getFinallyBlock().isPresent() && !tryStmt.getFinallyBlock().get().accept(this, unused).booleanValue()) {
            return false;
        }
        if (tryStmt.getTryBlock().accept(this, unused).booleanValue()) {
            return true;
        }
        return tryStmt.getCatchClauses().stream().anyMatch(catchClause -> catchClause.getBody().accept(this, unused));
    }

    @Override
    public Boolean visit(SwitchStmt switchStmt, Void unused) {
        NodeList<SwitchEntry> entries = switchStmt.getEntries();
        if (entries.isEmpty()) {
            return true;
        }
        if (((SwitchEntry)entries.get(0)).getType().equals((Object)SwitchEntry.Type.STATEMENT_GROUP)) {
            SwitchEntry lastEntry = entries.getLast().get();
            if (lastEntry.getStatements().isEmpty()) {
                return true;
            }
            Statement lastStmt = lastEntry.getStatements().getLast().get();
            if (lastStmt.accept(this, unused).booleanValue()) {
                return true;
            }
        } else if (entries.stream().anyMatch(entry -> this.switchRuleCompletesNormally((SwitchEntry)entry, unused))) {
            return true;
        }
        if (NormalCompletionVisitor.containsCorrespondingBreak(switchStmt)) {
            return true;
        }
        if (!NormalCompletionVisitor.isEnhanced(switchStmt) && !entries.stream().anyMatch(entry -> entry.isDefault())) {
            return true;
        }
        return false;
    }

    private boolean switchRuleCompletesNormally(SwitchEntry switchEntry, Void unused) {
        if (switchEntry.getType().equals((Object)SwitchEntry.Type.EXPRESSION)) {
            return true;
        }
        return switchEntry.getStatements().getLast().isPresent() && switchEntry.getStatements().getLast().get().accept(this, unused) != false;
    }

    public static boolean containsCorrespondingBreak(Statement statement) {
        List<BreakStmt> breakStatements = statement.findAll(BreakStmt.class, breakStmt -> !breakStmt.getLabel().isPresent());
        block0: for (BreakStmt breakStmt2 : breakStatements) {
            Optional<Node> maybeParentNode = breakStmt2.getParentNode();
            while (true) {
                if (!maybeParentNode.isPresent()) {
                    throw new IllegalStateException("Found AST node without a parent in subtree of Statement");
                }
                Node parentNode = maybeParentNode.get();
                if (parentNode instanceof SwitchStmt || parentNode instanceof WhileStmt || parentNode instanceof DoStmt || parentNode instanceof ForStmt || parentNode instanceof ForEachStmt) {
                    if (parentNode != statement) continue block0;
                    return true;
                }
                maybeParentNode = maybeParentNode.flatMap(node -> node.getParentNode());
            }
        }
        return false;
    }

    private static boolean isEnhanced(SwitchStmt stmt) {
        for (SwitchEntry switchEntry : stmt.getEntries()) {
            if (!switchEntry.isDefault() && !switchEntry.getLabels().stream().anyMatch(label -> label.isNullLiteralExpr())) continue;
            return false;
        }
        try {
            ResolvedReferenceType resolvedReferenceType;
            ResolvedType selectorType = stmt.getSelector().calculateResolvedType();
            if (selectorType.isPrimitive()) {
                return false;
            }
            for (String nonEnhancedTypeName : nonEnhancedSwitchTypes) {
                if (!nonEnhancedTypeName.equals(selectorType.describe())) continue;
                return false;
            }
            if (selectorType.isReferenceType() && (resolvedReferenceType = selectorType.asReferenceType()).getTypeDeclaration().isPresent() && resolvedReferenceType.getTypeDeclaration().get().isEnum()) {
                return false;
            }
        }
        catch (UnsolvedSymbolException e) {
            return true;
        }
        return true;
    }
}

