/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.PatternExpr;
import com.github.javaparser.ast.expr.TypePatternExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithOptionalScope;
import com.github.javaparser.resolution.Context;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.Navigator;
import com.github.javaparser.resolution.SymbolDeclarator;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.Value;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.TypeVariableResolutionCapability;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.PatternVariableVisitor;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.BinaryExprContext;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.IfStatementContext;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.SwitchEntryContext;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserSymbolDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypePatternDeclaration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AbstractJavaParserContext<N extends Node>
implements Context {
    protected N wrappedNode;
    protected TypeSolver typeSolver;

    public static SymbolReference<ResolvedValueDeclaration> solveWith(SymbolDeclarator symbolDeclarator, String name) {
        for (ResolvedValueDeclaration decl : symbolDeclarator.getSymbolDeclarations()) {
            if (!decl.getName().equals(name)) continue;
            return SymbolReference.solved(decl);
        }
        return SymbolReference.unsolved();
    }

    public AbstractJavaParserContext(N wrappedNode, TypeSolver typeSolver) {
        if (wrappedNode == null) {
            throw new NullPointerException();
        }
        this.wrappedNode = wrappedNode;
        this.typeSolver = typeSolver;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractJavaParserContext that = (AbstractJavaParserContext)o;
        return this.wrappedNode != null ? ((Node)this.wrappedNode).equals(that.wrappedNode) : that.wrappedNode == null;
    }

    public int hashCode() {
        return this.wrappedNode == null ? 0 : ((Node)this.wrappedNode).hashCode();
    }

    @Override
    public final Optional<Context> getParent() {
        MethodCallExpr parentCall;
        boolean found;
        Node parentNode = ((Node)this.wrappedNode).getParentNode().orElse(null);
        if (parentNode instanceof MethodCallExpr && (found = (parentCall = (MethodCallExpr)parentNode).getArguments().contains(this.wrappedNode))) {
            Node notMethod = parentNode;
            while (notMethod instanceof MethodCallExpr) {
                notMethod = Navigator.demandParentNode(notMethod);
            }
            return Optional.of(JavaParserFactory.getContext(notMethod, this.typeSolver));
        }
        Node notMethodNode = parentNode;
        while (notMethodNode instanceof MethodCallExpr || notMethodNode instanceof FieldAccessExpr || notMethodNode != null && notMethodNode.hasScope() && this.getScope(notMethodNode).equals(this.wrappedNode)) {
            notMethodNode = notMethodNode.getParentNode().orElse(null);
        }
        if (notMethodNode == null) {
            return Optional.empty();
        }
        Context parentContext = JavaParserFactory.getContext(notMethodNode, this.typeSolver);
        return Optional.of(parentContext);
    }

    protected Node getScope(Node node) {
        return ((NodeWithOptionalScope)((Object)node)).getScope().get();
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbolInParentContext(String name) {
        Optional<Context> optionalParentContext = this.getParent();
        if (!optionalParentContext.isPresent()) {
            return SymbolReference.unsolved();
        }
        Context parentContext = optionalParentContext.get();
        if (parentContext instanceof BinaryExprContext || parentContext instanceof IfStatementContext || parentContext instanceof SwitchEntryContext) {
            List<TypePatternExpr> typePatternExprs = parentContext.typePatternExprsExposedToChild((Node)this.getWrappedNode());
            List localResolutionResults = typePatternExprs.stream().filter(vd -> vd.getNameAsString().equals(name)).collect(Collectors.toList());
            switch (localResolutionResults.size()) {
                case 0: {
                    return parentContext.solveSymbol(name);
                }
                case 1: {
                    TypePatternExpr typePatternExpr = ((TypePatternExpr)localResolutionResults.get(0)).asTypePatternExpr();
                    JavaParserTypePatternDeclaration decl = JavaParserSymbolDeclaration.patternVar(typePatternExpr, this.typeSolver);
                    return SymbolReference.solved(decl);
                }
            }
            throw new IllegalStateException("Unexpectedly more than one reference in scope");
        }
        return parentContext.solveSymbol(name);
    }

    protected Optional<Value> solveWithAsValue(SymbolDeclarator symbolDeclarator, String name) {
        return symbolDeclarator.getSymbolDeclarations().stream().filter(d -> d.getName().equals(name)).map(Value::from).findFirst();
    }

    protected Collection<ResolvedReferenceTypeDeclaration> findTypeDeclarations(Optional<Expression> optScope) {
        if (optScope.isPresent()) {
            ResolvedType typeOfScope;
            Expression scope = optScope.get();
            try {
                typeOfScope = JavaParserFacade.get(this.typeSolver).getType(scope);
            }
            catch (Exception e) {
                FieldAccessExpr scopeName;
                if (scope instanceof FieldAccessExpr && this.solveType((scopeName = (FieldAccessExpr)scope).toString()).isSolved()) {
                    return Collections.emptyList();
                }
                throw new UnsolvedSymbolException(scope.toString(), ((Node)this.wrappedNode).toString(), e);
            }
            if (typeOfScope.isWildcard()) {
                if (typeOfScope.asWildcard().isExtends() || typeOfScope.asWildcard().isSuper()) {
                    return Collections.singletonList(typeOfScope.asWildcard().getBoundedType().asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty.")));
                }
                return Collections.singletonList(this.typeSolver.getSolvedJavaLangObject());
            }
            if (typeOfScope.isArray()) {
                return Collections.singletonList(this.typeSolver.getSolvedJavaLangObject());
            }
            if (typeOfScope.isTypeVariable()) {
                ArrayList<ResolvedReferenceTypeDeclaration> result = new ArrayList<ResolvedReferenceTypeDeclaration>();
                for (ResolvedTypeParameterDeclaration.Bound bound : typeOfScope.asTypeParameter().getBounds()) {
                    result.add(bound.getType().asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty.")));
                }
                return result;
            }
            if (typeOfScope.isConstraint()) {
                ResolvedType type = typeOfScope.asConstraintType().getBound();
                if (type.isReferenceType()) {
                    return Collections.singletonList(type.asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty.")));
                }
                throw new UnsupportedOperationException("The type declaration cannot be found on constraint " + type.describe());
            }
            if (typeOfScope.isUnionType()) {
                return typeOfScope.asUnionType().getCommonAncestor().flatMap(ResolvedReferenceType::getTypeDeclaration).map(Collections::singletonList).orElseThrow(() -> new UnsolvedSymbolException("No common ancestor available for UnionType" + typeOfScope.describe()));
            }
            return Collections.singletonList(typeOfScope.asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty.")));
        }
        ResolvedType typeOfScope = JavaParserFacade.get(this.typeSolver).getTypeOfThisIn((Node)this.wrappedNode);
        return Collections.singletonList(typeOfScope.asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty.")));
    }

    @Override
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentsTypes) {
        SymbolReference<ResolvedMethodDeclaration> methodSolved = this.solveMethod(name, argumentsTypes, false);
        if (methodSolved.isSolved()) {
            ResolvedMethodDeclaration methodDeclaration = methodSolved.getCorrespondingDeclaration();
            if (!(methodDeclaration instanceof TypeVariableResolutionCapability)) {
                throw new UnsupportedOperationException(String.format("Resolved method declarations must implement %s.", TypeVariableResolutionCapability.class.getName()));
            }
            MethodUsage methodUsage = ((TypeVariableResolutionCapability)((Object)methodDeclaration)).resolveTypeVariables(this, argumentsTypes);
            return Optional.of(methodUsage);
        }
        return Optional.empty();
    }

    @Override
    public N getWrappedNode() {
        return this.wrappedNode;
    }

    public List<TypePatternExpr> typePatternExprsDiscoveredInPattern(PatternExpr patternExpr) {
        ArrayList<TypePatternExpr> discoveredTypePatterns = new ArrayList<TypePatternExpr>();
        ArrayDeque<PatternExpr> patternsToCheck = new ArrayDeque<PatternExpr>();
        patternsToCheck.add(patternExpr);
        while (!patternsToCheck.isEmpty()) {
            PatternExpr patternToCheck = (PatternExpr)patternsToCheck.remove();
            if (patternToCheck.isTypePatternExpr()) {
                discoveredTypePatterns.add(patternToCheck.asTypePatternExpr());
                continue;
            }
            if (patternToCheck.isRecordPatternExpr()) {
                patternsToCheck.addAll(patternToCheck.asRecordPatternExpr().getPatternList());
                continue;
            }
            throw new UnsupportedOperationException(String.format("Discovering type pattern expressions in %s not supported", patternExpr.getClass().getName()));
        }
        return discoveredTypePatterns;
    }

    public SymbolReference<? extends ResolvedValueDeclaration> findExposedPatternInParentContext(Node parent, String name) {
        Context context = JavaParserFactory.getContext(parent, this.typeSolver);
        List<TypePatternExpr> patternVariablesExposedToWrappedNode = context.typePatternExprsExposedToChild((Node)this.wrappedNode);
        for (TypePatternExpr typePatternExpr : patternVariablesExposedToWrappedNode) {
            if (!typePatternExpr.getNameAsString().equals(name)) continue;
            return SymbolReference.solved(JavaParserSymbolDeclaration.patternVar(typePatternExpr, this.typeSolver));
        }
        return SymbolReference.unsolved();
    }

    @Override
    public List<TypePatternExpr> typePatternExprsExposedFromChildren() {
        PatternVariableVisitor variableVisitor = new PatternVariableVisitor();
        return this.wrappedNode.accept(variableVisitor, null).getVariablesIntroducedIfTrue();
    }

    @Override
    public List<TypePatternExpr> negatedTypePatternExprsExposedFromChildren() {
        PatternVariableVisitor variableVisitor = new PatternVariableVisitor();
        return this.wrappedNode.accept(variableVisitor, null).getVariablesIntroducedIfFalse();
    }
}

