/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.Navigator;
import com.github.javaparser.resolution.SymbolDeclarator;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.logic.FunctionalInterfaceLogic;
import com.github.javaparser.resolution.logic.InferenceContext;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.Value;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedLambdaConstraintType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.ExpressionContext;
import com.github.javaparser.utils.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class LambdaExprContext
extends ExpressionContext<LambdaExpr> {
    public LambdaExprContext(LambdaExpr wrappedNode, TypeSolver typeSolver) {
        super(wrappedNode, typeSolver);
    }

    @Override
    public Optional<Value> solveSymbolAsValue(String name) {
        int index = -1;
        for (Parameter parameter : ((LambdaExpr)this.wrappedNode).getParameters()) {
            ++index;
            SymbolDeclarator sb = JavaParserFactory.getSymbolDeclarator(parameter, this.typeSolver);
            for (ResolvedValueDeclaration decl : sb.getSymbolDeclarations()) {
                ResolvedType t2;
                ReturnStmt returnStmt;
                Optional optDeclaration;
                if (!decl.getName().equals(name)) continue;
                Node parentNode = Navigator.demandParentNode(this.wrappedNode, Expression.IS_NOT_ENCLOSED_EXPR);
                if (parentNode instanceof MethodCallExpr) {
                    MethodCallExpr methodCallExpr = (MethodCallExpr)parentNode;
                    MethodUsage methodUsage = JavaParserFacade.get(this.typeSolver).solveMethodAsUsage(methodCallExpr);
                    int i = methodCallExpr.getArgumentPosition((Expression)this.wrappedNode, Expression.EXCLUDE_ENCLOSED_EXPR);
                    ResolvedType lambdaType = methodUsage.getParamTypes().get(i);
                    Optional<MethodUsage> functionalMethodOpt = FunctionalInterfaceLogic.getFunctionalMethod(lambdaType);
                    if (functionalMethodOpt.isPresent()) {
                        int lambdaParamIndex;
                        MethodUsage functionalMethod = functionalMethodOpt.get();
                        InferenceContext inferenceContext = new InferenceContext(this.typeSolver);
                        lambdaType.asReferenceType().getTypeDeclaration().ifPresent(typeDeclaration -> inferenceContext.addPair(lambdaType, new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)typeDeclaration)));
                        boolean found = false;
                        for (lambdaParamIndex = 0; lambdaParamIndex < ((LambdaExpr)this.wrappedNode).getParameters().size(); ++lambdaParamIndex) {
                            if (!((LambdaExpr)this.wrappedNode).getParameter(lambdaParamIndex).getName().getIdentifier().equals(name)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            return Optional.empty();
                        }
                        ResolvedType argType = inferenceContext.resolve(inferenceContext.addSingle(functionalMethod.getParamType(lambdaParamIndex)));
                        ResolvedLambdaConstraintType conType = argType.isWildcard() ? ResolvedLambdaConstraintType.bound(argType.asWildcard().getBoundedType()) : ResolvedLambdaConstraintType.bound(argType);
                        Value value = new Value(conType, name);
                        return Optional.of(value);
                    }
                    return Optional.empty();
                }
                if (parentNode instanceof VariableDeclarator) {
                    VariableDeclarator variableDeclarator = (VariableDeclarator)parentNode;
                    ResolvedType t3 = JavaParserFacade.get(this.typeSolver).convertToUsage(variableDeclarator.getType());
                    return this.solveLambdaParameter(t3, index).map(resolvedLamdbaTypeParametre -> Optional.of(new Value((ResolvedType)resolvedLamdbaTypeParametre, name))).orElseThrow(() -> new UnsupportedOperationException("functional method is not present in variable declarator"));
                }
                if (parentNode instanceof ReturnStmt && (optDeclaration = (returnStmt = (ReturnStmt)parentNode).findAncestor(MethodDeclaration.class)).isPresent()) {
                    ResolvedType t4 = JavaParserFacade.get(this.typeSolver).convertToUsage(((MethodDeclaration)optDeclaration.get()).asMethodDeclaration().getType());
                    return this.solveLambdaParameter(t4, index).map(resolvedLamdbaTypeParametre -> Optional.of(new Value((ResolvedType)resolvedLamdbaTypeParametre, name))).orElseThrow(() -> new UnsupportedOperationException("functional method is not present in return expression"));
                }
                if (parentNode instanceof CastExpr) {
                    CastExpr castExpr = (CastExpr)parentNode;
                    t2 = JavaParserFacade.get(this.typeSolver).convertToUsage(castExpr.getType());
                    return this.solveLambdaParameter(t2, index).map(resolvedLamdbaTypeParametre -> Optional.of(new Value((ResolvedType)resolvedLamdbaTypeParametre, name))).orElseThrow(() -> new UnsupportedOperationException("functional method is not present in cast expression"));
                }
                if (parentNode instanceof AssignExpr) {
                    AssignExpr expr = (AssignExpr)parentNode;
                    t2 = expr.calculateResolvedType();
                    return this.solveLambdaParameter(t2, index).map(resolvedLamdbaTypeParametre -> Optional.of(new Value((ResolvedType)resolvedLamdbaTypeParametre, name))).orElseThrow(() -> new UnsupportedOperationException("Unknown node type: " + parentNode.getClass().getSimpleName()));
                }
                throw new UnsupportedOperationException("Unknown node type: " + parentNode.getClass().getSimpleName());
            }
        }
        return super.solveSymbolAsValue(name);
    }

    private Optional<ResolvedType> solveLambdaParameter(ResolvedType t2, int parameterIndex) {
        ResolvedType lambdaType = null;
        Optional<MethodUsage> functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod(t2);
        if (functionalMethod.isPresent()) {
            lambdaType = functionalMethod.get().getParamType(parameterIndex);
            HashMap<ResolvedTypeParameterDeclaration, ResolvedType> inferredTypes = new HashMap<ResolvedTypeParameterDeclaration, ResolvedType>();
            if (lambdaType.isReferenceType()) {
                for (Pair<ResolvedTypeParameterDeclaration, ResolvedType> entry : lambdaType.asReferenceType().getTypeParametersMap()) {
                    if (!((ResolvedType)entry.b).isTypeVariable() || !((ResolvedType)entry.b).asTypeParameter().declaredOnType()) continue;
                    ResolvedType ot = t2.asReferenceType().typeParametersMap().getValue((ResolvedTypeParameterDeclaration)entry.a);
                    lambdaType = lambdaType.replaceTypeVariables((ResolvedTypeParameterDeclaration)entry.a, ot, inferredTypes);
                }
            } else if (lambdaType.isTypeVariable() && lambdaType.asTypeParameter().declaredOnType()) {
                lambdaType = t2.asReferenceType().typeParametersMap().getValue(lambdaType.asTypeParameter());
            }
        }
        return Optional.ofNullable(lambdaType);
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name) {
        for (Parameter parameter : ((LambdaExpr)this.wrappedNode).getParameters()) {
            SymbolDeclarator sb = JavaParserFactory.getSymbolDeclarator(parameter, this.typeSolver);
            SymbolReference<ResolvedValueDeclaration> symbolReference = LambdaExprContext.solveWith(sb, name);
            if (!symbolReference.isSolved()) continue;
            return symbolReference;
        }
        return super.solveSymbol(name);
    }

    @Override
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        return this.solveMethodInParentContext(name, argumentsTypes, false);
    }

    @Override
    public List<Parameter> parametersExposedToChild(Node child) {
        if (child == ((LambdaExpr)this.wrappedNode).getBody()) {
            return ((LambdaExpr)this.wrappedNode).getParameters();
        }
        return Collections.emptyList();
    }

    @Override
    protected final Optional<Value> solveWithAsValue(SymbolDeclarator symbolDeclarator, String name) {
        for (ResolvedValueDeclaration decl : symbolDeclarator.getSymbolDeclarations()) {
            if (!decl.getName().equals(name)) continue;
            throw new UnsupportedOperationException("Symbol with name " + name + " already exists in symbol declarator");
        }
        return Optional.empty();
    }
}

