/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.Navigator;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.logic.FunctionalInterfaceLogic;
import com.github.javaparser.resolution.logic.InferenceContext;
import com.github.javaparser.resolution.logic.MethodResolutionLogic;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedLambdaConstraintType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.ExpressionContext;
import com.github.javaparser.utils.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class MethodReferenceExprContext
extends ExpressionContext<MethodReferenceExpr> {
    public MethodReferenceExprContext(MethodReferenceExpr wrappedNode, TypeSolver typeSolver) {
        super(wrappedNode, typeSolver);
    }

    @Override
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        if ("new".equals(name)) {
            throw new UnsupportedOperationException("Constructor calls not yet resolvable");
        }
        argumentsTypes.addAll(this.inferArgumentTypes());
        Collection<ResolvedReferenceTypeDeclaration> rrtds = this.findTypeDeclarations(Optional.of(((MethodReferenceExpr)this.wrappedNode).getScope()));
        if (rrtds.isEmpty()) {
            rrtds = Collections.singleton(this.typeSolver.getSolvedJavaLangObject());
        }
        for (ResolvedReferenceTypeDeclaration rrtd : rrtds) {
            SymbolReference<ResolvedMethodDeclaration> firstResAttempt = MethodResolutionLogic.solveMethodInType(rrtd, name, argumentsTypes, false);
            if (firstResAttempt.isSolved()) {
                return firstResAttempt;
            }
            SymbolReference<ResolvedMethodDeclaration> secondResAttempt = MethodResolutionLogic.solveMethodInType(rrtd, name, Collections.emptyList(), false);
            if (!secondResAttempt.isSolved()) continue;
            return secondResAttempt;
        }
        return SymbolReference.unsolved();
    }

    private List<ResolvedType> inferArgumentTypes() {
        if (Navigator.demandParentNode(this.wrappedNode) instanceof MethodCallExpr) {
            MethodCallExpr methodCallExpr = (MethodCallExpr)Navigator.demandParentNode(this.wrappedNode);
            MethodUsage methodUsage = JavaParserFacade.get(this.typeSolver).solveMethodAsUsage(methodCallExpr);
            int pos = methodCallExpr.getArgumentPosition((Expression)this.wrappedNode);
            ResolvedMethodDeclaration rmd = methodUsage.getDeclaration();
            ResolvedType lambdaType = rmd.hasVariadicParameter() && pos >= rmd.getNumberOfParams() - 1 ? rmd.getLastParam().getType().asArrayType().getComponentType() : methodUsage.getParamType(pos);
            return this.resolveLambdaTypes(lambdaType);
        }
        if (Navigator.demandParentNode(this.wrappedNode) instanceof ObjectCreationExpr) {
            ObjectCreationExpr objectCreationExpr = (ObjectCreationExpr)Navigator.demandParentNode(this.wrappedNode);
            ResolvedConstructorDeclaration rcd = JavaParserFacade.get(this.typeSolver).solve(objectCreationExpr).getCorrespondingDeclaration();
            int pos = objectCreationExpr.getArgumentPosition((Expression)this.wrappedNode);
            ResolvedType lambdaType = rcd.hasVariadicParameter() && pos >= rcd.getNumberOfParams() - 1 ? rcd.getLastParam().getType().asArrayType().getComponentType() : rcd.getParam(pos).getType();
            return this.resolveLambdaTypes(lambdaType);
        }
        if (Navigator.demandParentNode(this.wrappedNode) instanceof VariableDeclarator) {
            VariableDeclarator variableDeclarator = (VariableDeclarator)Navigator.demandParentNode(this.wrappedNode);
            ResolvedType t2 = JavaParserFacade.get(this.typeSolver).convertToUsage(variableDeclarator.getType());
            Optional<MethodUsage> functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod(t2);
            if (functionalMethod.isPresent()) {
                ArrayList<ResolvedType> resolvedTypes = new ArrayList<ResolvedType>();
                for (ResolvedType lambdaType : functionalMethod.get().getParamTypes()) {
                    HashMap<ResolvedTypeParameterDeclaration, ResolvedType> inferredTypes = new HashMap<ResolvedTypeParameterDeclaration, ResolvedType>();
                    if (lambdaType.isReferenceType()) {
                        for (Pair<ResolvedTypeParameterDeclaration, ResolvedType> entry : lambdaType.asReferenceType().getTypeParametersMap()) {
                            if (!((ResolvedType)entry.b).isTypeVariable() || !((ResolvedType)entry.b).asTypeParameter().declaredOnType()) continue;
                            ResolvedType ot = t2.asReferenceType().typeParametersMap().getValue((ResolvedTypeParameterDeclaration)entry.a);
                            lambdaType = lambdaType.replaceTypeVariables((ResolvedTypeParameterDeclaration)entry.a, ot, inferredTypes);
                        }
                    } else if (lambdaType.isTypeVariable() && lambdaType.asTypeParameter().declaredOnType()) {
                        lambdaType = t2.asReferenceType().typeParametersMap().getValue(lambdaType.asTypeParameter());
                    }
                    resolvedTypes.add(lambdaType);
                }
                return resolvedTypes;
            }
            throw new UnsupportedOperationException();
        }
        if (Navigator.demandParentNode(this.wrappedNode) instanceof ReturnStmt) {
            ReturnStmt returnStmt = (ReturnStmt)Navigator.demandParentNode(this.wrappedNode);
            Optional optDeclaration = returnStmt.findAncestor(MethodDeclaration.class);
            if (optDeclaration.isPresent()) {
                ResolvedType t3 = JavaParserFacade.get(this.typeSolver).convertToUsage(((MethodDeclaration)optDeclaration.get()).asMethodDeclaration().getType());
                Optional<MethodUsage> functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod(t3);
                if (functionalMethod.isPresent()) {
                    ArrayList<ResolvedType> resolvedTypes = new ArrayList<ResolvedType>();
                    for (ResolvedType lambdaType : functionalMethod.get().getParamTypes()) {
                        HashMap<ResolvedTypeParameterDeclaration, ResolvedType> inferredTypes = new HashMap<ResolvedTypeParameterDeclaration, ResolvedType>();
                        if (lambdaType.isReferenceType()) {
                            for (Pair<ResolvedTypeParameterDeclaration, ResolvedType> entry : lambdaType.asReferenceType().getTypeParametersMap()) {
                                if (!((ResolvedType)entry.b).isTypeVariable() || !((ResolvedType)entry.b).asTypeParameter().declaredOnType()) continue;
                                ResolvedType ot = t3.asReferenceType().typeParametersMap().getValue((ResolvedTypeParameterDeclaration)entry.a);
                                lambdaType = lambdaType.replaceTypeVariables((ResolvedTypeParameterDeclaration)entry.a, ot, inferredTypes);
                            }
                        } else if (lambdaType.isTypeVariable() && lambdaType.asTypeParameter().declaredOnType()) {
                            lambdaType = t3.asReferenceType().typeParametersMap().getValue(lambdaType.asTypeParameter());
                        }
                        resolvedTypes.add(lambdaType);
                    }
                    return resolvedTypes;
                }
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    private List<ResolvedType> resolveLambdaTypes(ResolvedType lambdaType) {
        Optional<MethodUsage> functionalMethodOpt = FunctionalInterfaceLogic.getFunctionalMethod(lambdaType);
        if (functionalMethodOpt.isPresent()) {
            MethodUsage functionalMethod = functionalMethodOpt.get();
            ArrayList<ResolvedType> resolvedTypes = new ArrayList<ResolvedType>();
            for (ResolvedType type : functionalMethod.getParamTypes()) {
                InferenceContext inferenceContext = new InferenceContext(this.typeSolver);
                inferenceContext.addPair(new ReferenceTypeImpl(functionalMethod.declaringType()), lambdaType);
                ResolvedType argType = inferenceContext.resolve(inferenceContext.addSingle(type));
                ResolvedLambdaConstraintType conType = argType.isWildcard() ? ResolvedLambdaConstraintType.bound(argType.asWildcard().getBoundedType()) : ResolvedLambdaConstraintType.bound(argType);
                resolvedTypes.add(conType);
            }
            return resolvedTypes;
        }
        throw new UnsupportedOperationException();
    }
}

