/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javassistmodel;

import com.github.javaparser.resolution.Context;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParametrizable;
import com.github.javaparser.resolution.logic.MethodResolutionLogic;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedTypeVariable;
import com.github.javaparser.resolution.types.ResolvedVoidType;
import com.github.javaparser.resolution.types.ResolvedWildcard;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.ContextHelper;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistMethodDeclaration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;

class JavassistUtils {
    JavassistUtils() {
    }

    static Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver, Context invokationContext, List<ResolvedType> typeParameterValues, ResolvedReferenceTypeDeclaration scopeType, CtClass ctClass) {
        List<ResolvedTypeParameterDeclaration> typeParameters = scopeType.getTypeParameters();
        ArrayList<MethodUsage> methods = new ArrayList<MethodUsage>();
        for (CtMethod method : ctClass.getDeclaredMethods()) {
            if (!method.getName().equals(name) || (method.getMethodInfo().getAccessFlags() & 0x40) != 0 || (method.getMethodInfo().getAccessFlags() & 0x1000) != 0) continue;
            MethodUsage methodUsage = new MethodUsage(new JavassistMethodDeclaration(method, typeSolver));
            for (int i = 0; i < typeParameters.size() && i < typeParameterValues.size(); ++i) {
                ResolvedTypeParameterDeclaration tpToReplace = typeParameters.get(i);
                ResolvedType newValue = typeParameterValues.get(i);
                methodUsage = methodUsage.replaceTypeParameter(tpToReplace, newValue);
            }
            methods.add(methodUsage);
            if (!argumentsTypes.isEmpty() || methodUsage.getNoParams() != 0) continue;
            return Optional.of(methodUsage);
        }
        for (ResolvedReferenceType ancestor : scopeType.getAncestors()) {
            ancestor.getTypeDeclaration().flatMap(superClassTypeDeclaration -> ancestor.getTypeDeclaration()).flatMap(interfaceTypeDeclaration -> ContextHelper.solveMethodAsUsage(interfaceTypeDeclaration, name, argumentsTypes, invokationContext, typeParameterValues)).ifPresent(methods::add);
        }
        return MethodResolutionLogic.findMostApplicableUsage(methods, name, argumentsTypes, typeSolver);
    }

    static SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly, TypeSolver typeSolver, ResolvedReferenceTypeDeclaration scopeType, CtClass ctClass) {
        ArrayList<ResolvedMethodDeclaration> candidates = new ArrayList<ResolvedMethodDeclaration>();
        Predicate<CtMethod> staticOnlyCheck = m4 -> !staticOnly || java.lang.reflect.Modifier.isStatic(m4.getModifiers());
        for (CtMethod method : ctClass.getDeclaredMethods()) {
            boolean isNotBridge;
            boolean isSynthetic = method.getMethodInfo().getAttribute("Synthetic") != null;
            boolean bl = isNotBridge = (method.getMethodInfo().getAccessFlags() & 0x40) == 0;
            if (!method.getName().equals(name) || isSynthetic || !isNotBridge || !staticOnlyCheck.test(method)) continue;
            JavassistMethodDeclaration candidate = new JavassistMethodDeclaration(method, typeSolver);
            candidates.add(candidate);
            if (!argumentsTypes.isEmpty() || candidate.getNumberOfParams() != 0) continue;
            return SymbolReference.solved(candidate);
        }
        for (ResolvedReferenceType ancestorRefType : scopeType.getAncestors()) {
            SymbolReference<ResolvedMethodDeclaration> ancestorMethodRef;
            Optional<ResolvedReferenceTypeDeclaration> ancestorTypeDeclOpt = ancestorRefType.getTypeDeclaration();
            if (!ancestorTypeDeclOpt.isPresent() || !(ancestorMethodRef = MethodResolutionLogic.solveMethodInType(ancestorTypeDeclOpt.get(), name, argumentsTypes, staticOnly)).isSolved()) continue;
            candidates.add(ancestorMethodRef.getCorrespondingDeclaration());
        }
        return MethodResolutionLogic.findMostApplicable(candidates, name, argumentsTypes, typeSolver);
    }

    static ResolvedType signatureTypeToType(SignatureAttribute.Type signatureType, TypeSolver typeSolver, ResolvedTypeParametrizable typeParametrizable) {
        if (signatureType instanceof SignatureAttribute.ClassType) {
            SignatureAttribute.ClassType classType = (SignatureAttribute.ClassType)signatureType;
            List<ResolvedType> typeArguments = classType.getTypeArguments() == null ? Collections.emptyList() : Arrays.stream(classType.getTypeArguments()).map(ta -> JavassistUtils.typeArgumentToType(ta, typeSolver, typeParametrizable)).collect(Collectors.toList());
            ResolvedReferenceTypeDeclaration typeDeclaration = typeSolver.solveType(JavassistUtils.removeTypeArguments(JavassistUtils.internalNameToCanonicalName(JavassistUtils.getTypeName(classType))));
            return new ReferenceTypeImpl(typeDeclaration, typeArguments);
        }
        if (signatureType instanceof SignatureAttribute.TypeVariable) {
            SignatureAttribute.TypeVariable typeVariableSignature = (SignatureAttribute.TypeVariable)signatureType;
            Optional<ResolvedTypeParameterDeclaration> typeParameterDeclarationOpt = typeParametrizable.findTypeParameter(typeVariableSignature.getName());
            if (!typeParameterDeclarationOpt.isPresent()) {
                throw new UnsolvedSymbolException("Unable to solve TypeVariable " + typeVariableSignature);
            }
            ResolvedTypeParameterDeclaration typeParameterDeclaration = typeParameterDeclarationOpt.get();
            return new ResolvedTypeVariable(typeParameterDeclaration);
        }
        if (signatureType instanceof SignatureAttribute.ArrayType) {
            SignatureAttribute.ArrayType arrayType = (SignatureAttribute.ArrayType)signatureType;
            ResolvedType baseType = JavassistUtils.signatureTypeToType(arrayType.getComponentType(), typeSolver, typeParametrizable);
            return JavassistUtils.getArrayType(baseType, arrayType.getDimension());
        }
        if (signatureType instanceof SignatureAttribute.BaseType) {
            SignatureAttribute.BaseType baseType = (SignatureAttribute.BaseType)signatureType;
            if (baseType.toString().equals("void")) {
                return ResolvedVoidType.INSTANCE;
            }
            return ResolvedPrimitiveType.byName(baseType.toString());
        }
        throw new RuntimeException(signatureType.getClass().getCanonicalName());
    }

    private static ResolvedType getArrayType(ResolvedType resolvedType, int dimension) {
        if (dimension > 0) {
            return JavassistUtils.getArrayType(new ResolvedArrayType(resolvedType), --dimension);
        }
        return resolvedType;
    }

    private static String getTypeName(SignatureAttribute.ClassType classType) {
        SignatureAttribute.ClassType declaringClass = classType.getDeclaringClass();
        return declaringClass == null ? classType.getName() : JavassistUtils.getTypeName(declaringClass) + "." + classType.getName();
    }

    private static String removeTypeArguments(String typeName) {
        if (typeName.contains("<")) {
            return typeName.substring(0, typeName.indexOf(60));
        }
        return typeName;
    }

    static String internalNameToCanonicalName(String typeName) {
        return typeName.replaceAll("\\$", ".");
    }

    private static ResolvedType objectTypeArgumentToType(SignatureAttribute.ObjectType typeArgument, TypeSolver typeSolver, ResolvedTypeParametrizable typeParametrizable) {
        if (typeArgument instanceof SignatureAttribute.ClassType) {
            return JavassistUtils.signatureTypeToType(typeArgument, typeSolver, typeParametrizable);
        }
        if (typeArgument instanceof SignatureAttribute.ArrayType) {
            return new ResolvedArrayType(JavassistUtils.signatureTypeToType(((SignatureAttribute.ArrayType)typeArgument).getComponentType(), typeSolver, typeParametrizable));
        }
        String typeName = typeArgument.jvmTypeName();
        return JavassistUtils.getGenericParameterByName(typeName, typeParametrizable, typeSolver);
    }

    private static ResolvedType getGenericParameterByName(String typeName, ResolvedTypeParametrizable typeParametrizable, TypeSolver typeSolver) {
        Optional<ResolvedType> type = typeParametrizable.findTypeParameter(typeName).map(ResolvedTypeVariable::new);
        return type.orElseGet(() -> new ReferenceTypeImpl(typeSolver.solveType(JavassistUtils.removeTypeArguments(JavassistUtils.internalNameToCanonicalName(typeName)))));
    }

    private static ResolvedType typeArgumentToType(SignatureAttribute.TypeArgument typeArgument, TypeSolver typeSolver, ResolvedTypeParametrizable typeParametrizable) {
        if (typeArgument.isWildcard()) {
            if (typeArgument.getType() == null) {
                return ResolvedWildcard.UNBOUNDED;
            }
            if (typeArgument.getKind() == '+') {
                return ResolvedWildcard.extendsBound(JavassistUtils.objectTypeArgumentToType(typeArgument.getType(), typeSolver, typeParametrizable));
            }
            if (typeArgument.getKind() == '-') {
                return ResolvedWildcard.superBound(JavassistUtils.objectTypeArgumentToType(typeArgument.getType(), typeSolver, typeParametrizable));
            }
            throw new UnsupportedOperationException();
        }
        return JavassistUtils.objectTypeArgumentToType(typeArgument.getType(), typeSolver, typeParametrizable);
    }

    static Optional<String> extractParameterName(CtBehavior method, int paramNumber) {
        LocalVariableAttribute attr;
        MethodInfo methodInfo = method.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute != null && (attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable")) != null) {
            int pos = Modifier.isStatic(method.getModifiers()) ? 0 : 1;
            return JavassistUtils.getVariableName(attr, paramNumber + pos);
        }
        return Optional.empty();
    }

    private static Optional<String> getVariableName(LocalVariableAttribute attr, int pos) {
        try {
            return Optional.of(attr.variableNameByIndex(pos));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Optional.empty();
        }
    }
}

