/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.reflectionmodel;

import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedAnnotationMemberDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ReflectionAnnotationMemberDeclaration
implements ResolvedAnnotationMemberDeclaration {
    private static Map<Class<?>, Function<Object, ? extends Expression>> valueAsExpressionConverters = new HashMap();
    private Method annotationMember;
    private TypeSolver typeSolver;

    public ReflectionAnnotationMemberDeclaration(Method annotationMember, TypeSolver typeSolver) {
        this.annotationMember = annotationMember;
        this.typeSolver = typeSolver;
    }

    @Override
    public Expression getDefaultValue() {
        Object value = this.annotationMember.getDefaultValue();
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            Object[] values = (Object[])value;
            NodeList<Expression> expressions = Arrays.stream(values).map(this::transformDefaultValue).collect(NodeList.toNodeList());
            return new ArrayInitializerExpr(expressions);
        }
        return this.transformDefaultValue(value);
    }

    private Expression transformDefaultValue(Object value) {
        if (value instanceof Enum) {
            Class declaringClass = ((Enum)value).getDeclaringClass();
            String name = ((Enum)value).name();
            return new FieldAccessExpr(new NameExpr(declaringClass.getSimpleName()), name);
        }
        if (value instanceof Annotation) {
            Class<? extends Annotation> annotationType = ((Annotation)value).annotationType();
            Method[] declaredMethods = annotationType.getDeclaredMethods();
            NodeList<MemberValuePair> pairs = Arrays.stream(declaredMethods).map(m4 -> {
                ReflectionAnnotationMemberDeclaration nestedMemberDeclaration = new ReflectionAnnotationMemberDeclaration((Method)m4, this.typeSolver);
                return new MemberValuePair(m4.getName(), nestedMemberDeclaration.getDefaultValue());
            }).collect(NodeList.toNodeList());
            return new NormalAnnotationExpr(new Name(annotationType.getSimpleName()), pairs);
        }
        Function<Object, ? extends Expression> fn = valueAsExpressionConverters.get(value.getClass());
        if (fn == null) {
            throw new UnsupportedOperationException(String.format("Obtaining the default value of the annotation member %s (of type %s) is not supported yet.", this.annotationMember.getName(), value.getClass().getSimpleName()));
        }
        return fn.apply(value);
    }

    @Override
    public ResolvedType getType() {
        Class<?> returnType = this.annotationMember.getReturnType();
        if (returnType.isPrimitive()) {
            return ResolvedPrimitiveType.byName(returnType.getName());
        }
        SymbolReference<ResolvedReferenceTypeDeclaration> rrtd = this.typeSolver.tryToSolveType(returnType.getName());
        if (rrtd.isSolved()) {
            return new ReferenceTypeImpl(rrtd.getCorrespondingDeclaration());
        }
        throw new UnsupportedOperationException(String.format("Obtaining the type of the annotation member %s is not supported yet.", this.annotationMember.getName()));
    }

    @Override
    public String getName() {
        return this.annotationMember.getName();
    }

    static {
        valueAsExpressionConverters.put(Boolean.class, value -> new BooleanLiteralExpr((Boolean)value));
        valueAsExpressionConverters.put(Character.class, value -> new CharLiteralExpr(((Character)value).charValue()));
        valueAsExpressionConverters.put(Double.class, value -> new DoubleLiteralExpr((Double)value));
        valueAsExpressionConverters.put(Integer.class, value -> new IntegerLiteralExpr((Integer)value));
        valueAsExpressionConverters.put(Long.class, value -> new LongLiteralExpr((Long)value));
        valueAsExpressionConverters.put(String.class, value -> new StringLiteralExpr((String)value));
        valueAsExpressionConverters.put(Class.class, value -> {
            ClassOrInterfaceType type = new ClassOrInterfaceType(null, ((Class)value).getSimpleName());
            return new ClassExpr(type);
        });
    }
}

