/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.Context;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.Solver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.Value;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.SymbolResolutionCapability;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserClassDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserInterfaceDeclaration;
import com.github.javaparser.symbolsolver.logic.AbstractTypeDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionAnnotationDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionEnumDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionInterfaceDeclaration;
import java.util.List;
import java.util.Optional;

public class SymbolSolver
implements Solver {
    private final TypeSolver typeSolver;

    public SymbolSolver(TypeSolver typeSolver) {
        if (typeSolver == null) {
            throw new IllegalArgumentException("Missing Parameter - Cannot initialise a SymbolSolver, without a way to solve types.");
        }
        this.typeSolver = typeSolver;
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, Context context) {
        return context.solveSymbol(name);
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, Node node) {
        return this.solveSymbol(name, JavaParserFactory.getContext(node, this.typeSolver));
    }

    @Override
    public Optional<Value> solveSymbolAsValue(String name, Context context) {
        return context.solveSymbolAsValue(name);
    }

    @Override
    public Optional<Value> solveSymbolAsValue(String name, Node node) {
        Context context = JavaParserFactory.getContext(node, this.typeSolver);
        return this.solveSymbolAsValue(name, context);
    }

    @Override
    public SymbolReference<? extends ResolvedTypeDeclaration> solveType(String name, Context context) {
        return context.solveType(name);
    }

    @Override
    public SymbolReference<? extends ResolvedTypeDeclaration> solveType(String name, Node node) {
        return this.solveType(name, JavaParserFactory.getContext(node, this.typeSolver));
    }

    @Override
    public MethodUsage solveMethod(String methodName, List<ResolvedType> argumentsTypes, Context context) {
        SymbolReference<ResolvedMethodDeclaration> decl = context.solveMethod(methodName, argumentsTypes, false);
        if (!decl.isSolved()) {
            throw new UnsolvedSymbolException(context.toString(), methodName);
        }
        return new MethodUsage(decl.getCorrespondingDeclaration());
    }

    @Override
    public MethodUsage solveMethod(String methodName, List<ResolvedType> argumentsTypes, Node node) {
        return this.solveMethod(methodName, argumentsTypes, JavaParserFactory.getContext(node, this.typeSolver));
    }

    @Override
    public ResolvedTypeDeclaration solveType(Type type) {
        if (type instanceof ClassOrInterfaceType) {
            String name = ((ClassOrInterfaceType)type).getNameWithScope();
            SymbolReference<ResolvedTypeDeclaration> ref = JavaParserFactory.getContext(type, this.typeSolver).solveType(name);
            if (!ref.isSolved()) {
                throw new UnsolvedSymbolException(JavaParserFactory.getContext(type, this.typeSolver).toString(), name);
            }
            return ref.getCorrespondingDeclaration();
        }
        throw new UnsupportedOperationException(type.getClass().getCanonicalName());
    }

    @Override
    public ResolvedType solveTypeUsage(String name, Context context) {
        Optional<ResolvedType> genericType = context.solveGenericType(name);
        if (genericType.isPresent()) {
            return genericType.get();
        }
        ResolvedReferenceTypeDeclaration typeDeclaration = this.typeSolver.solveType(name);
        return new ReferenceTypeImpl(typeDeclaration);
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbolInType(ResolvedTypeDeclaration typeDeclaration, String name) {
        if (typeDeclaration instanceof SymbolResolutionCapability) {
            return ((SymbolResolutionCapability)((Object)typeDeclaration)).solveSymbol(name, this.typeSolver);
        }
        return SymbolReference.unsolved();
    }

    @Override
    @Deprecated
    public SymbolReference<ResolvedTypeDeclaration> solveTypeInType(ResolvedTypeDeclaration typeDeclaration, String name) {
        if (typeDeclaration instanceof JavaParserClassDeclaration) {
            return ((JavaParserClassDeclaration)typeDeclaration).solveType(name);
        }
        if (typeDeclaration instanceof JavaParserInterfaceDeclaration) {
            return ((JavaParserInterfaceDeclaration)typeDeclaration).solveType(name);
        }
        return SymbolReference.unsolved();
    }

    @Override
    public ResolvedType classToResolvedType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return ResolvedPrimitiveType.byName(clazz.getName());
        }
        AbstractTypeDeclaration declaration = clazz.isAnnotation() ? new ReflectionAnnotationDeclaration(clazz, this.typeSolver) : (clazz.isEnum() ? new ReflectionEnumDeclaration(clazz, this.typeSolver) : (clazz.isInterface() ? new ReflectionInterfaceDeclaration(clazz, this.typeSolver) : new ReflectionClassDeclaration(clazz, this.typeSolver)));
        return new ReferenceTypeImpl(declaration);
    }
}

