#
# Copyright 2020 Red Hat, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
"""Select EC2 instance types.

Information gleened from https://www.ec2instances.info/

"""

INSTANCE_TYPES = [
    {
        "family": "General Purpose",
        "inst_type": "a1.2xlarge",
        "memory": "16.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.204000",
        "rate": "0.204000",
        "saving": "0.102000",
    },
    {
        "family": "General Purpose",
        "inst_type": "a1.4xlarge",
        "memory": "32.0 GiB",
        "vcpu": "16",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.408000",
        "rate": "0.408000",
        "saving": "0.204000",
    },
    {
        "family": "General Purpose",
        "inst_type": "a1.large",
        "memory": "4.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.051000",
        "rate": "0.051000",
        "saving": "0.025000",
    },
    {
        "family": "General Purpose",
        "inst_type": "a1.medium",
        "memory": "2.0 GiB",
        "vcpu": "1",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.025500",
        "rate": "0.025500",
        "saving": "0.012600",
    },
    {
        "family": "General Purpose",
        "inst_type": "a1.metal",
        "memory": "32.0 GiB",
        "vcpu": "16",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.408000",
        "rate": "0.408000",
        "saving": "0.204000",
    },
    {
        "family": "General Purpose",
        "inst_type": "a1.xlarge",
        "memory": "8.0 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.102000",
        "rate": "0.102000",
        "saving": "0.051000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c1.medium",
        "memory": "1.7 GiB",
        "vcpu": "2",
        "storage": "350 GiB HDD + 900MB swap",
        "processor_arch": "32-bit",
        "cost": "0.130000",
        "rate": "0.130000",
        "saving": "0.070000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c1.medium",
        "memory": "1.7 GiB",
        "vcpu": "2",
        "storage": "350 GiB HDD + 900MB swap",
        "processor_arch": "64-bit",
        "cost": "0.130000",
        "rate": "0.130000",
        "saving": "0.070000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c1.xlarge",
        "memory": "7.0 GiB",
        "vcpu": "8",
        "storage": "1680 GiB (4 * 420 GiB HDD)",
        "processor_arch": "64-bit",
        "cost": "0.520000",
        "rate": "0.520000",
        "saving": "0.260000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c3.2xlarge",
        "memory": "15.0 GiB",
        "vcpu": "8",
        "storage": "160 GiB (2 * 80 GiB SSD)",
        "processor_arch": "64-bit",
        "cost": "0.420000",
        "rate": "0.420000",
        "saving": "0.210000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c3.4xlarge",
        "memory": "30.0 GiB",
        "vcpu": "16",
        "storage": "320 GiB (2 * 160 GiB SSD)",
        "processor_arch": "64-bit",
        "cost": "0.840000",
        "rate": "0.840000",
        "saving": "0.420000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c3.8xlarge",
        "memory": "60.0 GiB",
        "vcpu": "32",
        "storage": "640 GiB (2 * 320 GiB SSD)",
        "processor_arch": "64-bit",
        "cost": "1.680000",
        "rate": "1.680000",
        "saving": "0.840000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c3.large",
        "memory": "3.75 GiB",
        "vcpu": "2",
        "storage": "32 GiB (2 * 16 GiB SSD)",
        "processor_arch": "32-bit",
        "cost": "0.105000",
        "rate": "0.105000",
        "saving": "0.052500",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c3.large",
        "memory": "3.75 GiB",
        "vcpu": "2",
        "storage": "32 GiB (2 * 16 GiB SSD)",
        "processor_arch": "64-bit",
        "cost": "0.105000",
        "rate": "0.105000",
        "saving": "0.052500",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c3.xlarge",
        "memory": "7.5 GiB",
        "vcpu": "4",
        "storage": "80 GiB (2 * 40 GiB SSD)",
        "processor_arch": "64-bit",
        "cost": "0.210000",
        "rate": "0.210000",
        "saving": "0.105000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c4.2xlarge",
        "memory": "15.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.398000",
        "rate": "0.398000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c4.4xlarge",
        "memory": "30.0 GiB",
        "vcpu": "16",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.796000",
        "rate": "0.796000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c4.8xlarge",
        "memory": "60.0 GiB",
        "vcpu": "36",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "1.591000",
        "rate": "1.591000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c4.large",
        "memory": "3.75 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.100000",
        "rate": "0.100000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c4.xlarge",
        "memory": "7.5 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.199000",
        "rate": "0.199000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5.12xlarge",
        "memory": "96.0 GiB",
        "vcpu": "48",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "2.040000",
        "rate": "2.040000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5.18xlarge",
        "memory": "144.0 GiB",
        "vcpu": "72",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "3.060000",
        "rate": "3.060000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5.24xlarge",
        "memory": "192.0 GiB",
        "vcpu": "96",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "4.080000",
        "rate": "4.080000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5.2xlarge",
        "memory": "16.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.340000",
        "rate": "0.340000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5.4xlarge",
        "memory": "32.0 GiB",
        "vcpu": "16",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.680000",
        "rate": "0.680000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5.9xlarge",
        "memory": "72.0 GiB",
        "vcpu": "36",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "1.530000",
        "rate": "1.530000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5.large",
        "memory": "4.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.085000",
        "rate": "0.085000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5.metal",
        "memory": "192.0 GiB",
        "vcpu": "96",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "4.080000",
        "rate": "4.080000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5.xlarge",
        "memory": "8.0 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.170000",
        "rate": "0.170000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5d.12xlarge",
        "memory": "96.0 GiB",
        "vcpu": "48",
        "storage": "1800 GiB (2 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "2.304000",
        "rate": "2.304000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5d.18xlarge",
        "memory": "144.0 GiB",
        "vcpu": "72",
        "storage": "1800 GiB (2 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "3.456000",
        "rate": "3.456000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5d.24xlarge",
        "memory": "192.0 GiB",
        "vcpu": "96",
        "storage": "3600 GiB (4 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "4.608000",
        "rate": "4.608000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5d.2xlarge",
        "memory": "16.0 GiB",
        "vcpu": "8",
        "storage": "200 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.384000",
        "rate": "0.384000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5d.4xlarge",
        "memory": "32.0 GiB",
        "vcpu": "16",
        "storage": "400 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.768000",
        "rate": "0.768000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5d.9xlarge",
        "memory": "72.0 GiB",
        "vcpu": "36",
        "storage": "900 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "1.728000",
        "rate": "1.728000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5d.large",
        "memory": "4.0 GiB",
        "vcpu": "2",
        "storage": "50 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.096000",
        "rate": "0.096000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5d.metal",
        "memory": "192.0 GiB",
        "vcpu": "96",
        "storage": "3600 GiB (4 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "4.608000",
        "rate": "4.608000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5d.xlarge",
        "memory": "8.0 GiB",
        "vcpu": "4",
        "storage": "100 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.192000",
        "rate": "0.192000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5n.18xlarge",
        "memory": "192.0 GiB",
        "vcpu": "72",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "3.888000",
        "rate": "3.888000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5n.2xlarge",
        "memory": "21.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.432000",
        "rate": "0.432000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5n.4xlarge",
        "memory": "42.0 GiB",
        "vcpu": "16",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.864000",
        "rate": "0.864000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5n.9xlarge",
        "memory": "96.0 GiB",
        "vcpu": "36",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "1.944000",
        "rate": "1.944000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5n.large",
        "memory": "5.25 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.108000",
        "rate": "0.108000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5n.metal",
        "memory": "192.0 GiB",
        "vcpu": "72",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "3.888000",
        "rate": "3.888000",
        "saving": "0.199000",
    },
    {
        "family": "Compute Optimized",
        "inst_type": "c5n.xlarge",
        "memory": "10.5 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.216000",
        "rate": "0.216000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "d2.2xlarge",
        "memory": "61.0 GiB",
        "vcpu": "8",
        "storage": "12000 GiB (6 * 2000 GiB HDD)",
        "processor_arch": "64-bit",
        "cost": "1.380000",
        "rate": "1.380000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "d2.4xlarge",
        "memory": "122.0 GiB",
        "vcpu": "16",
        "storage": "24000 GiB (12 * 2000 GiB HDD)",
        "processor_arch": "64-bit",
        "cost": "2.760000",
        "rate": "2.760000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "d2.8xlarge",
        "memory": "244.0 GiB",
        "vcpu": "36",
        "storage": "48000 GiB (24 * 2000 GiB HDD)",
        "processor_arch": "64-bit",
        "cost": "5.520000",
        "rate": "5.520000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "d2.xlarge",
        "memory": "30.5 GiB",
        "vcpu": "4",
        "storage": "6000 GiB (3 * 2000 GiB HDD)",
        "processor_arch": "64-bit",
        "cost": "0.690000",
        "rate": "0.690000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "f1.16xlarge",
        "memory": "976.0 GiB",
        "vcpu": "64",
        "storage": "3760 GiB (4 * 940 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "13.200000",
        "rate": "13.200000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "f1.2xlarge",
        "memory": "122.0 GiB",
        "vcpu": "8",
        "storage": "470 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "1.650000",
        "rate": "1.650000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "f1.4xlarge",
        "memory": "244.0 GiB",
        "vcpu": "16",
        "storage": "940 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "3.300000",
        "rate": "3.300000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "g3.16xlarge",
        "memory": "488.0 GiB",
        "vcpu": "64",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "4.560000",
        "rate": "4.560000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "g3.4xlarge",
        "memory": "122.0 GiB",
        "vcpu": "16",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "1.140000",
        "rate": "1.140000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "g3.8xlarge",
        "memory": "244.0 GiB",
        "vcpu": "32",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "2.280000",
        "rate": "2.280000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "g3s.xlarge",
        "memory": "30.5 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.750000",
        "rate": "0.750000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "g4dn.12xlarge",
        "memory": "192.0 GiB",
        "vcpu": "48",
        "storage": "900 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "3.912000",
        "rate": "3.912000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "g4dn.16xlarge",
        "memory": "256.0 GiB",
        "vcpu": "64",
        "storage": "900 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "4.352000",
        "rate": "4.352000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "g4dn.2xlarge",
        "memory": "32.0 GiB",
        "vcpu": "8",
        "storage": "225 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.752000",
        "rate": "0.752000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "g4dn.4xlarge",
        "memory": "64.0 GiB",
        "vcpu": "16",
        "storage": "225 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "1.204000",
        "rate": "1.204000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "g4dn.8xlarge",
        "memory": "128.0 GiB",
        "vcpu": "32",
        "storage": "900 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "2.176000",
        "rate": "2.176000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "g4dn.xlarge",
        "memory": "16.0 GiB",
        "vcpu": "4",
        "storage": "125 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.526000",
        "rate": "0.526000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "h1.16xlarge",
        "memory": "256.0 GiB",
        "vcpu": "64",
        "storage": "16000 GiB (8 * 2000 GiB HDD)",
        "processor_arch": "64-bit",
        "cost": "3.744000",
        "rate": "3.744000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "h1.2xlarge",
        "memory": "32.0 GiB",
        "vcpu": "8",
        "storage": "2000 GiB HDD",
        "processor_arch": "64-bit",
        "cost": "0.468000",
        "rate": "0.468000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "h1.4xlarge",
        "memory": "64.0 GiB",
        "vcpu": "16",
        "storage": "4000 GiB (2 * 2000 GiB HDD)",
        "processor_arch": "64-bit",
        "cost": "0.936000",
        "rate": "0.936000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "h1.8xlarge",
        "memory": "128.0 GiB",
        "vcpu": "32",
        "storage": "8000 GiB (4 * 2000 GiB HDD)",
        "processor_arch": "64-bit",
        "cost": "1.872000",
        "rate": "1.872000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "i3.16xlarge",
        "memory": "488.0 GiB",
        "vcpu": "64",
        "storage": "15200 GiB (8 * 1900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "4.992000",
        "rate": "4.992000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "i3.2xlarge",
        "memory": "61.0 GiB",
        "vcpu": "8",
        "storage": "1900 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.624000",
        "rate": "0.624000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "i3.4xlarge",
        "memory": "122.0 GiB",
        "vcpu": "16",
        "storage": "3800 GiB (2 * 1900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "1.248000",
        "rate": "1.248000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "i3.8xlarge",
        "memory": "244.0 GiB",
        "vcpu": "32",
        "storage": "7600 GiB (4 * 1900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "2.496000",
        "rate": "2.496000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "i3.large",
        "memory": "15.25 GiB",
        "vcpu": "2",
        "storage": "475 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.156000",
        "rate": "0.156000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "i3.metal",
        "memory": "512.0 GiB",
        "vcpu": "72",
        "storage": "15200 GiB (8 * 1900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "4.992000",
        "rate": "4.992000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "i3.xlarge",
        "memory": "30.5 GiB",
        "vcpu": "4",
        "storage": "950 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.312000",
        "rate": "0.312000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "i3en.12xlarge",
        "memory": "384.0 GiB",
        "vcpu": "48",
        "storage": "30000 GiB (4 * 7500 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "5.424000",
        "rate": "5.424000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "i3en.24xlarge",
        "memory": "768.0 GiB",
        "vcpu": "96",
        "storage": "60000 GiB (8 * 7500 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "10.848000",
        "rate": "10.848000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "i3en.2xlarge",
        "memory": "64.0 GiB",
        "vcpu": "8",
        "storage": "5000 GiB (2 * 2500 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "0.904000",
        "rate": "0.904000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "i3en.3xlarge",
        "memory": "96.0 GiB",
        "vcpu": "12",
        "storage": "7500 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "1.356000",
        "rate": "1.356000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "i3en.6xlarge",
        "memory": "192.0 GiB",
        "vcpu": "24",
        "storage": "15000 GiB (2 * 7500 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "2.712000",
        "rate": "2.712000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "i3en.large",
        "memory": "16.0 GiB",
        "vcpu": "2",
        "storage": "1250 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.226000",
        "rate": "0.226000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "i3en.metal",
        "memory": "768.0 GiB",
        "vcpu": "96",
        "storage": "60000 GiB (8 * 7500 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "10.848000",
        "rate": "10.848000",
        "saving": "0.199000",
    },
    {
        "family": "Storage Optimized",
        "inst_type": "i3en.xlarge",
        "memory": "32.0 GiB",
        "vcpu": "4",
        "storage": "2500 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.452000",
        "rate": "0.452000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m4.10xlarge",
        "memory": "160.0 GiB",
        "vcpu": "40",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "2.000000",
        "rate": "2.000000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m4.16xlarge",
        "memory": "256.0 GiB",
        "vcpu": "64",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "3.200000",
        "rate": "3.200000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m4.2xlarge",
        "memory": "32.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.400000",
        "rate": "0.400000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m4.4xlarge",
        "memory": "64.0 GiB",
        "vcpu": "16",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.800000",
        "rate": "0.800000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m4.large",
        "memory": "8.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.100000",
        "rate": "0.100000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m4.xlarge",
        "memory": "16.0 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.200000",
        "rate": "0.200000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5.12xlarge",
        "memory": "192.0 GiB",
        "vcpu": "48",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "2.304000",
        "rate": "2.304000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5.16xlarge",
        "memory": "256.0 GiB",
        "vcpu": "64",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "3.072000",
        "rate": "3.072000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5.24xlarge",
        "memory": "384.0 GiB",
        "vcpu": "96",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "4.608000",
        "rate": "4.608000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5.2xlarge",
        "memory": "32.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.384000",
        "rate": "0.384000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5.4xlarge",
        "memory": "64.0 GiB",
        "vcpu": "16",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.768000",
        "rate": "0.768000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5.8xlarge",
        "memory": "128.0 GiB",
        "vcpu": "32",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "1.536000",
        "rate": "1.536000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5.large",
        "memory": "8.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.096000",
        "rate": "0.096000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5.metal",
        "memory": "384.0 GiB",
        "vcpu": "96",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "4.608000",
        "rate": "4.608000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5.xlarge",
        "memory": "16.0 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.192000",
        "rate": "0.192000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5a.12xlarge",
        "memory": "192.0 GiB",
        "vcpu": "48",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "2.064000",
        "rate": "2.064000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5a.16xlarge",
        "memory": "256.0 GiB",
        "vcpu": "64",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "2.752000",
        "rate": "2.752000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5a.24xlarge",
        "memory": "384.0 GiB",
        "vcpu": "96",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "4.128000",
        "rate": "4.128000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5a.2xlarge",
        "memory": "32.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.344000",
        "rate": "0.344000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5a.4xlarge",
        "memory": "64.0 GiB",
        "vcpu": "16",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.688000",
        "rate": "0.688000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5a.8xlarge",
        "memory": "128.0 GiB",
        "vcpu": "32",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "1.376000",
        "rate": "1.376000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5a.large",
        "memory": "8.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.086000",
        "rate": "0.086000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5a.xlarge",
        "memory": "16.0 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.172000",
        "rate": "0.172000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5ad.12xlarge",
        "memory": "192.0 GiB",
        "vcpu": "48",
        "storage": "1800 GiB (2 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "2.472000",
        "rate": "2.472000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5ad.24xlarge",
        "memory": "384.0 GiB",
        "vcpu": "96",
        "storage": "3600 GiB (4 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "4.944000",
        "rate": "4.944000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5ad.2xlarge",
        "memory": "32.0 GiB",
        "vcpu": "8",
        "storage": "300 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.412000",
        "rate": "0.412000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5ad.4xlarge",
        "memory": "64.0 GiB",
        "vcpu": "16",
        "storage": "600 GiB (2 * 300 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "0.824000",
        "rate": "0.824000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5ad.large",
        "memory": "8.0 GiB",
        "vcpu": "2",
        "storage": "75 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.103000",
        "rate": "0.103000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5ad.xlarge",
        "memory": "16.0 GiB",
        "vcpu": "4",
        "storage": "150 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.206000",
        "rate": "0.206000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5d.12xlarge",
        "memory": "192.0 GiB",
        "vcpu": "48",
        "storage": "1800 GiB (2 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "2.712000",
        "rate": "2.712000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5d.16xlarge",
        "memory": "256.0 GiB",
        "vcpu": "64",
        "storage": "2400 GiB (4 * 600 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "3.616000",
        "rate": "3.616000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5d.24xlarge",
        "memory": "384.0 GiB",
        "vcpu": "96",
        "storage": "3600 GiB (4 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "5.424000",
        "rate": "5.424000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5d.2xlarge",
        "memory": "32.0 GiB",
        "vcpu": "8",
        "storage": "300 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.452000",
        "rate": "0.452000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5d.4xlarge",
        "memory": "64.0 GiB",
        "vcpu": "16",
        "storage": "600 GiB (2 * 300 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "0.904000",
        "rate": "0.904000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5d.8xlarge",
        "memory": "128.0 GiB",
        "vcpu": "32",
        "storage": "1200 GiB (2 * 600 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "1.808000",
        "rate": "1.808000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5d.large",
        "memory": "8.0 GiB",
        "vcpu": "2",
        "storage": "75 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.113000",
        "rate": "0.113000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5d.metal",
        "memory": "384.0 GiB",
        "vcpu": "96",
        "storage": "3600 GiB (4 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "5.424000",
        "rate": "5.424000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5d.xlarge",
        "memory": "16.0 GiB",
        "vcpu": "4",
        "storage": "150 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.226000",
        "rate": "0.226000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5dn.12xlarge",
        "memory": "192.0 GiB",
        "vcpu": "48",
        "storage": "1800 GiB (2 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "3.264000",
        "rate": "3.264000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5dn.16xlarge",
        "memory": "256.0 GiB",
        "vcpu": "64",
        "storage": "2400 GiB (4 * 600 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "4.352000",
        "rate": "4.352000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5dn.24xlarge",
        "memory": "384.0 GiB",
        "vcpu": "96",
        "storage": "3600 GiB (4 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "6.528000",
        "rate": "6.528000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5dn.2xlarge",
        "memory": "32.0 GiB",
        "vcpu": "8",
        "storage": "300 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.544000",
        "rate": "0.544000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5dn.4xlarge",
        "memory": "64.0 GiB",
        "vcpu": "16",
        "storage": "600 GiB (2 * 300 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "1.088000",
        "rate": "1.088000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5dn.8xlarge",
        "memory": "128.0 GiB",
        "vcpu": "32",
        "storage": "1200 GiB (2 * 600 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "2.176000",
        "rate": "2.176000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5dn.large",
        "memory": "8.0 GiB",
        "vcpu": "2",
        "storage": "75 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.136000",
        "rate": "0.136000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5dn.xlarge",
        "memory": "16.0 GiB",
        "vcpu": "4",
        "storage": "150 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.272000",
        "rate": "0.272000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5n.12xlarge",
        "memory": "192.0 GiB",
        "vcpu": "48",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "2.856000",
        "rate": "2.856000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5n.16xlarge",
        "memory": "256.0 GiB",
        "vcpu": "64",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "3.808000",
        "rate": "3.808000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5n.24xlarge",
        "memory": "384.0 GiB",
        "vcpu": "96",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "5.712000",
        "rate": "5.712000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5n.2xlarge",
        "memory": "32.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.476000",
        "rate": "0.476000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5n.4xlarge",
        "memory": "64.0 GiB",
        "vcpu": "16",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.952000",
        "rate": "0.952000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5n.8xlarge",
        "memory": "128.0 GiB",
        "vcpu": "32",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "1.904000",
        "rate": "1.904000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5n.large",
        "memory": "8.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.119000",
        "rate": "0.119000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "m5n.xlarge",
        "memory": "16.0 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.238000",
        "rate": "0.238000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "p2.16xlarge",
        "memory": "768.0 GiB",
        "vcpu": "64",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "14.400000",
        "rate": "14.400000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "p2.8xlarge",
        "memory": "488.0 GiB",
        "vcpu": "32",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "7.200000",
        "rate": "7.200000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "p2.xlarge",
        "memory": "61.0 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.900000",
        "rate": "0.900000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "p3.16xlarge",
        "memory": "488.0 GiB",
        "vcpu": "64",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "24.480000",
        "rate": "24.480000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "p3.2xlarge",
        "memory": "61.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "3.060000",
        "rate": "3.060000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "p3.8xlarge",
        "memory": "244.0 GiB",
        "vcpu": "32",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "12.240000",
        "rate": "12.240000",
        "saving": "0.199000",
    },
    {
        "family": "Accelerated Computing",
        "inst_type": "p3dn.24xlarge",
        "memory": "768.0 GiB",
        "vcpu": "96",
        "storage": "1800 GiB (2 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "31.212000",
        "rate": "31.212000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r3.2xlarge",
        "memory": "61.0 GiB",
        "vcpu": "8",
        "storage": "160 GiB SSD",
        "processor_arch": "64-bit",
        "cost": "0.665000",
        "rate": "0.665000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r3.4xlarge",
        "memory": "122.0 GiB",
        "vcpu": "16",
        "storage": "320 GiB SSD",
        "processor_arch": "64-bit",
        "cost": "1.330000",
        "rate": "1.330000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r3.8xlarge",
        "memory": "244.0 GiB",
        "vcpu": "32",
        "storage": "640 GiB (2 * 320 GiB SSD)",
        "processor_arch": "64-bit",
        "cost": "2.660000",
        "rate": "2.660000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r3.large",
        "memory": "15.25 GiB",
        "vcpu": "2",
        "storage": "32 GiB SSD",
        "processor_arch": "64-bit",
        "cost": "0.166000",
        "rate": "0.166000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r3.xlarge",
        "memory": "30.5 GiB",
        "vcpu": "4",
        "storage": "80 GiB SSD",
        "processor_arch": "64-bit",
        "cost": "0.333000",
        "rate": "0.333000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r4.16xlarge",
        "memory": "488.0 GiB",
        "vcpu": "64",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "4.256000",
        "rate": "4.256000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r4.2xlarge",
        "memory": "61.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.532000",
        "rate": "0.532000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r4.4xlarge",
        "memory": "122.0 GiB",
        "vcpu": "16",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "1.064000",
        "rate": "1.064000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r4.8xlarge",
        "memory": "244.0 GiB",
        "vcpu": "32",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "2.128000",
        "rate": "2.128000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r4.large",
        "memory": "15.25 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.133000",
        "rate": "0.133000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r4.xlarge",
        "memory": "30.5 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.266000",
        "rate": "0.266000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5.12xlarge",
        "memory": "384.0 GiB",
        "vcpu": "48",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "3.024000",
        "rate": "3.024000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5.16xlarge",
        "memory": "512.0 GiB",
        "vcpu": "64",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "4.032000",
        "rate": "4.032000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5.24xlarge",
        "memory": "768.0 GiB",
        "vcpu": "96",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "6.048000",
        "rate": "6.048000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5.2xlarge",
        "memory": "64.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.504000",
        "rate": "0.504000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5.4xlarge",
        "memory": "128.0 GiB",
        "vcpu": "16",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "1.008000",
        "rate": "1.008000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5.8xlarge",
        "memory": "256.0 GiB",
        "vcpu": "32",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "2.016000",
        "rate": "2.016000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5.large",
        "memory": "16.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.126000",
        "rate": "0.126000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5.metal",
        "memory": "768.0 GiB",
        "vcpu": "96",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "6.048000",
        "rate": "6.048000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5.xlarge",
        "memory": "32.0 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.252000",
        "rate": "0.252000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5a.12xlarge",
        "memory": "384.0 GiB",
        "vcpu": "48",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "2.712000",
        "rate": "2.712000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5a.16xlarge",
        "memory": "512.0 GiB",
        "vcpu": "64",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "3.616000",
        "rate": "3.616000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5a.24xlarge",
        "memory": "768.0 GiB",
        "vcpu": "96",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "5.424000",
        "rate": "5.424000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5a.2xlarge",
        "memory": "64.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.452000",
        "rate": "0.452000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5a.4xlarge",
        "memory": "128.0 GiB",
        "vcpu": "16",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.904000",
        "rate": "0.904000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5a.8xlarge",
        "memory": "256.0 GiB",
        "vcpu": "32",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "1.808000",
        "rate": "1.808000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5a.large",
        "memory": "16.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.113000",
        "rate": "0.113000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5a.xlarge",
        "memory": "32.0 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.226000",
        "rate": "0.226000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5ad.12xlarge",
        "memory": "384.0 GiB",
        "vcpu": "48",
        "storage": "1800 GiB (2 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "3.144000",
        "rate": "3.144000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5ad.24xlarge",
        "memory": "768.0 GiB",
        "vcpu": "96",
        "storage": "3600 GiB (4 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "6.288000",
        "rate": "6.288000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5ad.2xlarge",
        "memory": "64.0 GiB",
        "vcpu": "8",
        "storage": "300 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.524000",
        "rate": "0.524000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5ad.4xlarge",
        "memory": "128.0 GiB",
        "vcpu": "16",
        "storage": "600 GiB (2 * 300 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "1.048000",
        "rate": "1.048000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5ad.large",
        "memory": "16.0 GiB",
        "vcpu": "2",
        "storage": "75 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.131000",
        "rate": "0.131000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5ad.xlarge",
        "memory": "32.0 GiB",
        "vcpu": "4",
        "storage": "150 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.262000",
        "rate": "0.262000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5d.12xlarge",
        "memory": "384.0 GiB",
        "vcpu": "48",
        "storage": "1800 GiB (2 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "3.456000",
        "rate": "3.456000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5d.16xlarge",
        "memory": "512.0 GiB",
        "vcpu": "64",
        "storage": "2400 GiB (4 * 600 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "4.608000",
        "rate": "4.608000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5d.24xlarge",
        "memory": "768.0 GiB",
        "vcpu": "96",
        "storage": "3600 GiB (4 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "6.912000",
        "rate": "6.912000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5d.2xlarge",
        "memory": "64.0 GiB",
        "vcpu": "8",
        "storage": "300 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.576000",
        "rate": "0.576000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5d.4xlarge",
        "memory": "128.0 GiB",
        "vcpu": "16",
        "storage": "600 GiB (2 * 300 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "1.152000",
        "rate": "1.152000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5d.8xlarge",
        "memory": "256.0 GiB",
        "vcpu": "32",
        "storage": "1200 GiB (2 * 600 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "2.304000",
        "rate": "2.304000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5d.large",
        "memory": "16.0 GiB",
        "vcpu": "2",
        "storage": "75 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.144000",
        "rate": "0.144000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5d.metal",
        "memory": "768.0 GiB",
        "vcpu": "96",
        "storage": "3600 GiB (4 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "6.912000",
        "rate": "6.912000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5d.xlarge",
        "memory": "32.0 GiB",
        "vcpu": "4",
        "storage": "150 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.288000",
        "rate": "0.288000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5dn.12xlarge",
        "memory": "384.0 GiB",
        "vcpu": "48",
        "storage": "1800 GiB (2 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "4.008000",
        "rate": "4.008000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5dn.16xlarge",
        "memory": "512.0 GiB",
        "vcpu": "64",
        "storage": "2400 GiB (4 * 600 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "5.344000",
        "rate": "5.344000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5dn.24xlarge",
        "memory": "768.0 GiB",
        "vcpu": "96",
        "storage": "3600 GiB (4 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "8.016000",
        "rate": "8.016000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5dn.2xlarge",
        "memory": "64.0 GiB",
        "vcpu": "8",
        "storage": "300 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.668000",
        "rate": "0.668000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5dn.4xlarge",
        "memory": "128.0 GiB",
        "vcpu": "16",
        "storage": "600 GiB (2 * 300 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "1.336000",
        "rate": "1.336000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5dn.8xlarge",
        "memory": "256.0 GiB",
        "vcpu": "32",
        "storage": "1200 GiB (2 * 600 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "2.672000",
        "rate": "2.672000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5dn.large",
        "memory": "16.0 GiB",
        "vcpu": "2",
        "storage": "75 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.167000",
        "rate": "0.167000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5dn.xlarge",
        "memory": "32.0 GiB",
        "vcpu": "4",
        "storage": "150 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.334000",
        "rate": "0.334000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5n.12xlarge",
        "memory": "384.0 GiB",
        "vcpu": "48",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "3.576000",
        "rate": "3.576000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5n.16xlarge",
        "memory": "512.0 GiB",
        "vcpu": "64",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "4.768000",
        "rate": "4.768000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5n.24xlarge",
        "memory": "768.0 GiB",
        "vcpu": "96",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "7.152000",
        "rate": "7.152000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5n.2xlarge",
        "memory": "64.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.596000",
        "rate": "0.596000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5n.4xlarge",
        "memory": "128.0 GiB",
        "vcpu": "16",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "1.192000",
        "rate": "1.192000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5n.8xlarge",
        "memory": "256.0 GiB",
        "vcpu": "32",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "2.384000",
        "rate": "2.384000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5n.large",
        "memory": "16.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.149000",
        "rate": "0.149000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "r5n.xlarge",
        "memory": "32.0 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.298000",
        "rate": "0.298000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t2.2xlarge",
        "memory": "32.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.371200",
        "rate": "0.371200",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t2.large",
        "memory": "8.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.092800",
        "rate": "0.092800",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t2.medium",
        "memory": "4.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "32-bit",
        "cost": "0.046400",
        "rate": "0.046400",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t2.medium",
        "memory": "4.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.046400",
        "rate": "0.046400",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t2.micro",
        "memory": "1.0 GiB",
        "vcpu": "1",
        "storage": "EBS only",
        "processor_arch": "32-bit",
        "cost": "0.011600",
        "rate": "0.011600",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t2.micro",
        "memory": "1.0 GiB",
        "vcpu": "1",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.011600",
        "rate": "0.011600",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t2.small",
        "memory": "2.0 GiB",
        "vcpu": "1",
        "storage": "EBS only",
        "processor_arch": "32-bit",
        "cost": "0.023000",
        "rate": "0.023000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t2.small",
        "memory": "2.0 GiB",
        "vcpu": "1",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.023000",
        "rate": "0.023000",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t2.xlarge",
        "memory": "16.0 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.185600",
        "rate": "0.185600",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t3.2xlarge",
        "memory": "32.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.332800",
        "rate": "0.332800",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t3.large",
        "memory": "8.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.083200",
        "rate": "0.083200",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t3.medium",
        "memory": "4.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.041600",
        "rate": "0.041600",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t3.micro",
        "memory": "1.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.010400",
        "rate": "0.010400",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t3.small",
        "memory": "2.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.020800",
        "rate": "0.020800",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t3.xlarge",
        "memory": "16.0 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.166400",
        "rate": "0.166400",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t3a.2xlarge",
        "memory": "32.0 GiB",
        "vcpu": "8",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.300800",
        "rate": "0.300800",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t3a.large",
        "memory": "8.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.075200",
        "rate": "0.075200",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t3a.medium",
        "memory": "4.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.037600",
        "rate": "0.037600",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t3a.micro",
        "memory": "1.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.009400",
        "rate": "0.009400",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t3a.small",
        "memory": "2.0 GiB",
        "vcpu": "2",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.018800",
        "rate": "0.018800",
        "saving": "0.199000",
    },
    {
        "family": "General Purpose",
        "inst_type": "t3a.xlarge",
        "memory": "16.0 GiB",
        "vcpu": "4",
        "storage": "EBS only",
        "processor_arch": "64-bit",
        "cost": "0.150400",
        "rate": "0.150400",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "x1.16xlarge",
        "memory": "976.0 GiB",
        "vcpu": "64",
        "storage": "1920 GiB SSD",
        "processor_arch": "64-bit",
        "cost": "6.669000",
        "rate": "6.669000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "x1.32xlarge",
        "memory": "1952.0 GiB",
        "vcpu": "128",
        "storage": "3840 GiB (2 * 1920 GiB SSD)",
        "processor_arch": "64-bit",
        "cost": "13.338000",
        "rate": "13.338000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "x1e.16xlarge",
        "memory": "1952.0 GiB",
        "vcpu": "64",
        "storage": "1920 GiB SSD",
        "processor_arch": "64-bit",
        "cost": "13.344000",
        "rate": "13.344000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "x1e.2xlarge",
        "memory": "244.0 GiB",
        "vcpu": "8",
        "storage": "240 GiB SSD",
        "processor_arch": "64-bit",
        "cost": "1.668000",
        "rate": "1.668000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "x1e.4xlarge",
        "memory": "488.0 GiB",
        "vcpu": "16",
        "storage": "480 GiB SSD",
        "processor_arch": "64-bit",
        "cost": "3.336000",
        "rate": "3.336000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "x1e.8xlarge",
        "memory": "976.0 GiB",
        "vcpu": "32",
        "storage": "960 GiB SSD",
        "processor_arch": "64-bit",
        "cost": "6.672000",
        "rate": "6.672000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "x1e.xlarge",
        "memory": "122.0 GiB",
        "vcpu": "4",
        "storage": "120 GiB SSD",
        "processor_arch": "64-bit",
        "cost": "0.834000",
        "rate": "0.834000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "z1d.12xlarge",
        "memory": "384.0 GiB",
        "vcpu": "48",
        "storage": "1800 GiB (2 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "4.464000",
        "rate": "4.464000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "z1d.2xlarge",
        "memory": "64.0 GiB",
        "vcpu": "8",
        "storage": "300 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.744000",
        "rate": "0.744000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "z1d.3xlarge",
        "memory": "96.0 GiB",
        "vcpu": "12",
        "storage": "450 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "1.116000",
        "rate": "1.116000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "z1d.6xlarge",
        "memory": "192.0 GiB",
        "vcpu": "24",
        "storage": "900 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "2.232000",
        "rate": "2.232000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "z1d.large",
        "memory": "16.0 GiB",
        "vcpu": "2",
        "storage": "75 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.186000",
        "rate": "0.186000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "z1d.metal",
        "memory": "384.0 GiB",
        "vcpu": "48",
        "storage": "1800 GiB (2 * 900 GiB NVMe SSD)",
        "processor_arch": "64-bit",
        "cost": "4.464000",
        "rate": "4.464000",
        "saving": "0.199000",
    },
    {
        "family": "Memory Optimized",
        "inst_type": "z1d.xlarge",
        "memory": "32.0 GiB",
        "vcpu": "4",
        "storage": "150 GiB NVMe SSD",
        "processor_arch": "64-bit",
        "cost": "0.372000",
        "rate": "0.372000",
        "saving": "0.199000",
    },
]
