# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_activity_logs_post200_response_details_inner import V1ActivityLogsPost200ResponseDetailsInner
from graphiant_sdk.models.v1_activity_logs_post200_response_filter_entities_value import V1ActivityLogsPost200ResponseFilterEntitiesValue
from typing import Optional, Set
from typing_extensions import Self

class V1ActivityLogsPost200Response(BaseModel):
    """
    V1ActivityLogsPost200Response
    """ # noqa: E501
    cursor_ref: Optional[StrictStr] = Field(default=None, alias="cursorRef")
    details: Optional[List[V1ActivityLogsPost200ResponseDetailsInner]] = None
    filter_entities: Optional[Dict[str, V1ActivityLogsPost200ResponseFilterEntitiesValue]] = Field(default=None, alias="filterEntities")
    filter_job_types: Optional[List[StrictStr]] = Field(default=None, alias="filterJobTypes")
    total_logs: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="totalLogs")
    __properties: ClassVar[List[str]] = ["cursorRef", "details", "filterEntities", "filterJobTypes", "totalLogs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1ActivityLogsPost200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in details (list)
        _items = []
        if self.details:
            for _item_details in self.details:
                if _item_details:
                    _items.append(_item_details.to_dict())
            _dict['details'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in filter_entities (dict)
        _field_dict = {}
        if self.filter_entities:
            for _key_filter_entities in self.filter_entities:
                if self.filter_entities[_key_filter_entities]:
                    _field_dict[_key_filter_entities] = self.filter_entities[_key_filter_entities].to_dict()
            _dict['filterEntities'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1ActivityLogsPost200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cursorRef": obj.get("cursorRef"),
            "details": [V1ActivityLogsPost200ResponseDetailsInner.from_dict(_item) for _item in obj["details"]] if obj.get("details") is not None else None,
            "filterEntities": dict(
                (_k, V1ActivityLogsPost200ResponseFilterEntitiesValue.from_dict(_v))
                for _k, _v in obj["filterEntities"].items()
            )
            if obj.get("filterEntities") is not None
            else None,
            "filterJobTypes": obj.get("filterJobTypes"),
            "totalLogs": obj.get("totalLogs")
        })
        return _obj


