# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_activity_logs_post200_response_details_inner_targets_inner_events_inner import V1ActivityLogsPost200ResponseDetailsInnerTargetsInnerEventsInner
from graphiant_sdk.models.v1_activity_logs_post_request_selector_job_entity import V1ActivityLogsPostRequestSelectorJobEntity
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from typing import Optional, Set
from typing_extensions import Self

class V1ActivityLogsPost200ResponseDetailsInnerTargetsInner(BaseModel):
    """
    V1ActivityLogsPost200ResponseDetailsInnerTargetsInner
    """ # noqa: E501
    detailed_failure_reason: Optional[StrictStr] = Field(default=None, alias="detailedFailureReason")
    end_ts: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="endTs")
    events: Optional[List[V1ActivityLogsPost200ResponseDetailsInnerTargetsInnerEventsInner]] = None
    failure_reason: Optional[StrictStr] = Field(default=None, alias="failureReason")
    ids: Optional[List[V1ActivityLogsPostRequestSelectorJobEntity]] = None
    start_ts: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="startTs")
    status: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["detailedFailureReason", "endTs", "events", "failureReason", "ids", "startTs", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1ActivityLogsPost200ResponseDetailsInnerTargetsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of end_ts
        if self.end_ts:
            _dict['endTs'] = self.end_ts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in events (list)
        _items = []
        if self.events:
            for _item_events in self.events:
                if _item_events:
                    _items.append(_item_events.to_dict())
            _dict['events'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in ids (list)
        _items = []
        if self.ids:
            for _item_ids in self.ids:
                if _item_ids:
                    _items.append(_item_ids.to_dict())
            _dict['ids'] = _items
        # override the default output from pydantic by calling `to_dict()` of start_ts
        if self.start_ts:
            _dict['startTs'] = self.start_ts.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1ActivityLogsPost200ResponseDetailsInnerTargetsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "detailedFailureReason": obj.get("detailedFailureReason"),
            "endTs": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["endTs"]) if obj.get("endTs") is not None else None,
            "events": [V1ActivityLogsPost200ResponseDetailsInnerTargetsInnerEventsInner.from_dict(_item) for _item in obj["events"]] if obj.get("events") is not None else None,
            "failureReason": obj.get("failureReason"),
            "ids": [V1ActivityLogsPostRequestSelectorJobEntity.from_dict(_item) for _item in obj["ids"]] if obj.get("ids") is not None else None,
            "startTs": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["startTs"]) if obj.get("startTs") is not None else None,
            "status": obj.get("status")
        })
        return _obj


