# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_activity_logs_post_request_selector_job_entity import V1ActivityLogsPostRequestSelectorJobEntity
from typing import Optional, Set
from typing_extensions import Self

class V1ActivityLogsPostRequestSelector(BaseModel):
    """
    V1ActivityLogsPostRequestSelector
    """ # noqa: E501
    device_ids: Optional[List[StrictInt]] = Field(default=None, alias="deviceIds")
    id: Optional[StrictStr] = None
    in_progress: Optional[StrictBool] = Field(default=None, alias="inProgress")
    job_entity: Optional[V1ActivityLogsPostRequestSelectorJobEntity] = Field(default=None, alias="jobEntity")
    target_ids: Optional[List[V1ActivityLogsPostRequestSelectorJobEntity]] = Field(default=None, alias="targetIds")
    type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["deviceIds", "id", "inProgress", "jobEntity", "targetIds", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1ActivityLogsPostRequestSelector from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of job_entity
        if self.job_entity:
            _dict['jobEntity'] = self.job_entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in target_ids (list)
        _items = []
        if self.target_ids:
            for _item_target_ids in self.target_ids:
                if _item_target_ids:
                    _items.append(_item_target_ids.to_dict())
            _dict['targetIds'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1ActivityLogsPostRequestSelector from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "deviceIds": obj.get("deviceIds"),
            "id": obj.get("id"),
            "inProgress": obj.get("inProgress"),
            "jobEntity": V1ActivityLogsPostRequestSelectorJobEntity.from_dict(obj["jobEntity"]) if obj.get("jobEntity") is not None else None,
            "targetIds": [V1ActivityLogsPostRequestSelectorJobEntity.from_dict(_item) for _item in obj["targetIds"]] if obj.get("targetIds") is not None else None,
            "type": obj.get("type")
        })
        return _obj


