# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from typing import Optional, Set
from typing_extensions import Self

class V1AlarmsListGet200ResponseAlarmsInner(BaseModel):
    """
    V1AlarmsListGet200ResponseAlarmsInner
    """ # noqa: E501
    acknowledged_by: Optional[StrictStr] = Field(default=None, alias="acknowledgedBy")
    alarm_id: Optional[StrictInt] = Field(default=None, alias="alarmId")
    alarm_type_id: Optional[StrictStr] = Field(default=None, alias="alarmTypeId")
    alarm_type_qualifier: Optional[StrictStr] = Field(default=None, alias="alarmTypeQualifier")
    alt_component: Optional[StrictStr] = Field(default=None, alias="altComponent")
    boot_id: Optional[StrictStr] = Field(default=None, alias="bootId")
    component: Optional[StrictStr] = None
    created: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = None
    description: Optional[StrictStr] = None
    is_cleared: Optional[StrictBool] = Field(default=None, alias="isCleared")
    is_resolved: Optional[StrictBool] = Field(default=None, alias="isResolved")
    last_changed: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="lastChanged")
    last_raised: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="lastRaised")
    perceived_severity: Optional[StrictStr] = Field(default=None, alias="perceivedSeverity")
    resolved_by: Optional[StrictStr] = Field(default=None, alias="resolvedBy")
    sequence_number: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="sequenceNumber")
    where: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["acknowledgedBy", "alarmId", "alarmTypeId", "alarmTypeQualifier", "altComponent", "bootId", "component", "created", "description", "isCleared", "isResolved", "lastChanged", "lastRaised", "perceivedSeverity", "resolvedBy", "sequenceNumber", "where"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1AlarmsListGet200ResponseAlarmsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of created
        if self.created:
            _dict['created'] = self.created.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_changed
        if self.last_changed:
            _dict['lastChanged'] = self.last_changed.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_raised
        if self.last_raised:
            _dict['lastRaised'] = self.last_raised.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1AlarmsListGet200ResponseAlarmsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "acknowledgedBy": obj.get("acknowledgedBy"),
            "alarmId": obj.get("alarmId"),
            "alarmTypeId": obj.get("alarmTypeId"),
            "alarmTypeQualifier": obj.get("alarmTypeQualifier"),
            "altComponent": obj.get("altComponent"),
            "bootId": obj.get("bootId"),
            "component": obj.get("component"),
            "created": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["created"]) if obj.get("created") is not None else None,
            "description": obj.get("description"),
            "isCleared": obj.get("isCleared"),
            "isResolved": obj.get("isResolved"),
            "lastChanged": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["lastChanged"]) if obj.get("lastChanged") is not None else None,
            "lastRaised": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["lastRaised"]) if obj.get("lastRaised") is not None else None,
            "perceivedSeverity": obj.get("perceivedSeverity"),
            "resolvedBy": obj.get("resolvedBy"),
            "sequenceNumber": obj.get("sequenceNumber"),
            "where": obj.get("where")
        })
        return _obj


