# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from graphiant_sdk.models.v1_apps_app_summary_post200_response_app_summary_app_incidents import V1AppsAppSummaryPost200ResponseAppSummaryAppIncidents
from graphiant_sdk.models.v1_apps_app_summary_post200_response_app_summary_circuits_incidents_inner import V1AppsAppSummaryPost200ResponseAppSummaryCircuitsIncidentsInner
from graphiant_sdk.models.v1_apps_app_summary_post200_response_app_summary_circuits_incidentsv2_inner import V1AppsAppSummaryPost200ResponseAppSummaryCircuitsIncidentsv2Inner
from typing import Optional, Set
from typing_extensions import Self

class V1AppsAppSummaryPost200ResponseAppSummary(BaseModel):
    """
    V1AppsAppSummaryPost200ResponseAppSummary
    """ # noqa: E501
    app_health: Optional[Dict[str, Annotated[int, Field(strict=True, ge=0)]]] = Field(default=None, alias="appHealth")
    app_incidents: Optional[V1AppsAppSummaryPost200ResponseAppSummaryAppIncidents] = Field(default=None, alias="appIncidents")
    apps_on_device_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="appsOnDeviceCount")
    average_qoe: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="averageQoe")
    circuits_incidents: Optional[List[V1AppsAppSummaryPost200ResponseAppSummaryCircuitsIncidentsInner]] = Field(default=None, alias="circuitsIncidents")
    circuits_incidentsv2: Optional[List[V1AppsAppSummaryPost200ResponseAppSummaryCircuitsIncidentsv2Inner]] = Field(default=None, alias="circuitsIncidentsv2")
    __properties: ClassVar[List[str]] = ["appHealth", "appIncidents", "appsOnDeviceCount", "averageQoe", "circuitsIncidents", "circuitsIncidentsv2"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1AppsAppSummaryPost200ResponseAppSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of app_incidents
        if self.app_incidents:
            _dict['appIncidents'] = self.app_incidents.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in circuits_incidents (list)
        _items = []
        if self.circuits_incidents:
            for _item_circuits_incidents in self.circuits_incidents:
                if _item_circuits_incidents:
                    _items.append(_item_circuits_incidents.to_dict())
            _dict['circuitsIncidents'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in circuits_incidentsv2 (list)
        _items = []
        if self.circuits_incidentsv2:
            for _item_circuits_incidentsv2 in self.circuits_incidentsv2:
                if _item_circuits_incidentsv2:
                    _items.append(_item_circuits_incidentsv2.to_dict())
            _dict['circuitsIncidentsv2'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1AppsAppSummaryPost200ResponseAppSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "appHealth": obj.get("appHealth"),
            "appIncidents": V1AppsAppSummaryPost200ResponseAppSummaryAppIncidents.from_dict(obj["appIncidents"]) if obj.get("appIncidents") is not None else None,
            "appsOnDeviceCount": obj.get("appsOnDeviceCount"),
            "averageQoe": obj.get("averageQoe"),
            "circuitsIncidents": [V1AppsAppSummaryPost200ResponseAppSummaryCircuitsIncidentsInner.from_dict(_item) for _item in obj["circuitsIncidents"]] if obj.get("circuitsIncidents") is not None else None,
            "circuitsIncidentsv2": [V1AppsAppSummaryPost200ResponseAppSummaryCircuitsIncidentsv2Inner.from_dict(_item) for _item in obj["circuitsIncidentsv2"]] if obj.get("circuitsIncidentsv2") is not None else None
        })
        return _obj


