# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from graphiant_sdk.models.v1_apps_visualization_post200_response_apps_visualization_inner import V1AppsVisualizationPost200ResponseAppsVisualizationInner
from typing import Optional, Set
from typing_extensions import Self

class V1AppsVisualizationPost200Response(BaseModel):
    """
    V1AppsVisualizationPost200Response
    """ # noqa: E501
    app_health: Optional[Dict[str, Annotated[int, Field(strict=True, ge=0)]]] = Field(default=None, alias="appHealth")
    apps_on_device_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="appsOnDeviceCount")
    apps_visualization: Optional[List[V1AppsVisualizationPost200ResponseAppsVisualizationInner]] = Field(default=None, alias="appsVisualization")
    average_qoe: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="averageQoe")
    __properties: ClassVar[List[str]] = ["appHealth", "appsOnDeviceCount", "appsVisualization", "averageQoe"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1AppsVisualizationPost200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in apps_visualization (list)
        _items = []
        if self.apps_visualization:
            for _item_apps_visualization in self.apps_visualization:
                if _item_apps_visualization:
                    _items.append(_item_apps_visualization.to_dict())
            _dict['appsVisualization'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1AppsVisualizationPost200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "appHealth": obj.get("appHealth"),
            "appsOnDeviceCount": obj.get("appsOnDeviceCount"),
            "appsVisualization": [V1AppsVisualizationPost200ResponseAppsVisualizationInner.from_dict(_item) for _item in obj["appsVisualization"]] if obj.get("appsVisualization") is not None else None,
            "averageQoe": obj.get("averageQoe")
        })
        return _obj


