# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class V1DeviceSnapshotGet200ResponseFirstSnapshotData(BaseModel):
    """
    V1DeviceSnapshotGet200ResponseFirstSnapshotData
    """ # noqa: E501
    ospf_installed_route_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="OSPFInstalledRouteCount")
    t2_session_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="T2SessionCount")
    twamp_session_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="TWAMPSessionCount")
    bfd_session_count: Optional[StrictInt] = Field(default=None, alias="bfdSessionCount")
    bgp_neighbor_ip_list: Optional[List[StrictStr]] = Field(default=None, alias="bgpNeighborIpList")
    bgp_session_count: Optional[StrictInt] = Field(default=None, alias="bgpSessionCount")
    device_role: Optional[StrictStr] = Field(default=None, alias="deviceRole")
    failed_services_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="failedServicesCount")
    graphnos_version: Optional[StrictStr] = Field(default=None, alias="graphnosVersion")
    installed_labels: Optional[StrictInt] = Field(default=None, alias="installedLabels")
    ipsec_session_count: Optional[StrictInt] = Field(default=None, alias="ipsecSessionCount")
    ongoing_alerts: Optional[StrictInt] = Field(default=None, alias="ongoingAlerts")
    ospf_neighbor_ip_list: Optional[List[StrictStr]] = Field(default=None, alias="ospfNeighborIpList")
    ospf_session_count: Optional[StrictInt] = Field(default=None, alias="ospfSessionCount")
    __properties: ClassVar[List[str]] = ["OSPFInstalledRouteCount", "T2SessionCount", "TWAMPSessionCount", "bfdSessionCount", "bgpNeighborIpList", "bgpSessionCount", "deviceRole", "failedServicesCount", "graphnosVersion", "installedLabels", "ipsecSessionCount", "ongoingAlerts", "ospfNeighborIpList", "ospfSessionCount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DeviceSnapshotGet200ResponseFirstSnapshotData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DeviceSnapshotGet200ResponseFirstSnapshotData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "OSPFInstalledRouteCount": obj.get("OSPFInstalledRouteCount"),
            "T2SessionCount": obj.get("T2SessionCount"),
            "TWAMPSessionCount": obj.get("TWAMPSessionCount"),
            "bfdSessionCount": obj.get("bfdSessionCount"),
            "bgpNeighborIpList": obj.get("bgpNeighborIpList"),
            "bgpSessionCount": obj.get("bgpSessionCount"),
            "deviceRole": obj.get("deviceRole"),
            "failedServicesCount": obj.get("failedServicesCount"),
            "graphnosVersion": obj.get("graphnosVersion"),
            "installedLabels": obj.get("installedLabels"),
            "ipsecSessionCount": obj.get("ipsecSessionCount"),
            "ongoingAlerts": obj.get("ongoingAlerts"),
            "ospfNeighborIpList": obj.get("ospfNeighborIpList"),
            "ospfSessionCount": obj.get("ospfSessionCount")
        })
        return _obj


