# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core import V1DevicesDeviceIdConfigPutRequestCore
from graphiant_sdk.models.v1_devices_device_id_config_put_request_edge import V1DevicesDeviceIdConfigPutRequestEdge
from graphiant_sdk.models.v1_version_post_request_configuration_metadata import V1VersionPostRequestConfigurationMetadata
from typing import Optional, Set
from typing_extensions import Self

class V1DevicesDeviceIdConfigPutRequest(BaseModel):
    """
    V1DevicesDeviceIdConfigPutRequest
    """ # noqa: E501
    configuration_metadata: Optional[V1VersionPostRequestConfigurationMetadata] = Field(default=None, alias="configurationMetadata")
    core: Optional[V1DevicesDeviceIdConfigPutRequestCore] = None
    description: Optional[StrictStr] = None
    edge: Optional[V1DevicesDeviceIdConfigPutRequestEdge] = None
    local_web_server_password: Optional[StrictStr] = Field(default=None, alias="localWebServerPassword")
    replace: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["configurationMetadata", "core", "description", "edge", "localWebServerPassword", "replace"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of configuration_metadata
        if self.configuration_metadata:
            _dict['configurationMetadata'] = self.configuration_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of core
        if self.core:
            _dict['core'] = self.core.to_dict()
        # override the default output from pydantic by calling `to_dict()` of edge
        if self.edge:
            _dict['edge'] = self.edge.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "configurationMetadata": V1VersionPostRequestConfigurationMetadata.from_dict(obj["configurationMetadata"]) if obj.get("configurationMetadata") is not None else None,
            "core": V1DevicesDeviceIdConfigPutRequestCore.from_dict(obj["core"]) if obj.get("core") is not None else None,
            "description": obj.get("description"),
            "edge": V1DevicesDeviceIdConfigPutRequestEdge.from_dict(obj["edge"]) if obj.get("edge") is not None else None,
            "localWebServerPassword": obj.get("localWebServerPassword"),
            "replace": obj.get("replace")
        })
        return _obj


