# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_bgp_instance import V1DevicesDeviceIdConfigPutRequestCoreBgpInstance
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_core_vrf import V1DevicesDeviceIdConfigPutRequestCoreCoreVrf
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_interfaces_value import V1DevicesDeviceIdConfigPutRequestCoreInterfacesValue
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_prometheus import V1DevicesDeviceIdConfigPutRequestCorePrometheus
from graphiant_sdk.models.v1_global_config_patch_request_global_prefix_sets_value import V1GlobalConfigPatchRequestGlobalPrefixSetsValue
from graphiant_sdk.models.v1_global_config_patch_request_ipfix_exporters_value import V1GlobalConfigPatchRequestIpfixExportersValue
from graphiant_sdk.models.v1_global_config_patch_request_routing_policies_value import V1GlobalConfigPatchRequestRoutingPoliciesValue
from graphiant_sdk.models.v1_global_config_patch_request_traffic_policies import V1GlobalConfigPatchRequestTrafficPolicies
from graphiant_sdk.models.v1_sites_post_request_site import V1SitesPostRequestSite
from typing import Optional, Set
from typing_extensions import Self

class V1DevicesDeviceIdConfigPutRequestCore(BaseModel):
    """
    V1DevicesDeviceIdConfigPutRequestCore
    """ # noqa: E501
    bgp_instance: Optional[V1DevicesDeviceIdConfigPutRequestCoreBgpInstance] = Field(default=None, alias="bgpInstance")
    core_vrf: Optional[V1DevicesDeviceIdConfigPutRequestCoreCoreVrf] = Field(default=None, alias="coreVrf")
    interfaces: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestCoreInterfacesValue]] = None
    ipfix_exporters: Optional[Dict[str, V1GlobalConfigPatchRequestIpfixExportersValue]] = Field(default=None, alias="ipfixExporters")
    isp_vrfs: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestCoreCoreVrf]] = Field(default=None, alias="ispVrfs")
    maintenance_mode: Optional[StrictBool] = Field(default=None, alias="maintenanceMode")
    name: Optional[StrictStr] = None
    prefix_sets: Optional[Dict[str, V1GlobalConfigPatchRequestGlobalPrefixSetsValue]] = Field(default=None, alias="prefixSets")
    prometheus: Optional[V1DevicesDeviceIdConfigPutRequestCorePrometheus] = None
    region: Optional[StrictStr] = None
    region_name: Optional[StrictStr] = Field(default=None, alias="regionName")
    route_policies: Optional[Dict[str, V1GlobalConfigPatchRequestRoutingPoliciesValue]] = Field(default=None, alias="routePolicies")
    site: Optional[V1SitesPostRequestSite] = None
    traffic_policy: Optional[V1GlobalConfigPatchRequestTrafficPolicies] = Field(default=None, alias="trafficPolicy")
    vrfs: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestCoreCoreVrf]] = None
    __properties: ClassVar[List[str]] = ["bgpInstance", "coreVrf", "interfaces", "ipfixExporters", "ispVrfs", "maintenanceMode", "name", "prefixSets", "prometheus", "region", "regionName", "routePolicies", "site", "trafficPolicy", "vrfs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestCore from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of bgp_instance
        if self.bgp_instance:
            _dict['bgpInstance'] = self.bgp_instance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of core_vrf
        if self.core_vrf:
            _dict['coreVrf'] = self.core_vrf.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in interfaces (dict)
        _field_dict = {}
        if self.interfaces:
            for _key_interfaces in self.interfaces:
                if self.interfaces[_key_interfaces]:
                    _field_dict[_key_interfaces] = self.interfaces[_key_interfaces].to_dict()
            _dict['interfaces'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in ipfix_exporters (dict)
        _field_dict = {}
        if self.ipfix_exporters:
            for _key_ipfix_exporters in self.ipfix_exporters:
                if self.ipfix_exporters[_key_ipfix_exporters]:
                    _field_dict[_key_ipfix_exporters] = self.ipfix_exporters[_key_ipfix_exporters].to_dict()
            _dict['ipfixExporters'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in isp_vrfs (dict)
        _field_dict = {}
        if self.isp_vrfs:
            for _key_isp_vrfs in self.isp_vrfs:
                if self.isp_vrfs[_key_isp_vrfs]:
                    _field_dict[_key_isp_vrfs] = self.isp_vrfs[_key_isp_vrfs].to_dict()
            _dict['ispVrfs'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in prefix_sets (dict)
        _field_dict = {}
        if self.prefix_sets:
            for _key_prefix_sets in self.prefix_sets:
                if self.prefix_sets[_key_prefix_sets]:
                    _field_dict[_key_prefix_sets] = self.prefix_sets[_key_prefix_sets].to_dict()
            _dict['prefixSets'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of prometheus
        if self.prometheus:
            _dict['prometheus'] = self.prometheus.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in route_policies (dict)
        _field_dict = {}
        if self.route_policies:
            for _key_route_policies in self.route_policies:
                if self.route_policies[_key_route_policies]:
                    _field_dict[_key_route_policies] = self.route_policies[_key_route_policies].to_dict()
            _dict['routePolicies'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of site
        if self.site:
            _dict['site'] = self.site.to_dict()
        # override the default output from pydantic by calling `to_dict()` of traffic_policy
        if self.traffic_policy:
            _dict['trafficPolicy'] = self.traffic_policy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in vrfs (dict)
        _field_dict = {}
        if self.vrfs:
            for _key_vrfs in self.vrfs:
                if self.vrfs[_key_vrfs]:
                    _field_dict[_key_vrfs] = self.vrfs[_key_vrfs].to_dict()
            _dict['vrfs'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestCore from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bgpInstance": V1DevicesDeviceIdConfigPutRequestCoreBgpInstance.from_dict(obj["bgpInstance"]) if obj.get("bgpInstance") is not None else None,
            "coreVrf": V1DevicesDeviceIdConfigPutRequestCoreCoreVrf.from_dict(obj["coreVrf"]) if obj.get("coreVrf") is not None else None,
            "interfaces": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestCoreInterfacesValue.from_dict(_v))
                for _k, _v in obj["interfaces"].items()
            )
            if obj.get("interfaces") is not None
            else None,
            "ipfixExporters": dict(
                (_k, V1GlobalConfigPatchRequestIpfixExportersValue.from_dict(_v))
                for _k, _v in obj["ipfixExporters"].items()
            )
            if obj.get("ipfixExporters") is not None
            else None,
            "ispVrfs": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestCoreCoreVrf.from_dict(_v))
                for _k, _v in obj["ispVrfs"].items()
            )
            if obj.get("ispVrfs") is not None
            else None,
            "maintenanceMode": obj.get("maintenanceMode"),
            "name": obj.get("name"),
            "prefixSets": dict(
                (_k, V1GlobalConfigPatchRequestGlobalPrefixSetsValue.from_dict(_v))
                for _k, _v in obj["prefixSets"].items()
            )
            if obj.get("prefixSets") is not None
            else None,
            "prometheus": V1DevicesDeviceIdConfigPutRequestCorePrometheus.from_dict(obj["prometheus"]) if obj.get("prometheus") is not None else None,
            "region": obj.get("region"),
            "regionName": obj.get("regionName"),
            "routePolicies": dict(
                (_k, V1GlobalConfigPatchRequestRoutingPoliciesValue.from_dict(_v))
                for _k, _v in obj["routePolicies"].items()
            )
            if obj.get("routePolicies") is not None
            else None,
            "site": V1SitesPostRequestSite.from_dict(obj["site"]) if obj.get("site") is not None else None,
            "trafficPolicy": V1GlobalConfigPatchRequestTrafficPolicies.from_dict(obj["trafficPolicy"]) if obj.get("trafficPolicy") is not None else None,
            "vrfs": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestCoreCoreVrf.from_dict(_v))
                for _k, _v in obj["vrfs"].items()
            )
            if obj.get("vrfs") is not None
            else None
        })
        return _obj


