# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_core_vrf_ospfv2_process_admin_distance import V1DevicesDeviceIdConfigPutRequestCoreCoreVrfOspfv2ProcessAdminDistance
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_core_vrf_ospfv2_process_areas_value import V1DevicesDeviceIdConfigPutRequestCoreCoreVrfOspfv2ProcessAreasValue
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_core_vrf_ospfv2_process_redistribution_value import V1DevicesDeviceIdConfigPutRequestCoreCoreVrfOspfv2ProcessRedistributionValue
from typing import Optional, Set
from typing_extensions import Self

class V1DevicesDeviceIdConfigPutRequestCoreCoreVrfOspfv2Process(BaseModel):
    """
    V1DevicesDeviceIdConfigPutRequestCoreCoreVrfOspfv2Process
    """ # noqa: E501
    address_families: Optional[List[StrictStr]] = Field(default=None, alias="addressFamilies")
    admin_distance: Optional[V1DevicesDeviceIdConfigPutRequestCoreCoreVrfOspfv2ProcessAdminDistance] = Field(default=None, alias="adminDistance")
    areas: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestCoreCoreVrfOspfv2ProcessAreasValue]] = None
    auto: Optional[StrictBool] = None
    default_originate: Optional[StrictStr] = Field(default=None, alias="defaultOriginate")
    manual: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    redistribution: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestCoreCoreVrfOspfv2ProcessRedistributionValue]] = None
    __properties: ClassVar[List[str]] = ["addressFamilies", "adminDistance", "areas", "auto", "defaultOriginate", "manual", "name", "redistribution"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestCoreCoreVrfOspfv2Process from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of admin_distance
        if self.admin_distance:
            _dict['adminDistance'] = self.admin_distance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in areas (dict)
        _field_dict = {}
        if self.areas:
            for _key_areas in self.areas:
                if self.areas[_key_areas]:
                    _field_dict[_key_areas] = self.areas[_key_areas].to_dict()
            _dict['areas'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in redistribution (dict)
        _field_dict = {}
        if self.redistribution:
            for _key_redistribution in self.redistribution:
                if self.redistribution[_key_redistribution]:
                    _field_dict[_key_redistribution] = self.redistribution[_key_redistribution].to_dict()
            _dict['redistribution'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestCoreCoreVrfOspfv2Process from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "addressFamilies": obj.get("addressFamilies"),
            "adminDistance": V1DevicesDeviceIdConfigPutRequestCoreCoreVrfOspfv2ProcessAdminDistance.from_dict(obj["adminDistance"]) if obj.get("adminDistance") is not None else None,
            "areas": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestCoreCoreVrfOspfv2ProcessAreasValue.from_dict(_v))
                for _k, _v in obj["areas"].items()
            )
            if obj.get("areas") is not None
            else None,
            "auto": obj.get("auto"),
            "defaultOriginate": obj.get("defaultOriginate"),
            "manual": obj.get("manual"),
            "name": obj.get("name"),
            "redistribution": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestCoreCoreVrfOspfv2ProcessRedistributionValue.from_dict(_v))
                for _k, _v in obj["redistribution"].items()
            )
            if obj.get("redistribution") is not None
            else None
        })
        return _obj


