# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_core_vrf_static_routes_value_route_next_hop import V1DevicesDeviceIdConfigPutRequestCoreCoreVrfStaticRoutesValueRouteNextHop
from graphiant_sdk.models.v1_global_config_patch_request_routing_policies_value_policy_statements_value_statement_actions_value_action_administrative_distance import V1GlobalConfigPatchRequestRoutingPoliciesValuePolicyStatementsValueStatementActionsValueActionAdministrativeDistance
from typing import Optional, Set
from typing_extensions import Self

class V1DevicesDeviceIdConfigPutRequestCoreCoreVrfStaticRoutesValueRoute(BaseModel):
    """
    V1DevicesDeviceIdConfigPutRequestCoreCoreVrfStaticRoutesValueRoute
    """ # noqa: E501
    admin_distance: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="adminDistance")
    administrative_distance: Optional[V1GlobalConfigPatchRequestRoutingPoliciesValuePolicyStatementsValueStatementActionsValueActionAdministrativeDistance] = Field(default=None, alias="administrativeDistance")
    description: Optional[StrictStr] = None
    destination_prefix: Optional[StrictStr] = Field(default=None, alias="destinationPrefix")
    ip_version: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="ipVersion")
    next_hop: Optional[V1DevicesDeviceIdConfigPutRequestCoreCoreVrfStaticRoutesValueRouteNextHop] = Field(default=None, alias="nextHop")
    next_hops: Optional[List[V1DevicesDeviceIdConfigPutRequestCoreCoreVrfStaticRoutesValueRouteNextHop]] = Field(default=None, alias="nextHops")
    __properties: ClassVar[List[str]] = ["adminDistance", "administrativeDistance", "description", "destinationPrefix", "ipVersion", "nextHop", "nextHops"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestCoreCoreVrfStaticRoutesValueRoute from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of administrative_distance
        if self.administrative_distance:
            _dict['administrativeDistance'] = self.administrative_distance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of next_hop
        if self.next_hop:
            _dict['nextHop'] = self.next_hop.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in next_hops (list)
        _items = []
        if self.next_hops:
            for _item_next_hops in self.next_hops:
                if _item_next_hops:
                    _items.append(_item_next_hops.to_dict())
            _dict['nextHops'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestCoreCoreVrfStaticRoutesValueRoute from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "adminDistance": obj.get("adminDistance"),
            "administrativeDistance": V1GlobalConfigPatchRequestRoutingPoliciesValuePolicyStatementsValueStatementActionsValueActionAdministrativeDistance.from_dict(obj["administrativeDistance"]) if obj.get("administrativeDistance") is not None else None,
            "description": obj.get("description"),
            "destinationPrefix": obj.get("destinationPrefix"),
            "ipVersion": obj.get("ipVersion"),
            "nextHop": V1DevicesDeviceIdConfigPutRequestCoreCoreVrfStaticRoutesValueRouteNextHop.from_dict(obj["nextHop"]) if obj.get("nextHop") is not None else None,
            "nextHops": [V1DevicesDeviceIdConfigPutRequestCoreCoreVrfStaticRoutesValueRouteNextHop.from_dict(_item) for _item in obj["nextHops"]] if obj.get("nextHops") is not None else None
        })
        return _obj


