# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_account_mfa_get200_response import V1AccountMfaGet200Response
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_interfaces_value_interface_core_neighbor import V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceCoreNeighbor
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_interfaces_value_interface_core_neighbor_cost import V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceCoreNeighborCost
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_interfaces_value_interface_core_neighbor_cost_dynamic import V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceCoreNeighborCostDynamic
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_interfaces_value_interface_flex_algos import V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceFlexAlgos
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_interfaces_value_interface_gw import V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceGw
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_interfaces_value_interface_gw_gw import V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceGwGw
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_interfaces_value_interface_interface_type import V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceInterfaceType
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_interfaces_value_interface_ipsec import V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceIpsec
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_interfaces_value_interface_ospf_interface import V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceOspfInterface
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_interfaces_value_interface_subinterfaces_value import V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceSubinterfacesValue
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_interfaces_value_interface_wan import V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceWan
from typing import Optional, Set
from typing_extensions import Self

class V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterface(BaseModel):
    """
    V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterface
    """ # noqa: E501
    admin_status: Optional[StrictBool] = Field(default=None, alias="adminStatus")
    alias: Optional[StrictStr] = None
    circuit: Optional[StrictStr] = None
    core_neighbor: Optional[V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceCoreNeighbor] = Field(default=None, alias="coreNeighbor")
    core_to_core_tunnel: Optional[Dict[str, Any]] = Field(default=None, alias="coreToCoreTunnel")
    create_link_local_address: Optional[StrictBool] = Field(default=None, alias="createLinkLocalAddress")
    default: Optional[Dict[str, Any]] = None
    description: Optional[StrictStr] = None
    duplex: Optional[StrictStr] = None
    dynamic: Optional[V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceCoreNeighborCostDynamic] = None
    flex_algos: Optional[V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceFlexAlgos] = Field(default=None, alias="flexAlgos")
    gateway_neighbor: Optional[V1AccountMfaGet200Response] = Field(default=None, alias="gatewayNeighbor")
    gw: Optional[V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceGw] = None
    interface_type: Optional[V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceInterfaceType] = Field(default=None, alias="interfaceType")
    ipsec: Optional[V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceIpsec] = None
    ipv4: Optional[V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceGwGw] = None
    ipv6: Optional[V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceGwGw] = None
    lan: Optional[StrictStr] = None
    lldp_enabled: Optional[StrictBool] = Field(default=None, alias="lldpEnabled")
    loopback: Optional[StrictBool] = None
    max_transmission_unit: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="maxTransmissionUnit")
    mpls_enabled: Optional[StrictBool] = Field(default=None, alias="mplsEnabled")
    ospf_cost: Optional[V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceCoreNeighborCost] = Field(default=None, alias="ospfCost")
    ospf_interface: Optional[V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceOspfInterface] = Field(default=None, alias="ospfInterface")
    peer_device_id: Optional[StrictInt] = Field(default=None, alias="peerDeviceId")
    peer_hostname: Optional[StrictStr] = Field(default=None, alias="peerHostname")
    security_zone: Optional[StrictStr] = Field(default=None, alias="securityZone")
    speed: Optional[StrictInt] = None
    static: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    subinterfaces: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceSubinterfacesValue]] = None
    tcp_mss: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="tcpMss")
    tcp_mss_v4: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="tcpMssV4")
    tcp_mss_v6: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="tcpMssV6")
    tunnel_interface: Optional[StrictStr] = Field(default=None, alias="tunnelInterface")
    tunnel_underlay: Optional[StrictStr] = Field(default=None, alias="tunnelUnderlay")
    wan: Optional[V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceWan] = None
    wan_management: Optional[Dict[str, Any]] = Field(default=None, alias="wanManagement")
    x_talk_filter: Optional[StrictBool] = Field(default=None, alias="xTalkFilter")
    __properties: ClassVar[List[str]] = ["adminStatus", "alias", "circuit", "coreNeighbor", "coreToCoreTunnel", "createLinkLocalAddress", "default", "description", "duplex", "dynamic", "flexAlgos", "gatewayNeighbor", "gw", "interfaceType", "ipsec", "ipv4", "ipv6", "lan", "lldpEnabled", "loopback", "maxTransmissionUnit", "mplsEnabled", "ospfCost", "ospfInterface", "peerDeviceId", "peerHostname", "securityZone", "speed", "static", "subinterfaces", "tcpMss", "tcpMssV4", "tcpMssV6", "tunnelInterface", "tunnelUnderlay", "wan", "wanManagement", "xTalkFilter"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterface from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of core_neighbor
        if self.core_neighbor:
            _dict['coreNeighbor'] = self.core_neighbor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dynamic
        if self.dynamic:
            _dict['dynamic'] = self.dynamic.to_dict()
        # override the default output from pydantic by calling `to_dict()` of flex_algos
        if self.flex_algos:
            _dict['flexAlgos'] = self.flex_algos.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gateway_neighbor
        if self.gateway_neighbor:
            _dict['gatewayNeighbor'] = self.gateway_neighbor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gw
        if self.gw:
            _dict['gw'] = self.gw.to_dict()
        # override the default output from pydantic by calling `to_dict()` of interface_type
        if self.interface_type:
            _dict['interfaceType'] = self.interface_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ipsec
        if self.ipsec:
            _dict['ipsec'] = self.ipsec.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ipv4
        if self.ipv4:
            _dict['ipv4'] = self.ipv4.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ipv6
        if self.ipv6:
            _dict['ipv6'] = self.ipv6.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ospf_cost
        if self.ospf_cost:
            _dict['ospfCost'] = self.ospf_cost.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ospf_interface
        if self.ospf_interface:
            _dict['ospfInterface'] = self.ospf_interface.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in subinterfaces (dict)
        _field_dict = {}
        if self.subinterfaces:
            for _key_subinterfaces in self.subinterfaces:
                if self.subinterfaces[_key_subinterfaces]:
                    _field_dict[_key_subinterfaces] = self.subinterfaces[_key_subinterfaces].to_dict()
            _dict['subinterfaces'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of wan
        if self.wan:
            _dict['wan'] = self.wan.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterface from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "adminStatus": obj.get("adminStatus"),
            "alias": obj.get("alias"),
            "circuit": obj.get("circuit"),
            "coreNeighbor": V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceCoreNeighbor.from_dict(obj["coreNeighbor"]) if obj.get("coreNeighbor") is not None else None,
            "coreToCoreTunnel": obj.get("coreToCoreTunnel"),
            "createLinkLocalAddress": obj.get("createLinkLocalAddress"),
            "default": obj.get("default"),
            "description": obj.get("description"),
            "duplex": obj.get("duplex"),
            "dynamic": V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceCoreNeighborCostDynamic.from_dict(obj["dynamic"]) if obj.get("dynamic") is not None else None,
            "flexAlgos": V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceFlexAlgos.from_dict(obj["flexAlgos"]) if obj.get("flexAlgos") is not None else None,
            "gatewayNeighbor": V1AccountMfaGet200Response.from_dict(obj["gatewayNeighbor"]) if obj.get("gatewayNeighbor") is not None else None,
            "gw": V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceGw.from_dict(obj["gw"]) if obj.get("gw") is not None else None,
            "interfaceType": V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceInterfaceType.from_dict(obj["interfaceType"]) if obj.get("interfaceType") is not None else None,
            "ipsec": V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceIpsec.from_dict(obj["ipsec"]) if obj.get("ipsec") is not None else None,
            "ipv4": V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceGwGw.from_dict(obj["ipv4"]) if obj.get("ipv4") is not None else None,
            "ipv6": V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceGwGw.from_dict(obj["ipv6"]) if obj.get("ipv6") is not None else None,
            "lan": obj.get("lan"),
            "lldpEnabled": obj.get("lldpEnabled"),
            "loopback": obj.get("loopback"),
            "maxTransmissionUnit": obj.get("maxTransmissionUnit"),
            "mplsEnabled": obj.get("mplsEnabled"),
            "ospfCost": V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceCoreNeighborCost.from_dict(obj["ospfCost"]) if obj.get("ospfCost") is not None else None,
            "ospfInterface": V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceOspfInterface.from_dict(obj["ospfInterface"]) if obj.get("ospfInterface") is not None else None,
            "peerDeviceId": obj.get("peerDeviceId"),
            "peerHostname": obj.get("peerHostname"),
            "securityZone": obj.get("securityZone"),
            "speed": obj.get("speed"),
            "static": obj.get("static"),
            "subinterfaces": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceSubinterfacesValue.from_dict(_v))
                for _k, _v in obj["subinterfaces"].items()
            )
            if obj.get("subinterfaces") is not None
            else None,
            "tcpMss": obj.get("tcpMss"),
            "tcpMssV4": obj.get("tcpMssV4"),
            "tcpMssV6": obj.get("tcpMssV6"),
            "tunnelInterface": obj.get("tunnelInterface"),
            "tunnelUnderlay": obj.get("tunnelUnderlay"),
            "wan": V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceWan.from_dict(obj["wan"]) if obj.get("wan") is not None else None,
            "wanManagement": obj.get("wanManagement"),
            "xTalkFilter": obj.get("xTalkFilter")
        })
        return _obj


