# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_bgp_instance import V1DevicesDeviceIdConfigPutRequestCoreBgpInstance
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_core_vrf import V1DevicesDeviceIdConfigPutRequestCoreCoreVrf
from graphiant_sdk.models.v1_devices_device_id_config_put_request_edge_circuits_value import V1DevicesDeviceIdConfigPutRequestEdgeCircuitsValue
from graphiant_sdk.models.v1_devices_device_id_config_put_request_edge_dns import V1DevicesDeviceIdConfigPutRequestEdgeDns
from graphiant_sdk.models.v1_devices_device_id_config_put_request_edge_interfaces_value import V1DevicesDeviceIdConfigPutRequestEdgeInterfacesValue
from graphiant_sdk.models.v1_devices_device_id_config_put_request_edge_lag_interfaces_value import V1DevicesDeviceIdConfigPutRequestEdgeLagInterfacesValue
from graphiant_sdk.models.v1_devices_device_id_config_put_request_edge_nat_policy import V1DevicesDeviceIdConfigPutRequestEdgeNatPolicy
from graphiant_sdk.models.v1_devices_device_id_config_put_request_edge_site_to_site_vpn_value import V1DevicesDeviceIdConfigPutRequestEdgeSiteToSiteVpnValue
from graphiant_sdk.models.v1_extranets_get200_response_policies_inner_branches_excluded_devices_inner_location import V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerLocation
from graphiant_sdk.models.v1_global_config_patch_request_global_prefix_sets_value import V1GlobalConfigPatchRequestGlobalPrefixSetsValue
from graphiant_sdk.models.v1_global_config_patch_request_ipfix_exporters_value import V1GlobalConfigPatchRequestIpfixExportersValue
from graphiant_sdk.models.v1_global_config_patch_request_routing_policies_value import V1GlobalConfigPatchRequestRoutingPoliciesValue
from graphiant_sdk.models.v1_global_config_patch_request_routing_policies_value_policy_statements_value_statement_matches_value_match_route_tag import V1GlobalConfigPatchRequestRoutingPoliciesValuePolicyStatementsValueStatementMatchesValueMatchRouteTag
from graphiant_sdk.models.v1_global_config_patch_request_snmps_value import V1GlobalConfigPatchRequestSnmpsValue
from graphiant_sdk.models.v1_global_config_patch_request_traffic_policies import V1GlobalConfigPatchRequestTrafficPolicies
from graphiant_sdk.models.v1_sites_post_request_site import V1SitesPostRequestSite
from typing import Optional, Set
from typing_extensions import Self

class V1DevicesDeviceIdConfigPutRequestEdge(BaseModel):
    """
    V1DevicesDeviceIdConfigPutRequestEdge
    """ # noqa: E501
    bgp_enabled: Optional[StrictBool] = Field(default=None, alias="bgpEnabled")
    bgp_instance: Optional[V1DevicesDeviceIdConfigPutRequestCoreBgpInstance] = Field(default=None, alias="bgpInstance")
    circuits: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestEdgeCircuitsValue]] = None
    dhcp_server_enabled: Optional[StrictBool] = Field(default=None, alias="dhcpServerEnabled")
    dns: Optional[V1DevicesDeviceIdConfigPutRequestEdgeDns] = None
    interfaces: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestEdgeInterfacesValue]] = None
    ipfix_enabled: Optional[StrictBool] = Field(default=None, alias="ipfixEnabled")
    ipfix_exporters: Optional[Dict[str, V1GlobalConfigPatchRequestIpfixExportersValue]] = Field(default=None, alias="ipfixExporters")
    lag_interfaces: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestEdgeLagInterfacesValue]] = Field(default=None, alias="lagInterfaces")
    lldp_enabled: Optional[StrictBool] = Field(default=None, alias="lldpEnabled")
    local_route_tag: Optional[V1GlobalConfigPatchRequestRoutingPoliciesValuePolicyStatementsValueStatementMatchesValueMatchRouteTag] = Field(default=None, alias="localRouteTag")
    local_web_server_password: Optional[StrictStr] = Field(default=None, alias="localWebServerPassword")
    location: Optional[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerLocation] = None
    maintenance_mode: Optional[StrictBool] = Field(default=None, alias="maintenanceMode")
    name: Optional[StrictStr] = None
    nat_policy: Optional[V1DevicesDeviceIdConfigPutRequestEdgeNatPolicy] = Field(default=None, alias="natPolicy")
    ospfv2_enabled: Optional[StrictBool] = Field(default=None, alias="ospfv2Enabled")
    ospfv3_enabled: Optional[StrictBool] = Field(default=None, alias="ospfv3Enabled")
    prefix_sets: Optional[Dict[str, V1GlobalConfigPatchRequestGlobalPrefixSetsValue]] = Field(default=None, alias="prefixSets")
    region: Optional[StrictStr] = None
    region_name: Optional[StrictStr] = Field(default=None, alias="regionName")
    route_policies: Optional[Dict[str, V1GlobalConfigPatchRequestRoutingPoliciesValue]] = Field(default=None, alias="routePolicies")
    segments: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestCoreCoreVrf]] = None
    site: Optional[V1SitesPostRequestSite] = None
    site_to_site_vpn: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestEdgeSiteToSiteVpnValue]] = Field(default=None, alias="siteToSiteVpn")
    snmp: Optional[V1GlobalConfigPatchRequestSnmpsValue] = None
    snmp_global_object: Optional[Dict[str, V1GlobalConfigPatchRequestSnmpsValue]] = Field(default=None, alias="snmpGlobalObject")
    static_routes_enabled: Optional[StrictBool] = Field(default=None, alias="staticRoutesEnabled")
    traffic_policy: Optional[V1GlobalConfigPatchRequestTrafficPolicies] = Field(default=None, alias="trafficPolicy")
    vrrp_enabled: Optional[StrictBool] = Field(default=None, alias="vrrpEnabled")
    __properties: ClassVar[List[str]] = ["bgpEnabled", "bgpInstance", "circuits", "dhcpServerEnabled", "dns", "interfaces", "ipfixEnabled", "ipfixExporters", "lagInterfaces", "lldpEnabled", "localRouteTag", "localWebServerPassword", "location", "maintenanceMode", "name", "natPolicy", "ospfv2Enabled", "ospfv3Enabled", "prefixSets", "region", "regionName", "routePolicies", "segments", "site", "siteToSiteVpn", "snmp", "snmpGlobalObject", "staticRoutesEnabled", "trafficPolicy", "vrrpEnabled"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestEdge from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of bgp_instance
        if self.bgp_instance:
            _dict['bgpInstance'] = self.bgp_instance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in circuits (dict)
        _field_dict = {}
        if self.circuits:
            for _key_circuits in self.circuits:
                if self.circuits[_key_circuits]:
                    _field_dict[_key_circuits] = self.circuits[_key_circuits].to_dict()
            _dict['circuits'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of dns
        if self.dns:
            _dict['dns'] = self.dns.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in interfaces (dict)
        _field_dict = {}
        if self.interfaces:
            for _key_interfaces in self.interfaces:
                if self.interfaces[_key_interfaces]:
                    _field_dict[_key_interfaces] = self.interfaces[_key_interfaces].to_dict()
            _dict['interfaces'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in ipfix_exporters (dict)
        _field_dict = {}
        if self.ipfix_exporters:
            for _key_ipfix_exporters in self.ipfix_exporters:
                if self.ipfix_exporters[_key_ipfix_exporters]:
                    _field_dict[_key_ipfix_exporters] = self.ipfix_exporters[_key_ipfix_exporters].to_dict()
            _dict['ipfixExporters'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in lag_interfaces (dict)
        _field_dict = {}
        if self.lag_interfaces:
            for _key_lag_interfaces in self.lag_interfaces:
                if self.lag_interfaces[_key_lag_interfaces]:
                    _field_dict[_key_lag_interfaces] = self.lag_interfaces[_key_lag_interfaces].to_dict()
            _dict['lagInterfaces'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of local_route_tag
        if self.local_route_tag:
            _dict['localRouteTag'] = self.local_route_tag.to_dict()
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of nat_policy
        if self.nat_policy:
            _dict['natPolicy'] = self.nat_policy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in prefix_sets (dict)
        _field_dict = {}
        if self.prefix_sets:
            for _key_prefix_sets in self.prefix_sets:
                if self.prefix_sets[_key_prefix_sets]:
                    _field_dict[_key_prefix_sets] = self.prefix_sets[_key_prefix_sets].to_dict()
            _dict['prefixSets'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in route_policies (dict)
        _field_dict = {}
        if self.route_policies:
            for _key_route_policies in self.route_policies:
                if self.route_policies[_key_route_policies]:
                    _field_dict[_key_route_policies] = self.route_policies[_key_route_policies].to_dict()
            _dict['routePolicies'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in segments (dict)
        _field_dict = {}
        if self.segments:
            for _key_segments in self.segments:
                if self.segments[_key_segments]:
                    _field_dict[_key_segments] = self.segments[_key_segments].to_dict()
            _dict['segments'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of site
        if self.site:
            _dict['site'] = self.site.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in site_to_site_vpn (dict)
        _field_dict = {}
        if self.site_to_site_vpn:
            for _key_site_to_site_vpn in self.site_to_site_vpn:
                if self.site_to_site_vpn[_key_site_to_site_vpn]:
                    _field_dict[_key_site_to_site_vpn] = self.site_to_site_vpn[_key_site_to_site_vpn].to_dict()
            _dict['siteToSiteVpn'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of snmp
        if self.snmp:
            _dict['snmp'] = self.snmp.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in snmp_global_object (dict)
        _field_dict = {}
        if self.snmp_global_object:
            for _key_snmp_global_object in self.snmp_global_object:
                if self.snmp_global_object[_key_snmp_global_object]:
                    _field_dict[_key_snmp_global_object] = self.snmp_global_object[_key_snmp_global_object].to_dict()
            _dict['snmpGlobalObject'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of traffic_policy
        if self.traffic_policy:
            _dict['trafficPolicy'] = self.traffic_policy.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestEdge from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bgpEnabled": obj.get("bgpEnabled"),
            "bgpInstance": V1DevicesDeviceIdConfigPutRequestCoreBgpInstance.from_dict(obj["bgpInstance"]) if obj.get("bgpInstance") is not None else None,
            "circuits": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestEdgeCircuitsValue.from_dict(_v))
                for _k, _v in obj["circuits"].items()
            )
            if obj.get("circuits") is not None
            else None,
            "dhcpServerEnabled": obj.get("dhcpServerEnabled"),
            "dns": V1DevicesDeviceIdConfigPutRequestEdgeDns.from_dict(obj["dns"]) if obj.get("dns") is not None else None,
            "interfaces": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestEdgeInterfacesValue.from_dict(_v))
                for _k, _v in obj["interfaces"].items()
            )
            if obj.get("interfaces") is not None
            else None,
            "ipfixEnabled": obj.get("ipfixEnabled"),
            "ipfixExporters": dict(
                (_k, V1GlobalConfigPatchRequestIpfixExportersValue.from_dict(_v))
                for _k, _v in obj["ipfixExporters"].items()
            )
            if obj.get("ipfixExporters") is not None
            else None,
            "lagInterfaces": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestEdgeLagInterfacesValue.from_dict(_v))
                for _k, _v in obj["lagInterfaces"].items()
            )
            if obj.get("lagInterfaces") is not None
            else None,
            "lldpEnabled": obj.get("lldpEnabled"),
            "localRouteTag": V1GlobalConfigPatchRequestRoutingPoliciesValuePolicyStatementsValueStatementMatchesValueMatchRouteTag.from_dict(obj["localRouteTag"]) if obj.get("localRouteTag") is not None else None,
            "localWebServerPassword": obj.get("localWebServerPassword"),
            "location": V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerLocation.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "maintenanceMode": obj.get("maintenanceMode"),
            "name": obj.get("name"),
            "natPolicy": V1DevicesDeviceIdConfigPutRequestEdgeNatPolicy.from_dict(obj["natPolicy"]) if obj.get("natPolicy") is not None else None,
            "ospfv2Enabled": obj.get("ospfv2Enabled"),
            "ospfv3Enabled": obj.get("ospfv3Enabled"),
            "prefixSets": dict(
                (_k, V1GlobalConfigPatchRequestGlobalPrefixSetsValue.from_dict(_v))
                for _k, _v in obj["prefixSets"].items()
            )
            if obj.get("prefixSets") is not None
            else None,
            "region": obj.get("region"),
            "regionName": obj.get("regionName"),
            "routePolicies": dict(
                (_k, V1GlobalConfigPatchRequestRoutingPoliciesValue.from_dict(_v))
                for _k, _v in obj["routePolicies"].items()
            )
            if obj.get("routePolicies") is not None
            else None,
            "segments": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestCoreCoreVrf.from_dict(_v))
                for _k, _v in obj["segments"].items()
            )
            if obj.get("segments") is not None
            else None,
            "site": V1SitesPostRequestSite.from_dict(obj["site"]) if obj.get("site") is not None else None,
            "siteToSiteVpn": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestEdgeSiteToSiteVpnValue.from_dict(_v))
                for _k, _v in obj["siteToSiteVpn"].items()
            )
            if obj.get("siteToSiteVpn") is not None
            else None,
            "snmp": V1GlobalConfigPatchRequestSnmpsValue.from_dict(obj["snmp"]) if obj.get("snmp") is not None else None,
            "snmpGlobalObject": dict(
                (_k, V1GlobalConfigPatchRequestSnmpsValue.from_dict(_v))
                for _k, _v in obj["snmpGlobalObject"].items()
            )
            if obj.get("snmpGlobalObject") is not None
            else None,
            "staticRoutesEnabled": obj.get("staticRoutesEnabled"),
            "trafficPolicy": V1GlobalConfigPatchRequestTrafficPolicies.from_dict(obj["trafficPolicy"]) if obj.get("trafficPolicy") is not None else None,
            "vrrpEnabled": obj.get("vrrpEnabled")
        })
        return _obj


