# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_core_vrf_bgp_aggregations_value import V1DevicesDeviceIdConfigPutRequestCoreCoreVrfBgpAggregationsValue
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_core_vrf_bgp_neighbors_value import V1DevicesDeviceIdConfigPutRequestCoreCoreVrfBgpNeighborsValue
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_core_vrf_bgp_redistribution_value import V1DevicesDeviceIdConfigPutRequestCoreCoreVrfBgpRedistributionValue
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_core_vrf_ebgp_multipath import V1DevicesDeviceIdConfigPutRequestCoreCoreVrfEbgpMultipath
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_core_vrf_static_routes_value import V1DevicesDeviceIdConfigPutRequestCoreCoreVrfStaticRoutesValue
from graphiant_sdk.models.v1_devices_device_id_config_put_request_edge_circuits_value_pat_addresses import V1DevicesDeviceIdConfigPutRequestEdgeCircuitsValuePatAddresses
from typing import Optional, Set
from typing_extensions import Self

class V1DevicesDeviceIdConfigPutRequestEdgeCircuitsValue(BaseModel):
    """
    V1DevicesDeviceIdConfigPutRequestEdgeCircuitsValue
    """ # noqa: E501
    bgp_aggregations: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestCoreCoreVrfBgpAggregationsValue]] = Field(default=None, alias="bgpAggregations")
    bgp_multipath: Optional[V1DevicesDeviceIdConfigPutRequestCoreCoreVrfEbgpMultipath] = Field(default=None, alias="bgpMultipath")
    bgp_neighbors: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestCoreCoreVrfBgpNeighborsValue]] = Field(default=None, alias="bgpNeighbors")
    bgp_redistribution: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestCoreCoreVrfBgpRedistributionValue]] = Field(default=None, alias="bgpRedistribution")
    carrier: Optional[StrictStr] = None
    circuit_type: Optional[StrictStr] = Field(default=None, alias="circuitType")
    connection_type: Optional[StrictStr] = Field(default=None, alias="connectionType")
    description: Optional[StrictStr] = None
    dia_enabled: Optional[StrictBool] = Field(default=None, alias="diaEnabled")
    drop_mechanism: Optional[StrictStr] = Field(default=None, alias="dropMechanism")
    label: Optional[StrictStr] = None
    last_resort: Optional[StrictBool] = Field(default=None, alias="lastResort")
    link_down_speed_mbps: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="linkDownSpeedMbps")
    link_up_speed_mbps: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="linkUpSpeedMbps")
    loopback: Optional[StrictBool] = None
    name: Optional[StrictStr] = None
    pat_addresses: Optional[V1DevicesDeviceIdConfigPutRequestEdgeCircuitsValuePatAddresses] = Field(default=None, alias="patAddresses")
    qos_profile: Optional[StrictStr] = Field(default=None, alias="qosProfile")
    qos_profile_type: Optional[StrictStr] = Field(default=None, alias="qosProfileType")
    static_routes: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestCoreCoreVrfStaticRoutesValue]] = Field(default=None, alias="staticRoutes")
    __properties: ClassVar[List[str]] = ["bgpAggregations", "bgpMultipath", "bgpNeighbors", "bgpRedistribution", "carrier", "circuitType", "connectionType", "description", "diaEnabled", "dropMechanism", "label", "lastResort", "linkDownSpeedMbps", "linkUpSpeedMbps", "loopback", "name", "patAddresses", "qosProfile", "qosProfileType", "staticRoutes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestEdgeCircuitsValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in bgp_aggregations (dict)
        _field_dict = {}
        if self.bgp_aggregations:
            for _key_bgp_aggregations in self.bgp_aggregations:
                if self.bgp_aggregations[_key_bgp_aggregations]:
                    _field_dict[_key_bgp_aggregations] = self.bgp_aggregations[_key_bgp_aggregations].to_dict()
            _dict['bgpAggregations'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of bgp_multipath
        if self.bgp_multipath:
            _dict['bgpMultipath'] = self.bgp_multipath.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in bgp_neighbors (dict)
        _field_dict = {}
        if self.bgp_neighbors:
            for _key_bgp_neighbors in self.bgp_neighbors:
                if self.bgp_neighbors[_key_bgp_neighbors]:
                    _field_dict[_key_bgp_neighbors] = self.bgp_neighbors[_key_bgp_neighbors].to_dict()
            _dict['bgpNeighbors'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in bgp_redistribution (dict)
        _field_dict = {}
        if self.bgp_redistribution:
            for _key_bgp_redistribution in self.bgp_redistribution:
                if self.bgp_redistribution[_key_bgp_redistribution]:
                    _field_dict[_key_bgp_redistribution] = self.bgp_redistribution[_key_bgp_redistribution].to_dict()
            _dict['bgpRedistribution'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of pat_addresses
        if self.pat_addresses:
            _dict['patAddresses'] = self.pat_addresses.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in static_routes (dict)
        _field_dict = {}
        if self.static_routes:
            for _key_static_routes in self.static_routes:
                if self.static_routes[_key_static_routes]:
                    _field_dict[_key_static_routes] = self.static_routes[_key_static_routes].to_dict()
            _dict['staticRoutes'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestEdgeCircuitsValue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bgpAggregations": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestCoreCoreVrfBgpAggregationsValue.from_dict(_v))
                for _k, _v in obj["bgpAggregations"].items()
            )
            if obj.get("bgpAggregations") is not None
            else None,
            "bgpMultipath": V1DevicesDeviceIdConfigPutRequestCoreCoreVrfEbgpMultipath.from_dict(obj["bgpMultipath"]) if obj.get("bgpMultipath") is not None else None,
            "bgpNeighbors": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestCoreCoreVrfBgpNeighborsValue.from_dict(_v))
                for _k, _v in obj["bgpNeighbors"].items()
            )
            if obj.get("bgpNeighbors") is not None
            else None,
            "bgpRedistribution": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestCoreCoreVrfBgpRedistributionValue.from_dict(_v))
                for _k, _v in obj["bgpRedistribution"].items()
            )
            if obj.get("bgpRedistribution") is not None
            else None,
            "carrier": obj.get("carrier"),
            "circuitType": obj.get("circuitType"),
            "connectionType": obj.get("connectionType"),
            "description": obj.get("description"),
            "diaEnabled": obj.get("diaEnabled"),
            "dropMechanism": obj.get("dropMechanism"),
            "label": obj.get("label"),
            "lastResort": obj.get("lastResort"),
            "linkDownSpeedMbps": obj.get("linkDownSpeedMbps"),
            "linkUpSpeedMbps": obj.get("linkUpSpeedMbps"),
            "loopback": obj.get("loopback"),
            "name": obj.get("name"),
            "patAddresses": V1DevicesDeviceIdConfigPutRequestEdgeCircuitsValuePatAddresses.from_dict(obj["patAddresses"]) if obj.get("patAddresses") is not None else None,
            "qosProfile": obj.get("qosProfile"),
            "qosProfileType": obj.get("qosProfileType"),
            "staticRoutes": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestCoreCoreVrfStaticRoutesValue.from_dict(_v))
                for _k, _v in obj["staticRoutes"].items()
            )
            if obj.get("staticRoutes") is not None
            else None
        })
        return _obj


