# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_devices_device_id_config_put_request_core_interfaces_value_interface_gw_gw import V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceGwGw
from graphiant_sdk.models.v1_devices_device_id_config_put_request_edge_lag_interfaces_value_interface_lag_members_value import V1DevicesDeviceIdConfigPutRequestEdgeLagInterfacesValueInterfaceLagMembersValue
from graphiant_sdk.models.v1_devices_device_id_config_put_request_edge_lag_interfaces_value_interface_subinterfaces_value import V1DevicesDeviceIdConfigPutRequestEdgeLagInterfacesValueInterfaceSubinterfacesValue
from graphiant_sdk.models.v1_extranets_get200_response_policies_inner_branches_excluded_devices_inner_interfaces_inner_lag_interface_lacp_config import V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerLagInterfaceLacpConfig
from typing import Optional, Set
from typing_extensions import Self

class V1DevicesDeviceIdConfigPutRequestEdgeLagInterfacesValueInterface(BaseModel):
    """
    V1DevicesDeviceIdConfigPutRequestEdgeLagInterfacesValueInterface
    """ # noqa: E501
    admin_status: Optional[StrictBool] = Field(default=None, alias="adminStatus")
    alias: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    ipv4: Optional[V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceGwGw] = None
    ipv6: Optional[V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceGwGw] = None
    lacp: Optional[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerLagInterfaceLacpConfig] = None
    lag_members: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestEdgeLagInterfacesValueInterfaceLagMembersValue]] = Field(default=None, alias="lagMembers")
    minimum_members: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="minimumMembers")
    mtu: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    segment: Optional[StrictStr] = None
    subinterfaces: Optional[Dict[str, V1DevicesDeviceIdConfigPutRequestEdgeLagInterfacesValueInterfaceSubinterfacesValue]] = None
    __properties: ClassVar[List[str]] = ["adminStatus", "alias", "description", "ipv4", "ipv6", "lacp", "lagMembers", "minimumMembers", "mtu", "segment", "subinterfaces"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestEdgeLagInterfacesValueInterface from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ipv4
        if self.ipv4:
            _dict['ipv4'] = self.ipv4.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ipv6
        if self.ipv6:
            _dict['ipv6'] = self.ipv6.to_dict()
        # override the default output from pydantic by calling `to_dict()` of lacp
        if self.lacp:
            _dict['lacp'] = self.lacp.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in lag_members (dict)
        _field_dict = {}
        if self.lag_members:
            for _key_lag_members in self.lag_members:
                if self.lag_members[_key_lag_members]:
                    _field_dict[_key_lag_members] = self.lag_members[_key_lag_members].to_dict()
            _dict['lagMembers'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in subinterfaces (dict)
        _field_dict = {}
        if self.subinterfaces:
            for _key_subinterfaces in self.subinterfaces:
                if self.subinterfaces[_key_subinterfaces]:
                    _field_dict[_key_subinterfaces] = self.subinterfaces[_key_subinterfaces].to_dict()
            _dict['subinterfaces'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestEdgeLagInterfacesValueInterface from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "adminStatus": obj.get("adminStatus"),
            "alias": obj.get("alias"),
            "description": obj.get("description"),
            "ipv4": V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceGwGw.from_dict(obj["ipv4"]) if obj.get("ipv4") is not None else None,
            "ipv6": V1DevicesDeviceIdConfigPutRequestCoreInterfacesValueInterfaceGwGw.from_dict(obj["ipv6"]) if obj.get("ipv6") is not None else None,
            "lacp": V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerLagInterfaceLacpConfig.from_dict(obj["lacp"]) if obj.get("lacp") is not None else None,
            "lagMembers": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestEdgeLagInterfacesValueInterfaceLagMembersValue.from_dict(_v))
                for _k, _v in obj["lagMembers"].items()
            )
            if obj.get("lagMembers") is not None
            else None,
            "minimumMembers": obj.get("minimumMembers"),
            "mtu": obj.get("mtu"),
            "segment": obj.get("segment"),
            "subinterfaces": dict(
                (_k, V1DevicesDeviceIdConfigPutRequestEdgeLagInterfacesValueInterfaceSubinterfacesValue.from_dict(_v))
                for _k, _v in obj["subinterfaces"].items()
            )
            if obj.get("subinterfaces") is not None
            else None
        })
        return _obj


