# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_gateways_put_request_details_ipsec_gateway_routing import V1GatewaysPutRequestDetailsIpsecGatewayRouting
from typing import Optional, Set
from typing_extensions import Self

class V1DevicesDeviceIdConfigPutRequestEdgeSiteToSiteVpnValueSiteToSiteVpn(BaseModel):
    """
    V1DevicesDeviceIdConfigPutRequestEdgeSiteToSiteVpnValueSiteToSiteVpn
    """ # noqa: E501
    destination_address: Optional[StrictStr] = Field(default=None, alias="destinationAddress")
    ike_initiator: Optional[StrictBool] = Field(default=None, alias="ikeInitiator")
    ipsec_label: Optional[StrictStr] = Field(default=None, alias="ipsecLabel")
    lan: Optional[StrictStr] = None
    local_address_v4: Optional[StrictStr] = Field(default=None, alias="localAddressV4")
    local_address_v6: Optional[StrictStr] = Field(default=None, alias="localAddressV6")
    local_circuit: Optional[StrictStr] = Field(default=None, alias="localCircuit")
    local_ike_peer_identity: Optional[StrictStr] = Field(default=None, alias="localIkePeerIdentity")
    mtu: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    name: Optional[StrictStr] = None
    preshared_key: Optional[StrictStr] = Field(default=None, alias="presharedKey")
    remote_address_v4: Optional[StrictStr] = Field(default=None, alias="remoteAddressV4")
    remote_address_v6: Optional[StrictStr] = Field(default=None, alias="remoteAddressV6")
    remote_ike_peer_identity: Optional[StrictStr] = Field(default=None, alias="remoteIkePeerIdentity")
    routing: Optional[V1GatewaysPutRequestDetailsIpsecGatewayRouting] = None
    tcp_mss: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="tcpMss")
    vpn_profile: Optional[StrictStr] = Field(default=None, alias="vpnProfile")
    __properties: ClassVar[List[str]] = ["destinationAddress", "ikeInitiator", "ipsecLabel", "lan", "localAddressV4", "localAddressV6", "localCircuit", "localIkePeerIdentity", "mtu", "name", "presharedKey", "remoteAddressV4", "remoteAddressV6", "remoteIkePeerIdentity", "routing", "tcpMss", "vpnProfile"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestEdgeSiteToSiteVpnValueSiteToSiteVpn from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of routing
        if self.routing:
            _dict['routing'] = self.routing.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DevicesDeviceIdConfigPutRequestEdgeSiteToSiteVpnValueSiteToSiteVpn from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "destinationAddress": obj.get("destinationAddress"),
            "ikeInitiator": obj.get("ikeInitiator"),
            "ipsecLabel": obj.get("ipsecLabel"),
            "lan": obj.get("lan"),
            "localAddressV4": obj.get("localAddressV4"),
            "localAddressV6": obj.get("localAddressV6"),
            "localCircuit": obj.get("localCircuit"),
            "localIkePeerIdentity": obj.get("localIkePeerIdentity"),
            "mtu": obj.get("mtu"),
            "name": obj.get("name"),
            "presharedKey": obj.get("presharedKey"),
            "remoteAddressV4": obj.get("remoteAddressV4"),
            "remoteAddressV6": obj.get("remoteAddressV6"),
            "remoteIkePeerIdentity": obj.get("remoteIkePeerIdentity"),
            "routing": V1GatewaysPutRequestDetailsIpsecGatewayRouting.from_dict(obj["routing"]) if obj.get("routing") is not None else None,
            "tcpMss": obj.get("tcpMss"),
            "vpnProfile": obj.get("vpnProfile")
        })
        return _obj


