# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from typing import Optional, Set
from typing_extensions import Self

class V1DevicesInventoryGet200ResponseInventoryInner(BaseModel):
    """
    V1DevicesInventoryGet200ResponseInventoryInner
    """ # noqa: E501
    assigned_on: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="assignedOn")
    created_on: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="createdOn")
    device_model: Optional[StrictStr] = Field(default=None, alias="deviceModel")
    device_serial: Optional[StrictStr] = Field(default=None, alias="deviceSerial")
    ek_cert: Optional[StrictStr] = Field(default=None, alias="ekCert")
    enterprise_id: Optional[StrictInt] = Field(default=None, alias="enterpriseId")
    enterprise_name: Optional[StrictStr] = Field(default=None, alias="enterpriseName")
    gek_pub: Optional[StrictStr] = Field(default=None, alias="gekPub")
    is_core: Optional[StrictBool] = Field(default=None, alias="isCore")
    is_new: Optional[StrictBool] = Field(default=None, alias="isNew")
    is_requested: Optional[StrictBool] = Field(default=None, alias="isRequested")
    parent_enterprise_id: Optional[StrictInt] = Field(default=None, alias="parentEnterpriseId")
    parent_enterprise_name: Optional[StrictStr] = Field(default=None, alias="parentEnterpriseName")
    role: Optional[StrictStr] = None
    use_oauth: Optional[StrictBool] = Field(default=None, alias="useOauth")
    uuid: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["assignedOn", "createdOn", "deviceModel", "deviceSerial", "ekCert", "enterpriseId", "enterpriseName", "gekPub", "isCore", "isNew", "isRequested", "parentEnterpriseId", "parentEnterpriseName", "role", "useOauth", "uuid"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DevicesInventoryGet200ResponseInventoryInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of assigned_on
        if self.assigned_on:
            _dict['assignedOn'] = self.assigned_on.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_on
        if self.created_on:
            _dict['createdOn'] = self.created_on.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DevicesInventoryGet200ResponseInventoryInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assignedOn": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["assignedOn"]) if obj.get("assignedOn") is not None else None,
            "createdOn": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["createdOn"]) if obj.get("createdOn") is not None else None,
            "deviceModel": obj.get("deviceModel"),
            "deviceSerial": obj.get("deviceSerial"),
            "ekCert": obj.get("ekCert"),
            "enterpriseId": obj.get("enterpriseId"),
            "enterpriseName": obj.get("enterpriseName"),
            "gekPub": obj.get("gekPub"),
            "isCore": obj.get("isCore"),
            "isNew": obj.get("isNew"),
            "isRequested": obj.get("isRequested"),
            "parentEnterpriseId": obj.get("parentEnterpriseId"),
            "parentEnterpriseName": obj.get("parentEnterpriseName"),
            "role": obj.get("role"),
            "useOauth": obj.get("useOauth"),
            "uuid": obj.get("uuid")
        })
        return _obj


