# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from graphiant_sdk.models.v1_devices_running_version_post200_response_versions_inner import V1DevicesRunningVersionPost200ResponseVersionsInner
from graphiant_sdk.models.v1_edges_hardware_assigned_get200_response_edges_summary_inner_upgrade_summary_last_running_version import V1EdgesHardwareAssignedGet200ResponseEdgesSummaryInnerUpgradeSummaryLastRunningVersion
from typing import Optional, Set
from typing_extensions import Self

class V1DevicesUpgradeSchedulePutRequest(BaseModel):
    """
    V1DevicesUpgradeSchedulePutRequest
    """ # noqa: E501
    action: Optional[StrictStr] = None
    device_ids: Optional[List[StrictInt]] = Field(default=None, alias="deviceIds")
    device_versions: Optional[List[V1DevicesRunningVersionPost200ResponseVersionsInner]] = Field(default=None, alias="deviceVersions")
    ts: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = None
    version: Optional[V1EdgesHardwareAssignedGet200ResponseEdgesSummaryInnerUpgradeSummaryLastRunningVersion] = None
    __properties: ClassVar[List[str]] = ["action", "deviceIds", "deviceVersions", "ts", "version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DevicesUpgradeSchedulePutRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in device_versions (list)
        _items = []
        if self.device_versions:
            for _item_device_versions in self.device_versions:
                if _item_device_versions:
                    _items.append(_item_device_versions.to_dict())
            _dict['deviceVersions'] = _items
        # override the default output from pydantic by calling `to_dict()` of ts
        if self.ts:
            _dict['ts'] = self.ts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DevicesUpgradeSchedulePutRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "action": obj.get("action"),
            "deviceIds": obj.get("deviceIds"),
            "deviceVersions": [V1DevicesRunningVersionPost200ResponseVersionsInner.from_dict(_item) for _item in obj["deviceVersions"]] if obj.get("deviceVersions") is not None else None,
            "ts": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["ts"]) if obj.get("ts") is not None else None,
            "version": V1EdgesHardwareAssignedGet200ResponseEdgesSummaryInnerUpgradeSummaryLastRunningVersion.from_dict(obj["version"]) if obj.get("version") is not None else None
        })
        return _obj


