# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from graphiant_sdk.models.v1_diagnostic_ping_pause_resume_post204_response_result_trace_result_hops_inner import V1DiagnosticPingPauseResumePost204ResponseResultTraceResultHopsInner
from typing import Optional, Set
from typing_extensions import Self

class V1DiagnosticPingPauseResumePost204ResponseResultTraceResult(BaseModel):
    """
    V1DiagnosticPingPauseResumePost204ResponseResultTraceResult
    """ # noqa: E501
    hops: Optional[List[V1DiagnosticPingPauseResumePost204ResponseResultTraceResultHopsInner]] = None
    max_latency: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxLatency")
    max_latency_host: Optional[StrictStr] = Field(default=None, alias="maxLatencyHost")
    max_path_mtu: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="maxPathMtu")
    min_path_mtu: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="minPathMtu")
    result: Optional[StrictStr] = None
    stopped_time: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="stoppedTime")
    __properties: ClassVar[List[str]] = ["hops", "maxLatency", "maxLatencyHost", "maxPathMtu", "minPathMtu", "result", "stoppedTime"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DiagnosticPingPauseResumePost204ResponseResultTraceResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in hops (list)
        _items = []
        if self.hops:
            for _item_hops in self.hops:
                if _item_hops:
                    _items.append(_item_hops.to_dict())
            _dict['hops'] = _items
        # override the default output from pydantic by calling `to_dict()` of stopped_time
        if self.stopped_time:
            _dict['stoppedTime'] = self.stopped_time.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DiagnosticPingPauseResumePost204ResponseResultTraceResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "hops": [V1DiagnosticPingPauseResumePost204ResponseResultTraceResultHopsInner.from_dict(_item) for _item in obj["hops"]] if obj.get("hops") is not None else None,
            "maxLatency": obj.get("maxLatency"),
            "maxLatencyHost": obj.get("maxLatencyHost"),
            "maxPathMtu": obj.get("maxPathMtu"),
            "minPathMtu": obj.get("minPathMtu"),
            "result": obj.get("result"),
            "stoppedTime": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["stoppedTime"]) if obj.get("stoppedTime") is not None else None
        })
        return _obj


