# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class V1DiagnosticPingPauseResumePostRequestParams(BaseModel):
    """
    V1DiagnosticPingPauseResumePostRequestParams
    """ # noqa: E501
    dest_address: Optional[StrictStr] = Field(default=None, alias="destAddress")
    hop_stats_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="hopStatsCount")
    interface: Optional[StrictStr] = None
    payload_size: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="payloadSize")
    port: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    probe_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="probeCount")
    src_address: Optional[StrictStr] = Field(default=None, alias="srcAddress")
    tos: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    vrf_name: Optional[StrictStr] = Field(default=None, alias="vrfName")
    __properties: ClassVar[List[str]] = ["destAddress", "hopStatsCount", "interface", "payloadSize", "port", "probeCount", "srcAddress", "tos", "vrfName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DiagnosticPingPauseResumePostRequestParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DiagnosticPingPauseResumePostRequestParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "destAddress": obj.get("destAddress"),
            "hopStatsCount": obj.get("hopStatsCount"),
            "interface": obj.get("interface"),
            "payloadSize": obj.get("payloadSize"),
            "port": obj.get("port"),
            "probeCount": obj.get("probeCount"),
            "srcAddress": obj.get("srcAddress"),
            "tos": obj.get("tos"),
            "vrfName": obj.get("vrfName")
        })
        return _obj


