# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from graphiant_sdk.models.v1_edges_hardware_assigned_get200_response_edges_summary_inner_upgrade_summary import V1EdgesHardwareAssignedGet200ResponseEdgesSummaryInnerUpgradeSummary
from graphiant_sdk.models.v1_extranets_get200_response_policies_inner_branches_excluded_devices_inner_location import V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerLocation
from typing import Optional, Set
from typing_extensions import Self

class V1EdgesHardwareAssignedGet200ResponseEdgesSummaryInner(BaseModel):
    """
    V1EdgesHardwareAssignedGet200ResponseEdgesSummaryInner
    """ # noqa: E501
    assigned_on: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="assignedOn")
    device_id: Optional[StrictInt] = Field(default=None, alias="deviceId")
    discovered_location: Optional[StrictStr] = Field(default=None, alias="discoveredLocation")
    enterprise_id: Optional[StrictInt] = Field(default=None, alias="enterpriseId")
    enterprise_name: Optional[StrictStr] = Field(default=None, alias="enterpriseName")
    first_appeared_on: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="firstAppearedOn")
    hostname: Optional[StrictStr] = None
    ip_detected: Optional[StrictStr] = Field(default=None, alias="ipDetected")
    is_hardware: Optional[StrictBool] = Field(default=None, alias="isHardware")
    is_new: Optional[StrictBool] = Field(default=None, alias="isNew")
    is_requested: Optional[StrictBool] = Field(default=None, alias="isRequested")
    last_booted_at: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="lastBootedAt")
    location: Optional[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerLocation] = None
    model: Optional[StrictStr] = None
    override_region: Optional[StrictStr] = Field(default=None, alias="overrideRegion")
    parent_enterprise_name: Optional[StrictStr] = Field(default=None, alias="parentEnterpriseName")
    portal_status: Optional[StrictStr] = Field(default=None, alias="portalStatus")
    region: Optional[StrictStr] = None
    role: Optional[StrictStr] = None
    serial_num: Optional[StrictStr] = Field(default=None, alias="serialNum")
    site: Optional[StrictStr] = None
    site_id: Optional[StrictInt] = Field(default=None, alias="siteId")
    stale: Optional[StrictBool] = None
    status: Optional[StrictStr] = None
    sw_name: Optional[StrictStr] = Field(default=None, alias="swName")
    sw_version: Optional[StrictStr] = Field(default=None, alias="swVersion")
    tt_conn_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="ttConnCount")
    upgrade_summary: Optional[V1EdgesHardwareAssignedGet200ResponseEdgesSummaryInnerUpgradeSummary] = Field(default=None, alias="upgradeSummary")
    __properties: ClassVar[List[str]] = ["assignedOn", "deviceId", "discoveredLocation", "enterpriseId", "enterpriseName", "firstAppearedOn", "hostname", "ipDetected", "isHardware", "isNew", "isRequested", "lastBootedAt", "location", "model", "overrideRegion", "parentEnterpriseName", "portalStatus", "region", "role", "serialNum", "site", "siteId", "stale", "status", "swName", "swVersion", "ttConnCount", "upgradeSummary"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1EdgesHardwareAssignedGet200ResponseEdgesSummaryInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of assigned_on
        if self.assigned_on:
            _dict['assignedOn'] = self.assigned_on.to_dict()
        # override the default output from pydantic by calling `to_dict()` of first_appeared_on
        if self.first_appeared_on:
            _dict['firstAppearedOn'] = self.first_appeared_on.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_booted_at
        if self.last_booted_at:
            _dict['lastBootedAt'] = self.last_booted_at.to_dict()
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of upgrade_summary
        if self.upgrade_summary:
            _dict['upgradeSummary'] = self.upgrade_summary.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1EdgesHardwareAssignedGet200ResponseEdgesSummaryInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assignedOn": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["assignedOn"]) if obj.get("assignedOn") is not None else None,
            "deviceId": obj.get("deviceId"),
            "discoveredLocation": obj.get("discoveredLocation"),
            "enterpriseId": obj.get("enterpriseId"),
            "enterpriseName": obj.get("enterpriseName"),
            "firstAppearedOn": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["firstAppearedOn"]) if obj.get("firstAppearedOn") is not None else None,
            "hostname": obj.get("hostname"),
            "ipDetected": obj.get("ipDetected"),
            "isHardware": obj.get("isHardware"),
            "isNew": obj.get("isNew"),
            "isRequested": obj.get("isRequested"),
            "lastBootedAt": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["lastBootedAt"]) if obj.get("lastBootedAt") is not None else None,
            "location": V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerLocation.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "model": obj.get("model"),
            "overrideRegion": obj.get("overrideRegion"),
            "parentEnterpriseName": obj.get("parentEnterpriseName"),
            "portalStatus": obj.get("portalStatus"),
            "region": obj.get("region"),
            "role": obj.get("role"),
            "serialNum": obj.get("serialNum"),
            "site": obj.get("site"),
            "siteId": obj.get("siteId"),
            "stale": obj.get("stale"),
            "status": obj.get("status"),
            "swName": obj.get("swName"),
            "swVersion": obj.get("swVersion"),
            "ttConnCount": obj.get("ttConnCount"),
            "upgradeSummary": V1EdgesHardwareAssignedGet200ResponseEdgesSummaryInnerUpgradeSummary.from_dict(obj["upgradeSummary"]) if obj.get("upgradeSummary") is not None else None
        })
        return _obj


