# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from graphiant_sdk.models.v1_enterprises_get200_response_enterprises_inner_counts import V1EnterprisesGet200ResponseEnterprisesInnerCounts
from graphiant_sdk.models.v1_enterprises_get200_response_enterprises_inner_customers_value import V1EnterprisesGet200ResponseEnterprisesInnerCustomersValue
from typing import Optional, Set
from typing_extensions import Self

class V1EnterprisesGet200ResponseEnterprisesInner(BaseModel):
    """
    V1EnterprisesGet200ResponseEnterprisesInner
    """ # noqa: E501
    accept_eula: Optional[StrictBool] = Field(default=None, alias="acceptEula")
    account_type: Optional[StrictStr] = Field(default=None, alias="accountType")
    admin_email: Optional[StrictStr] = Field(default=None, alias="adminEmail")
    cloud_provider: Optional[StrictStr] = Field(default=None, alias="cloudProvider")
    company_name: Optional[StrictStr] = Field(default=None, alias="companyName")
    counts: Optional[V1EnterprisesGet200ResponseEnterprisesInnerCounts] = None
    credit_limit: Optional[StrictInt] = Field(default=None, alias="creditLimit")
    customers: Optional[Dict[str, V1EnterprisesGet200ResponseEnterprisesInnerCustomersValue]] = None
    enterprise_id: Optional[StrictInt] = Field(default=None, alias="enterpriseId")
    eula_agreement_date: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="eulaAgreementDate")
    impersonation_enabled: Optional[StrictBool] = Field(default=None, alias="impersonationEnabled")
    logo: Optional[StrictStr] = None
    parent_company_name: Optional[StrictStr] = Field(default=None, alias="parentCompanyName")
    parent_enterprise_id: Optional[StrictInt] = Field(default=None, alias="parentEnterpriseId")
    portal_banner: Optional[StrictStr] = Field(default=None, alias="portalBanner")
    small_logo: Optional[StrictStr] = Field(default=None, alias="smallLogo")
    token_expiry: Optional[StrictStr] = Field(default=None, alias="tokenExpiry")
    __properties: ClassVar[List[str]] = ["acceptEula", "accountType", "adminEmail", "cloudProvider", "companyName", "counts", "creditLimit", "customers", "enterpriseId", "eulaAgreementDate", "impersonationEnabled", "logo", "parentCompanyName", "parentEnterpriseId", "portalBanner", "smallLogo", "tokenExpiry"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1EnterprisesGet200ResponseEnterprisesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of counts
        if self.counts:
            _dict['counts'] = self.counts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in customers (dict)
        _field_dict = {}
        if self.customers:
            for _key_customers in self.customers:
                if self.customers[_key_customers]:
                    _field_dict[_key_customers] = self.customers[_key_customers].to_dict()
            _dict['customers'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of eula_agreement_date
        if self.eula_agreement_date:
            _dict['eulaAgreementDate'] = self.eula_agreement_date.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1EnterprisesGet200ResponseEnterprisesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "acceptEula": obj.get("acceptEula"),
            "accountType": obj.get("accountType"),
            "adminEmail": obj.get("adminEmail"),
            "cloudProvider": obj.get("cloudProvider"),
            "companyName": obj.get("companyName"),
            "counts": V1EnterprisesGet200ResponseEnterprisesInnerCounts.from_dict(obj["counts"]) if obj.get("counts") is not None else None,
            "creditLimit": obj.get("creditLimit"),
            "customers": dict(
                (_k, V1EnterprisesGet200ResponseEnterprisesInnerCustomersValue.from_dict(_v))
                for _k, _v in obj["customers"].items()
            )
            if obj.get("customers") is not None
            else None,
            "enterpriseId": obj.get("enterpriseId"),
            "eulaAgreementDate": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["eulaAgreementDate"]) if obj.get("eulaAgreementDate") is not None else None,
            "impersonationEnabled": obj.get("impersonationEnabled"),
            "logo": obj.get("logo"),
            "parentCompanyName": obj.get("parentCompanyName"),
            "parentEnterpriseId": obj.get("parentEnterpriseId"),
            "portalBanner": obj.get("portalBanner"),
            "smallLogo": obj.get("smallLogo"),
            "tokenExpiry": obj.get("tokenExpiry")
        })
        return _obj


