# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_enterprises_patch_request_token_expiry import V1EnterprisesPatchRequestTokenExpiry
from typing import Optional, Set
from typing_extensions import Self

class V1EnterprisesPatchRequest(BaseModel):
    """
    V1EnterprisesPatchRequest
    """ # noqa: E501
    admin_email: Optional[StrictStr] = Field(default=None, alias="adminEmail")
    cloud_provider: Optional[StrictStr] = Field(default=None, alias="cloudProvider")
    company_name: Optional[StrictStr] = Field(default=None, alias="companyName")
    credit_limit: Optional[StrictInt] = Field(default=None, alias="creditLimit")
    enterprise_id: Optional[StrictInt] = Field(default=None, alias="enterpriseId")
    impersonation_enabled: Optional[StrictBool] = Field(default=None, alias="impersonationEnabled")
    logo: Optional[StrictStr] = None
    portal_banner: Optional[StrictStr] = Field(default=None, alias="portalBanner")
    small_logo: Optional[StrictStr] = Field(default=None, alias="smallLogo")
    token_expiry: Optional[V1EnterprisesPatchRequestTokenExpiry] = Field(default=None, alias="tokenExpiry")
    __properties: ClassVar[List[str]] = ["adminEmail", "cloudProvider", "companyName", "creditLimit", "enterpriseId", "impersonationEnabled", "logo", "portalBanner", "smallLogo", "tokenExpiry"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1EnterprisesPatchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of token_expiry
        if self.token_expiry:
            _dict['tokenExpiry'] = self.token_expiry.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1EnterprisesPatchRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "adminEmail": obj.get("adminEmail"),
            "cloudProvider": obj.get("cloudProvider"),
            "companyName": obj.get("companyName"),
            "creditLimit": obj.get("creditLimit"),
            "enterpriseId": obj.get("enterpriseId"),
            "impersonationEnabled": obj.get("impersonationEnabled"),
            "logo": obj.get("logo"),
            "portalBanner": obj.get("portalBanner"),
            "smallLogo": obj.get("smallLogo"),
            "tokenExpiry": V1EnterprisesPatchRequestTokenExpiry.from_dict(obj["tokenExpiry"]) if obj.get("tokenExpiry") is not None else None
        })
        return _obj


