# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from graphiant_sdk.models.v1_extranets_get200_response_policies_inner_branches_excluded_devices_inner_interfaces_inner_ip_sec import V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpSec
from graphiant_sdk.models.v1_extranets_get200_response_policies_inner_branches_excluded_devices_inner_interfaces_inner_ipv4 import V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpv4
from graphiant_sdk.models.v1_extranets_get200_response_policies_inner_branches_excluded_devices_inner_interfaces_inner_lag_interface import V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerLagInterface
from graphiant_sdk.models.v1_extranets_get200_response_policies_inner_branches_excluded_devices_inner_interfaces_inner_sfp_optical_strength_inner import V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerSfpOpticalStrengthInner
from graphiant_sdk.models.v1_extranets_get200_response_policies_inner_branches_excluded_devices_inner_interfaces_inner_subinterfaces_inner import V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerSubinterfacesInner
from typing import Optional, Set
from typing_extensions import Self

class V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInner(BaseModel):
    """
    V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInner
    """ # noqa: E501
    alias: Optional[StrictStr] = None
    circuit: Optional[StrictStr] = None
    circuit_name: Optional[StrictStr] = Field(default=None, alias="circuitName")
    config_updated_at: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="configUpdatedAt")
    configured_max_transmission_unit: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="configuredMaxTransmissionUnit")
    description: Optional[StrictStr] = None
    duplex: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    id: Optional[StrictInt] = None
    ip_sec: Optional[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpSec] = Field(default=None, alias="ipSec")
    ipv4: Optional[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpv4] = None
    ipv6: Optional[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpv4] = None
    ipv6_addresses: Optional[List[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpv4]] = Field(default=None, alias="ipv6Addresses")
    lag_interface: Optional[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerLagInterface] = Field(default=None, alias="lagInterface")
    lan: Optional[StrictStr] = None
    lldp_enabled: Optional[StrictBool] = Field(default=None, alias="lldpEnabled")
    max_transmission_unit: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="maxTransmissionUnit")
    name: Optional[StrictStr] = None
    oper_updated_at: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="operUpdatedAt")
    phy_address: Optional[StrictStr] = Field(default=None, alias="phyAddress")
    protocol: Optional[StrictStr] = None
    security_zone: Optional[StrictStr] = Field(default=None, alias="securityZone")
    sfp_optical_strength: Optional[List[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerSfpOpticalStrengthInner]] = Field(default=None, alias="sfpOpticalStrength")
    speed_mbps: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="speedMbps")
    subinterfaces: Optional[List[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerSubinterfacesInner]] = None
    tcp_mss: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="tcpMss")
    tcp_mss_v4: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="tcpMssV4")
    tcp_mss_v6: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="tcpMssV6")
    type: Optional[StrictStr] = None
    up: Optional[StrictBool] = None
    vrf_function_id: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="vrfFunctionId")
    vrf_name: Optional[StrictStr] = Field(default=None, alias="vrfName")
    __properties: ClassVar[List[str]] = ["alias", "circuit", "circuitName", "configUpdatedAt", "configuredMaxTransmissionUnit", "description", "duplex", "enabled", "id", "ipSec", "ipv4", "ipv6", "ipv6Addresses", "lagInterface", "lan", "lldpEnabled", "maxTransmissionUnit", "name", "operUpdatedAt", "phyAddress", "protocol", "securityZone", "sfpOpticalStrength", "speedMbps", "subinterfaces", "tcpMss", "tcpMssV4", "tcpMssV6", "type", "up", "vrfFunctionId", "vrfName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config_updated_at
        if self.config_updated_at:
            _dict['configUpdatedAt'] = self.config_updated_at.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ip_sec
        if self.ip_sec:
            _dict['ipSec'] = self.ip_sec.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ipv4
        if self.ipv4:
            _dict['ipv4'] = self.ipv4.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ipv6
        if self.ipv6:
            _dict['ipv6'] = self.ipv6.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in ipv6_addresses (list)
        _items = []
        if self.ipv6_addresses:
            for _item_ipv6_addresses in self.ipv6_addresses:
                if _item_ipv6_addresses:
                    _items.append(_item_ipv6_addresses.to_dict())
            _dict['ipv6Addresses'] = _items
        # override the default output from pydantic by calling `to_dict()` of lag_interface
        if self.lag_interface:
            _dict['lagInterface'] = self.lag_interface.to_dict()
        # override the default output from pydantic by calling `to_dict()` of oper_updated_at
        if self.oper_updated_at:
            _dict['operUpdatedAt'] = self.oper_updated_at.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sfp_optical_strength (list)
        _items = []
        if self.sfp_optical_strength:
            for _item_sfp_optical_strength in self.sfp_optical_strength:
                if _item_sfp_optical_strength:
                    _items.append(_item_sfp_optical_strength.to_dict())
            _dict['sfpOpticalStrength'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in subinterfaces (list)
        _items = []
        if self.subinterfaces:
            for _item_subinterfaces in self.subinterfaces:
                if _item_subinterfaces:
                    _items.append(_item_subinterfaces.to_dict())
            _dict['subinterfaces'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "alias": obj.get("alias"),
            "circuit": obj.get("circuit"),
            "circuitName": obj.get("circuitName"),
            "configUpdatedAt": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["configUpdatedAt"]) if obj.get("configUpdatedAt") is not None else None,
            "configuredMaxTransmissionUnit": obj.get("configuredMaxTransmissionUnit"),
            "description": obj.get("description"),
            "duplex": obj.get("duplex"),
            "enabled": obj.get("enabled"),
            "id": obj.get("id"),
            "ipSec": V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpSec.from_dict(obj["ipSec"]) if obj.get("ipSec") is not None else None,
            "ipv4": V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpv4.from_dict(obj["ipv4"]) if obj.get("ipv4") is not None else None,
            "ipv6": V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpv4.from_dict(obj["ipv6"]) if obj.get("ipv6") is not None else None,
            "ipv6Addresses": [V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpv4.from_dict(_item) for _item in obj["ipv6Addresses"]] if obj.get("ipv6Addresses") is not None else None,
            "lagInterface": V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerLagInterface.from_dict(obj["lagInterface"]) if obj.get("lagInterface") is not None else None,
            "lan": obj.get("lan"),
            "lldpEnabled": obj.get("lldpEnabled"),
            "maxTransmissionUnit": obj.get("maxTransmissionUnit"),
            "name": obj.get("name"),
            "operUpdatedAt": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["operUpdatedAt"]) if obj.get("operUpdatedAt") is not None else None,
            "phyAddress": obj.get("phyAddress"),
            "protocol": obj.get("protocol"),
            "securityZone": obj.get("securityZone"),
            "sfpOpticalStrength": [V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerSfpOpticalStrengthInner.from_dict(_item) for _item in obj["sfpOpticalStrength"]] if obj.get("sfpOpticalStrength") is not None else None,
            "speedMbps": obj.get("speedMbps"),
            "subinterfaces": [V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerSubinterfacesInner.from_dict(_item) for _item in obj["subinterfaces"]] if obj.get("subinterfaces") is not None else None,
            "tcpMss": obj.get("tcpMss"),
            "tcpMssV4": obj.get("tcpMssV4"),
            "tcpMssV6": obj.get("tcpMssV6"),
            "type": obj.get("type"),
            "up": obj.get("up"),
            "vrfFunctionId": obj.get("vrfFunctionId"),
            "vrfName": obj.get("vrfName")
        })
        return _obj


