# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from typing import Optional, Set
from typing_extensions import Self

class V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpSec(BaseModel):
    """
    V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpSec
    """ # noqa: E501
    anti_replay_window_size: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="antiReplayWindowSize")
    dh_group: Optional[StrictStr] = Field(default=None, alias="dhGroup")
    dpd_interval: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="dpdInterval")
    encryption_alg: Optional[StrictStr] = Field(default=None, alias="encryptionAlg")
    esn: Optional[StrictBool] = None
    established_time: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="establishedTime")
    ike_integrity: Optional[StrictStr] = Field(default=None, alias="ikeIntegrity")
    ipsec_encryption_alg: Optional[StrictStr] = Field(default=None, alias="ipsecEncryptionAlg")
    ipsec_integrity: Optional[StrictStr] = Field(default=None, alias="ipsecIntegrity")
    label: Optional[StrictStr] = None
    local_address: Optional[StrictStr] = Field(default=None, alias="localAddress")
    local_circuit: Optional[StrictStr] = Field(default=None, alias="localCircuit")
    local_ike_peer_identity: Optional[StrictStr] = Field(default=None, alias="localIkePeerIdentity")
    local_ikesa_spi: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="localIkesaSpi")
    local_port: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="localPort")
    negotiated_algo: Optional[StrictStr] = Field(default=None, alias="negotiatedAlgo")
    oper_state: Optional[StrictBool] = Field(default=None, alias="operState")
    perfect_forward_secrecy: Optional[StrictStr] = Field(default=None, alias="perfectForwardSecrecy")
    preshared_key: Optional[StrictStr] = Field(default=None, alias="presharedKey")
    protocol: Optional[StrictStr] = None
    reauth_interval: Optional[StrictInt] = Field(default=None, alias="reauthInterval")
    rekey_interval: Optional[StrictInt] = Field(default=None, alias="rekeyInterval")
    remote_address: Optional[StrictStr] = Field(default=None, alias="remoteAddress")
    remote_ike_peer_identity: Optional[StrictStr] = Field(default=None, alias="remoteIkePeerIdentity")
    remote_ikesa_spi: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="remoteIkesaSpi")
    remote_port: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="remotePort")
    __properties: ClassVar[List[str]] = ["antiReplayWindowSize", "dhGroup", "dpdInterval", "encryptionAlg", "esn", "establishedTime", "ikeIntegrity", "ipsecEncryptionAlg", "ipsecIntegrity", "label", "localAddress", "localCircuit", "localIkePeerIdentity", "localIkesaSpi", "localPort", "negotiatedAlgo", "operState", "perfectForwardSecrecy", "presharedKey", "protocol", "reauthInterval", "rekeyInterval", "remoteAddress", "remoteIkePeerIdentity", "remoteIkesaSpi", "remotePort"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpSec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of established_time
        if self.established_time:
            _dict['establishedTime'] = self.established_time.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpSec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "antiReplayWindowSize": obj.get("antiReplayWindowSize"),
            "dhGroup": obj.get("dhGroup"),
            "dpdInterval": obj.get("dpdInterval"),
            "encryptionAlg": obj.get("encryptionAlg"),
            "esn": obj.get("esn"),
            "establishedTime": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["establishedTime"]) if obj.get("establishedTime") is not None else None,
            "ikeIntegrity": obj.get("ikeIntegrity"),
            "ipsecEncryptionAlg": obj.get("ipsecEncryptionAlg"),
            "ipsecIntegrity": obj.get("ipsecIntegrity"),
            "label": obj.get("label"),
            "localAddress": obj.get("localAddress"),
            "localCircuit": obj.get("localCircuit"),
            "localIkePeerIdentity": obj.get("localIkePeerIdentity"),
            "localIkesaSpi": obj.get("localIkesaSpi"),
            "localPort": obj.get("localPort"),
            "negotiatedAlgo": obj.get("negotiatedAlgo"),
            "operState": obj.get("operState"),
            "perfectForwardSecrecy": obj.get("perfectForwardSecrecy"),
            "presharedKey": obj.get("presharedKey"),
            "protocol": obj.get("protocol"),
            "reauthInterval": obj.get("reauthInterval"),
            "rekeyInterval": obj.get("rekeyInterval"),
            "remoteAddress": obj.get("remoteAddress"),
            "remoteIkePeerIdentity": obj.get("remoteIkePeerIdentity"),
            "remoteIkesaSpi": obj.get("remoteIkesaSpi"),
            "remotePort": obj.get("remotePort")
        })
        return _obj


