# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from graphiant_sdk.models.v1_extranets_get200_response_policies_inner_branches_excluded_devices_inner_interfaces_inner_ipv4 import V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpv4
from typing import Optional, Set
from typing_extensions import Self

class V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerSubinterfacesInner(BaseModel):
    """
    V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerSubinterfacesInner
    """ # noqa: E501
    alias: Optional[StrictStr] = None
    circuit: Optional[StrictStr] = None
    config_updated_at: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="configUpdatedAt")
    description: Optional[StrictStr] = None
    duplex: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    id: Optional[StrictInt] = None
    ipv4: Optional[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpv4] = None
    ipv6: Optional[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpv4] = None
    ipv6_addresses: Optional[List[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpv4]] = Field(default=None, alias="ipv6Addresses")
    lan: Optional[StrictStr] = None
    mac_address: Optional[StrictStr] = Field(default=None, alias="macAddress")
    max_transmission_unit: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="maxTransmissionUnit")
    name: Optional[StrictStr] = None
    oper_updated_at: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="operUpdatedAt")
    parent_mac_address: Optional[StrictStr] = Field(default=None, alias="parentMacAddress")
    security_zone: Optional[StrictStr] = Field(default=None, alias="securityZone")
    speed_mbps: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="speedMbps")
    tcp_mss: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="tcpMss")
    tcp_mss_v4: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="tcpMssV4")
    tcp_mss_v6: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="tcpMssV6")
    up: Optional[StrictBool] = None
    vlan: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    __properties: ClassVar[List[str]] = ["alias", "circuit", "configUpdatedAt", "description", "duplex", "enabled", "id", "ipv4", "ipv6", "ipv6Addresses", "lan", "macAddress", "maxTransmissionUnit", "name", "operUpdatedAt", "parentMacAddress", "securityZone", "speedMbps", "tcpMss", "tcpMssV4", "tcpMssV6", "up", "vlan"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerSubinterfacesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config_updated_at
        if self.config_updated_at:
            _dict['configUpdatedAt'] = self.config_updated_at.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ipv4
        if self.ipv4:
            _dict['ipv4'] = self.ipv4.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ipv6
        if self.ipv6:
            _dict['ipv6'] = self.ipv6.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in ipv6_addresses (list)
        _items = []
        if self.ipv6_addresses:
            for _item_ipv6_addresses in self.ipv6_addresses:
                if _item_ipv6_addresses:
                    _items.append(_item_ipv6_addresses.to_dict())
            _dict['ipv6Addresses'] = _items
        # override the default output from pydantic by calling `to_dict()` of oper_updated_at
        if self.oper_updated_at:
            _dict['operUpdatedAt'] = self.oper_updated_at.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerSubinterfacesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "alias": obj.get("alias"),
            "circuit": obj.get("circuit"),
            "configUpdatedAt": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["configUpdatedAt"]) if obj.get("configUpdatedAt") is not None else None,
            "description": obj.get("description"),
            "duplex": obj.get("duplex"),
            "enabled": obj.get("enabled"),
            "id": obj.get("id"),
            "ipv4": V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpv4.from_dict(obj["ipv4"]) if obj.get("ipv4") is not None else None,
            "ipv6": V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpv4.from_dict(obj["ipv6"]) if obj.get("ipv6") is not None else None,
            "ipv6Addresses": [V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerInterfacesInnerIpv4.from_dict(_item) for _item in obj["ipv6Addresses"]] if obj.get("ipv6Addresses") is not None else None,
            "lan": obj.get("lan"),
            "macAddress": obj.get("macAddress"),
            "maxTransmissionUnit": obj.get("maxTransmissionUnit"),
            "name": obj.get("name"),
            "operUpdatedAt": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["operUpdatedAt"]) if obj.get("operUpdatedAt") is not None else None,
            "parentMacAddress": obj.get("parentMacAddress"),
            "securityZone": obj.get("securityZone"),
            "speedMbps": obj.get("speedMbps"),
            "tcpMss": obj.get("tcpMss"),
            "tcpMssV4": obj.get("tcpMssV4"),
            "tcpMssV6": obj.get("tcpMssV6"),
            "up": obj.get("up"),
            "vlan": obj.get("vlan")
        })
        return _obj


