# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from graphiant_sdk.models.v1_extranets_get200_response_policies_inner_branches_excluded_devices_inner_location import V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerLocation
from graphiant_sdk.models.v1_extranets_get200_response_policies_inner_branches_excluded_devices_inner_site_devices_inner import V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerSiteDevicesInner
from graphiant_sdk.models.v1_extranets_get200_response_policies_inner_branches_excluded_devices_inner_site_policy_tag import V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerSitePolicyTag
from typing import Optional, Set
from typing_extensions import Self

class V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerSite(BaseModel):
    """
    V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerSite
    """ # noqa: E501
    address: Optional[StrictStr] = None
    created_at: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="createdAt")
    devices: Optional[List[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerSiteDevicesInner]] = None
    edge_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="edgeCount")
    id: Optional[StrictInt] = None
    location: Optional[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerLocation] = None
    name: Optional[StrictStr] = None
    notes: Optional[StrictStr] = None
    policy_reference_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="policyReferenceCount")
    policy_tag: Optional[V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerSitePolicyTag] = Field(default=None, alias="policyTag")
    segment_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="segmentCount")
    site_list_reference_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="siteListReferenceCount")
    tags: Optional[List[StrictStr]] = None
    updated_at: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="updatedAt")
    __properties: ClassVar[List[str]] = ["address", "createdAt", "devices", "edgeCount", "id", "location", "name", "notes", "policyReferenceCount", "policyTag", "segmentCount", "siteListReferenceCount", "tags", "updatedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerSite from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of created_at
        if self.created_at:
            _dict['createdAt'] = self.created_at.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in devices (list)
        _items = []
        if self.devices:
            for _item_devices in self.devices:
                if _item_devices:
                    _items.append(_item_devices.to_dict())
            _dict['devices'] = _items
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of policy_tag
        if self.policy_tag:
            _dict['policyTag'] = self.policy_tag.to_dict()
        # override the default output from pydantic by calling `to_dict()` of updated_at
        if self.updated_at:
            _dict['updatedAt'] = self.updated_at.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerSite from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": obj.get("address"),
            "createdAt": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["createdAt"]) if obj.get("createdAt") is not None else None,
            "devices": [V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerSiteDevicesInner.from_dict(_item) for _item in obj["devices"]] if obj.get("devices") is not None else None,
            "edgeCount": obj.get("edgeCount"),
            "id": obj.get("id"),
            "location": V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerLocation.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "name": obj.get("name"),
            "notes": obj.get("notes"),
            "policyReferenceCount": obj.get("policyReferenceCount"),
            "policyTag": V1ExtranetsGet200ResponsePoliciesInnerBranchesExcludedDevicesInnerSitePolicyTag.from_dict(obj["policyTag"]) if obj.get("policyTag") is not None else None,
            "segmentCount": obj.get("segmentCount"),
            "siteListReferenceCount": obj.get("siteListReferenceCount"),
            "tags": obj.get("tags"),
            "updatedAt": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["updatedAt"]) if obj.get("updatedAt") is not None else None
        })
        return _obj


