# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from graphiant_sdk.models.v1_flows_flow_table_post_request_selector import V1FlowsFlowTablePostRequestSelector
from graphiant_sdk.models.v2_notificationlist_post_request_time_window import V2NotificationlistPostRequestTimeWindow
from typing import Optional, Set
from typing_extensions import Self

class V1FlowsFlowTablePostRequest(BaseModel):
    """
    V1FlowsFlowTablePostRequest
    """ # noqa: E501
    app_id: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="appId")
    app_name: Optional[StrictStr] = Field(default=None, alias="appName")
    cursor_ref: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="cursorRef")
    device_id: Optional[StrictInt] = Field(default=None, alias="deviceId")
    is_dia: Optional[StrictBool] = Field(default=None, alias="isDia")
    num_flow_records: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="numFlowRecords")
    selector: Optional[V1FlowsFlowTablePostRequestSelector] = None
    time_window: Optional[V2NotificationlistPostRequestTimeWindow] = Field(default=None, alias="timeWindow")
    __properties: ClassVar[List[str]] = ["appId", "appName", "cursorRef", "deviceId", "isDia", "numFlowRecords", "selector", "timeWindow"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1FlowsFlowTablePostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cursor_ref
        if self.cursor_ref:
            _dict['cursorRef'] = self.cursor_ref.to_dict()
        # override the default output from pydantic by calling `to_dict()` of selector
        if self.selector:
            _dict['selector'] = self.selector.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time_window
        if self.time_window:
            _dict['timeWindow'] = self.time_window.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1FlowsFlowTablePostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "appId": obj.get("appId"),
            "appName": obj.get("appName"),
            "cursorRef": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["cursorRef"]) if obj.get("cursorRef") is not None else None,
            "deviceId": obj.get("deviceId"),
            "isDia": obj.get("isDia"),
            "numFlowRecords": obj.get("numFlowRecords"),
            "selector": V1FlowsFlowTablePostRequestSelector.from_dict(obj["selector"]) if obj.get("selector") is not None else None,
            "timeWindow": V2NotificationlistPostRequestTimeWindow.from_dict(obj["timeWindow"]) if obj.get("timeWindow") is not None else None
        })
        return _obj


