# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_gateways_put_request_details_aws import V1GatewaysPutRequestDetailsAws
from graphiant_sdk.models.v1_gateways_put_request_details_azure import V1GatewaysPutRequestDetailsAzure
from graphiant_sdk.models.v1_gateways_put_request_details_gcp import V1GatewaysPutRequestDetailsGcp
from graphiant_sdk.models.v1_gateways_put_request_details_ipsec_gateway import V1GatewaysPutRequestDetailsIpsecGateway
from graphiant_sdk.models.v1_gateways_put_request_details_oci import V1GatewaysPutRequestDetailsOci
from typing import Optional, Set
from typing_extensions import Self

class V1GatewaysPutRequestDetails(BaseModel):
    """
    V1GatewaysPutRequestDetails
    """ # noqa: E501
    aws: Optional[V1GatewaysPutRequestDetailsAws] = None
    azure: Optional[V1GatewaysPutRequestDetailsAzure] = None
    description: Optional[StrictStr] = None
    gcp: Optional[V1GatewaysPutRequestDetailsGcp] = None
    ipsec_gateway: Optional[V1GatewaysPutRequestDetailsIpsecGateway] = Field(default=None, alias="ipsecGateway")
    oci: Optional[V1GatewaysPutRequestDetailsOci] = None
    region_id: Optional[StrictInt] = Field(default=None, alias="regionId")
    speed: Optional[StrictStr] = None
    vrf_id: Optional[StrictInt] = Field(default=None, alias="vrfId")
    __properties: ClassVar[List[str]] = ["aws", "azure", "description", "gcp", "ipsecGateway", "oci", "regionId", "speed", "vrfId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1GatewaysPutRequestDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of aws
        if self.aws:
            _dict['aws'] = self.aws.to_dict()
        # override the default output from pydantic by calling `to_dict()` of azure
        if self.azure:
            _dict['azure'] = self.azure.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gcp
        if self.gcp:
            _dict['gcp'] = self.gcp.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ipsec_gateway
        if self.ipsec_gateway:
            _dict['ipsecGateway'] = self.ipsec_gateway.to_dict()
        # override the default output from pydantic by calling `to_dict()` of oci
        if self.oci:
            _dict['oci'] = self.oci.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1GatewaysPutRequestDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "aws": V1GatewaysPutRequestDetailsAws.from_dict(obj["aws"]) if obj.get("aws") is not None else None,
            "azure": V1GatewaysPutRequestDetailsAzure.from_dict(obj["azure"]) if obj.get("azure") is not None else None,
            "description": obj.get("description"),
            "gcp": V1GatewaysPutRequestDetailsGcp.from_dict(obj["gcp"]) if obj.get("gcp") is not None else None,
            "ipsecGateway": V1GatewaysPutRequestDetailsIpsecGateway.from_dict(obj["ipsecGateway"]) if obj.get("ipsecGateway") is not None else None,
            "oci": V1GatewaysPutRequestDetailsOci.from_dict(obj["oci"]) if obj.get("oci") is not None else None,
            "regionId": obj.get("regionId"),
            "speed": obj.get("speed"),
            "vrfId": obj.get("vrfId")
        })
        return _obj


