# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_gateways_put_request_details_ipsec_gateway_routing import V1GatewaysPutRequestDetailsIpsecGatewayRouting
from graphiant_sdk.models.v1_gateways_put_request_details_ipsec_gateway_tunnel1 import V1GatewaysPutRequestDetailsIpsecGatewayTunnel1
from typing import Optional, Set
from typing_extensions import Self

class V1GatewaysPutRequestDetailsIpsecGateway(BaseModel):
    """
    V1GatewaysPutRequestDetailsIpsecGateway
    """ # noqa: E501
    destination_address: Optional[StrictStr] = Field(default=None, alias="destinationAddress")
    ike_initiator: Optional[StrictBool] = Field(default=None, alias="ikeInitiator")
    mtu: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    name: Optional[StrictStr] = None
    remote_ike_peer_identity: Optional[StrictStr] = Field(default=None, alias="remoteIkePeerIdentity")
    routing: Optional[V1GatewaysPutRequestDetailsIpsecGatewayRouting] = None
    tcp_mss: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="tcpMss")
    tunnel1: Optional[V1GatewaysPutRequestDetailsIpsecGatewayTunnel1] = None
    tunnel2: Optional[V1GatewaysPutRequestDetailsIpsecGatewayTunnel1] = None
    vpn_profile: Optional[StrictStr] = Field(default=None, alias="vpnProfile")
    __properties: ClassVar[List[str]] = ["destinationAddress", "ikeInitiator", "mtu", "name", "remoteIkePeerIdentity", "routing", "tcpMss", "tunnel1", "tunnel2", "vpnProfile"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1GatewaysPutRequestDetailsIpsecGateway from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of routing
        if self.routing:
            _dict['routing'] = self.routing.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tunnel1
        if self.tunnel1:
            _dict['tunnel1'] = self.tunnel1.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tunnel2
        if self.tunnel2:
            _dict['tunnel2'] = self.tunnel2.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1GatewaysPutRequestDetailsIpsecGateway from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "destinationAddress": obj.get("destinationAddress"),
            "ikeInitiator": obj.get("ikeInitiator"),
            "mtu": obj.get("mtu"),
            "name": obj.get("name"),
            "remoteIkePeerIdentity": obj.get("remoteIkePeerIdentity"),
            "routing": V1GatewaysPutRequestDetailsIpsecGatewayRouting.from_dict(obj["routing"]) if obj.get("routing") is not None else None,
            "tcpMss": obj.get("tcpMss"),
            "tunnel1": V1GatewaysPutRequestDetailsIpsecGatewayTunnel1.from_dict(obj["tunnel1"]) if obj.get("tunnel1") is not None else None,
            "tunnel2": V1GatewaysPutRequestDetailsIpsecGatewayTunnel1.from_dict(obj["tunnel2"]) if obj.get("tunnel2") is not None else None,
            "vpnProfile": obj.get("vpnProfile")
        })
        return _obj


