# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_gateways_put_request_details_ipsec_gateway_routing_bgp_address_families_value import V1GatewaysPutRequestDetailsIpsecGatewayRoutingBgpAddressFamiliesValue
from graphiant_sdk.models.v1_gateways_put_request_details_ipsec_gateway_routing_bgp_md5_password import V1GatewaysPutRequestDetailsIpsecGatewayRoutingBgpMd5Password
from typing import Optional, Set
from typing_extensions import Self

class V1GatewaysPutRequestDetailsIpsecGatewayRoutingBgp(BaseModel):
    """
    V1GatewaysPutRequestDetailsIpsecGatewayRoutingBgp
    """ # noqa: E501
    address_families: Optional[Dict[str, V1GatewaysPutRequestDetailsIpsecGatewayRoutingBgpAddressFamiliesValue]] = Field(default=None, alias="addressFamilies")
    hold_timer: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="holdTimer")
    keepalive_timer: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="keepaliveTimer")
    md5_password: Optional[V1GatewaysPutRequestDetailsIpsecGatewayRoutingBgpMd5Password] = Field(default=None, alias="md5Password")
    peer_asn: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="peerAsn")
    send_community: Optional[StrictBool] = Field(default=None, alias="sendCommunity")
    __properties: ClassVar[List[str]] = ["addressFamilies", "holdTimer", "keepaliveTimer", "md5Password", "peerAsn", "sendCommunity"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1GatewaysPutRequestDetailsIpsecGatewayRoutingBgp from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in address_families (dict)
        _field_dict = {}
        if self.address_families:
            for _key_address_families in self.address_families:
                if self.address_families[_key_address_families]:
                    _field_dict[_key_address_families] = self.address_families[_key_address_families].to_dict()
            _dict['addressFamilies'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of md5_password
        if self.md5_password:
            _dict['md5Password'] = self.md5_password.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1GatewaysPutRequestDetailsIpsecGatewayRoutingBgp from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "addressFamilies": dict(
                (_k, V1GatewaysPutRequestDetailsIpsecGatewayRoutingBgpAddressFamiliesValue.from_dict(_v))
                for _k, _v in obj["addressFamilies"].items()
            )
            if obj.get("addressFamilies") is not None
            else None,
            "holdTimer": obj.get("holdTimer"),
            "keepaliveTimer": obj.get("keepaliveTimer"),
            "md5Password": V1GatewaysPutRequestDetailsIpsecGatewayRoutingBgpMd5Password.from_dict(obj["md5Password"]) if obj.get("md5Password") is not None else None,
            "peerAsn": obj.get("peerAsn"),
            "sendCommunity": obj.get("sendCommunity")
        })
        return _obj


