# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_global_config_patch_request_global_prefix_sets_value import V1GlobalConfigPatchRequestGlobalPrefixSetsValue
from graphiant_sdk.models.v1_global_config_patch_request_ipfix_exporters_value import V1GlobalConfigPatchRequestIpfixExportersValue
from graphiant_sdk.models.v1_global_config_patch_request_prefix_sets_value import V1GlobalConfigPatchRequestPrefixSetsValue
from graphiant_sdk.models.v1_global_config_patch_request_routing_policies_value import V1GlobalConfigPatchRequestRoutingPoliciesValue
from graphiant_sdk.models.v1_global_config_patch_request_snmps_value import V1GlobalConfigPatchRequestSnmpsValue
from graphiant_sdk.models.v1_global_config_patch_request_syslog_servers_value import V1GlobalConfigPatchRequestSyslogServersValue
from graphiant_sdk.models.v1_global_config_patch_request_traffic_policies import V1GlobalConfigPatchRequestTrafficPolicies
from graphiant_sdk.models.v1_global_config_patch_request_vpn_profiles_value import V1GlobalConfigPatchRequestVpnProfilesValue
from typing import Optional, Set
from typing_extensions import Self

class V1GlobalConfigPatchRequest(BaseModel):
    """
    V1GlobalConfigPatchRequest
    """ # noqa: E501
    global_prefix_sets: Optional[Dict[str, V1GlobalConfigPatchRequestGlobalPrefixSetsValue]] = Field(default=None, alias="globalPrefixSets")
    ipfix_exporters: Optional[Dict[str, V1GlobalConfigPatchRequestIpfixExportersValue]] = Field(default=None, alias="ipfixExporters")
    prefix_sets: Optional[Dict[str, V1GlobalConfigPatchRequestPrefixSetsValue]] = Field(default=None, alias="prefixSets")
    routing_policies: Optional[Dict[str, V1GlobalConfigPatchRequestRoutingPoliciesValue]] = Field(default=None, alias="routingPolicies")
    snmps: Optional[Dict[str, V1GlobalConfigPatchRequestSnmpsValue]] = None
    syslog_servers: Optional[Dict[str, V1GlobalConfigPatchRequestSyslogServersValue]] = Field(default=None, alias="syslogServers")
    traffic_policies: Optional[V1GlobalConfigPatchRequestTrafficPolicies] = Field(default=None, alias="trafficPolicies")
    vpn_profiles: Optional[Dict[str, V1GlobalConfigPatchRequestVpnProfilesValue]] = Field(default=None, alias="vpnProfiles")
    __properties: ClassVar[List[str]] = ["globalPrefixSets", "ipfixExporters", "prefixSets", "routingPolicies", "snmps", "syslogServers", "trafficPolicies", "vpnProfiles"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1GlobalConfigPatchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in global_prefix_sets (dict)
        _field_dict = {}
        if self.global_prefix_sets:
            for _key_global_prefix_sets in self.global_prefix_sets:
                if self.global_prefix_sets[_key_global_prefix_sets]:
                    _field_dict[_key_global_prefix_sets] = self.global_prefix_sets[_key_global_prefix_sets].to_dict()
            _dict['globalPrefixSets'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in ipfix_exporters (dict)
        _field_dict = {}
        if self.ipfix_exporters:
            for _key_ipfix_exporters in self.ipfix_exporters:
                if self.ipfix_exporters[_key_ipfix_exporters]:
                    _field_dict[_key_ipfix_exporters] = self.ipfix_exporters[_key_ipfix_exporters].to_dict()
            _dict['ipfixExporters'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in prefix_sets (dict)
        _field_dict = {}
        if self.prefix_sets:
            for _key_prefix_sets in self.prefix_sets:
                if self.prefix_sets[_key_prefix_sets]:
                    _field_dict[_key_prefix_sets] = self.prefix_sets[_key_prefix_sets].to_dict()
            _dict['prefixSets'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in routing_policies (dict)
        _field_dict = {}
        if self.routing_policies:
            for _key_routing_policies in self.routing_policies:
                if self.routing_policies[_key_routing_policies]:
                    _field_dict[_key_routing_policies] = self.routing_policies[_key_routing_policies].to_dict()
            _dict['routingPolicies'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in snmps (dict)
        _field_dict = {}
        if self.snmps:
            for _key_snmps in self.snmps:
                if self.snmps[_key_snmps]:
                    _field_dict[_key_snmps] = self.snmps[_key_snmps].to_dict()
            _dict['snmps'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in syslog_servers (dict)
        _field_dict = {}
        if self.syslog_servers:
            for _key_syslog_servers in self.syslog_servers:
                if self.syslog_servers[_key_syslog_servers]:
                    _field_dict[_key_syslog_servers] = self.syslog_servers[_key_syslog_servers].to_dict()
            _dict['syslogServers'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of traffic_policies
        if self.traffic_policies:
            _dict['trafficPolicies'] = self.traffic_policies.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in vpn_profiles (dict)
        _field_dict = {}
        if self.vpn_profiles:
            for _key_vpn_profiles in self.vpn_profiles:
                if self.vpn_profiles[_key_vpn_profiles]:
                    _field_dict[_key_vpn_profiles] = self.vpn_profiles[_key_vpn_profiles].to_dict()
            _dict['vpnProfiles'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1GlobalConfigPatchRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "globalPrefixSets": dict(
                (_k, V1GlobalConfigPatchRequestGlobalPrefixSetsValue.from_dict(_v))
                for _k, _v in obj["globalPrefixSets"].items()
            )
            if obj.get("globalPrefixSets") is not None
            else None,
            "ipfixExporters": dict(
                (_k, V1GlobalConfigPatchRequestIpfixExportersValue.from_dict(_v))
                for _k, _v in obj["ipfixExporters"].items()
            )
            if obj.get("ipfixExporters") is not None
            else None,
            "prefixSets": dict(
                (_k, V1GlobalConfigPatchRequestPrefixSetsValue.from_dict(_v))
                for _k, _v in obj["prefixSets"].items()
            )
            if obj.get("prefixSets") is not None
            else None,
            "routingPolicies": dict(
                (_k, V1GlobalConfigPatchRequestRoutingPoliciesValue.from_dict(_v))
                for _k, _v in obj["routingPolicies"].items()
            )
            if obj.get("routingPolicies") is not None
            else None,
            "snmps": dict(
                (_k, V1GlobalConfigPatchRequestSnmpsValue.from_dict(_v))
                for _k, _v in obj["snmps"].items()
            )
            if obj.get("snmps") is not None
            else None,
            "syslogServers": dict(
                (_k, V1GlobalConfigPatchRequestSyslogServersValue.from_dict(_v))
                for _k, _v in obj["syslogServers"].items()
            )
            if obj.get("syslogServers") is not None
            else None,
            "trafficPolicies": V1GlobalConfigPatchRequestTrafficPolicies.from_dict(obj["trafficPolicies"]) if obj.get("trafficPolicies") is not None else None,
            "vpnProfiles": dict(
                (_k, V1GlobalConfigPatchRequestVpnProfilesValue.from_dict(_v))
                for _k, _v in obj["vpnProfiles"].items()
            )
            if obj.get("vpnProfiles") is not None
            else None
        })
        return _obj


