# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_groups_get200_response_groups_inner_permissions import V1GroupsGet200ResponseGroupsInnerPermissions
from typing import Optional, Set
from typing_extensions import Self

class V1GroupsPutRequest(BaseModel):
    """
    V1GroupsPutRequest
    """ # noqa: E501
    description: Optional[StrictStr] = None
    group_id: Optional[StrictStr] = Field(default=None, alias="groupId")
    group_type: Optional[StrictStr] = Field(default=None, alias="groupType")
    manages_enterprises: Optional[StrictBool] = Field(default=None, alias="managesEnterprises")
    name: Optional[StrictStr] = None
    permissions: Optional[V1GroupsGet200ResponseGroupsInnerPermissions] = None
    time_window_end: Optional[StrictInt] = Field(default=None, alias="timeWindowEnd")
    time_window_start: Optional[StrictInt] = Field(default=None, alias="timeWindowStart")
    __properties: ClassVar[List[str]] = ["description", "groupId", "groupType", "managesEnterprises", "name", "permissions", "timeWindowEnd", "timeWindowStart"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1GroupsPutRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1GroupsPutRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "groupId": obj.get("groupId"),
            "groupType": obj.get("groupType"),
            "managesEnterprises": obj.get("managesEnterprises"),
            "name": obj.get("name"),
            "permissions": V1GroupsGet200ResponseGroupsInnerPermissions.from_dict(obj["permissions"]) if obj.get("permissions") is not None else None,
            "timeWindowEnd": obj.get("timeWindowEnd"),
            "timeWindowStart": obj.get("timeWindowStart")
        })
        return _obj


