# coding: utf-8

"""
    Graphiant APIs

    **To use the APIs:**  1) Login using `/api/v1/auth/login`   2) Copy the value of \"token\" in the response   3) Click the \"Authorize\" button   4) In the \"Value\" text field enter: `Bearer <your token>`   5) Click \"Authorize\"   6) All requests are now authorized.  **Token valid for 2 hours. If expired:**   - Login again, click \"Authorize\", paste new token.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_healthcheck_devices_get200_response_details_inner_odp_status import V1HealthcheckDevicesGet200ResponseDetailsInnerOdpStatus
from graphiant_sdk.models.v1_healthcheck_devices_get200_response_details_inner_onboarding_status import V1HealthcheckDevicesGet200ResponseDetailsInnerOnboardingStatus
from typing import Optional, Set
from typing_extensions import Self

class V1HealthcheckDevicesGet200ResponseDetailsInner(BaseModel):
    """
    V1HealthcheckDevicesGet200ResponseDetailsInner
    """ # noqa: E501
    bgp_core_state: Optional[List[StrictBool]] = Field(default=None, alias="bgpCoreState")
    bgp_odp_state: Optional[List[StrictBool]] = Field(default=None, alias="bgpOdpState")
    core_tunnel_state: Optional[List[StrictBool]] = Field(default=None, alias="coreTunnelState")
    device_id: Optional[StrictInt] = Field(default=None, alias="deviceId")
    enterprise_id: Optional[StrictInt] = Field(default=None, alias="enterpriseId")
    gnmi_state: Optional[StrictBool] = Field(default=None, alias="gnmiState")
    ipsec_core_status: Optional[StrictStr] = Field(default=None, alias="ipsecCoreStatus")
    ipsec_odp_status: Optional[StrictStr] = Field(default=None, alias="ipsecOdpStatus")
    odp_status: Optional[V1HealthcheckDevicesGet200ResponseDetailsInnerOdpStatus] = Field(default=None, alias="odpStatus")
    odp_tunnel_state: Optional[List[StrictBool]] = Field(default=None, alias="odpTunnelState")
    onboarding_status: Optional[V1HealthcheckDevicesGet200ResponseDetailsInnerOnboardingStatus] = Field(default=None, alias="onboardingStatus")
    t2_status: Optional[V1HealthcheckDevicesGet200ResponseDetailsInnerOdpStatus] = Field(default=None, alias="t2Status")
    topo_gw_state: Optional[StrictStr] = Field(default=None, alias="topoGwState")
    tt_tunnel_state: Optional[List[StrictBool]] = Field(default=None, alias="ttTunnelState")
    __properties: ClassVar[List[str]] = ["bgpCoreState", "bgpOdpState", "coreTunnelState", "deviceId", "enterpriseId", "gnmiState", "ipsecCoreStatus", "ipsecOdpStatus", "odpStatus", "odpTunnelState", "onboardingStatus", "t2Status", "topoGwState", "ttTunnelState"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1HealthcheckDevicesGet200ResponseDetailsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of odp_status
        if self.odp_status:
            _dict['odpStatus'] = self.odp_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of onboarding_status
        if self.onboarding_status:
            _dict['onboardingStatus'] = self.onboarding_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of t2_status
        if self.t2_status:
            _dict['t2Status'] = self.t2_status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1HealthcheckDevicesGet200ResponseDetailsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bgpCoreState": obj.get("bgpCoreState"),
            "bgpOdpState": obj.get("bgpOdpState"),
            "coreTunnelState": obj.get("coreTunnelState"),
            "deviceId": obj.get("deviceId"),
            "enterpriseId": obj.get("enterpriseId"),
            "gnmiState": obj.get("gnmiState"),
            "ipsecCoreStatus": obj.get("ipsecCoreStatus"),
            "ipsecOdpStatus": obj.get("ipsecOdpStatus"),
            "odpStatus": V1HealthcheckDevicesGet200ResponseDetailsInnerOdpStatus.from_dict(obj["odpStatus"]) if obj.get("odpStatus") is not None else None,
            "odpTunnelState": obj.get("odpTunnelState"),
            "onboardingStatus": V1HealthcheckDevicesGet200ResponseDetailsInnerOnboardingStatus.from_dict(obj["onboardingStatus"]) if obj.get("onboardingStatus") is not None else None,
            "t2Status": V1HealthcheckDevicesGet200ResponseDetailsInnerOdpStatus.from_dict(obj["t2Status"]) if obj.get("t2Status") is not None else None,
            "topoGwState": obj.get("topoGwState"),
            "ttTunnelState": obj.get("ttTunnelState")
        })
        return _obj


