# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from graphiant_sdk.models.v1_audit_logs_post200_response_histogram_inner import V1AuditLogsPost200ResponseHistogramInner
from graphiant_sdk.models.v1_logs_post200_response_logs_inner import V1LogsPost200ResponseLogsInner
from typing import Optional, Set
from typing_extensions import Self

class V1LogsPost200Response(BaseModel):
    """
    V1LogsPost200Response
    """ # noqa: E501
    cursor_ref: Optional[StrictStr] = Field(default=None, alias="cursorRef")
    histogram: Optional[List[V1AuditLogsPost200ResponseHistogramInner]] = None
    logs: Optional[List[V1LogsPost200ResponseLogsInner]] = None
    total_logs: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="totalLogs")
    __properties: ClassVar[List[str]] = ["cursorRef", "histogram", "logs", "totalLogs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1LogsPost200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in histogram (list)
        _items = []
        if self.histogram:
            for _item_histogram in self.histogram:
                if _item_histogram:
                    _items.append(_item_histogram.to_dict())
            _dict['histogram'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in logs (list)
        _items = []
        if self.logs:
            for _item_logs in self.logs:
                if _item_logs:
                    _items.append(_item_logs.to_dict())
            _dict['logs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1LogsPost200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cursorRef": obj.get("cursorRef"),
            "histogram": [V1AuditLogsPost200ResponseHistogramInner.from_dict(_item) for _item in obj["histogram"]] if obj.get("histogram") is not None else None,
            "logs": [V1LogsPost200ResponseLogsInner.from_dict(_item) for _item in obj["logs"]] if obj.get("logs") is not None else None,
            "totalLogs": obj.get("totalLogs")
        })
        return _obj


