# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class V1MonitoringCircuitsSummaryPost200ResponseSummariesInner(BaseModel):
    """
    V1MonitoringCircuitsSummaryPost200ResponseSummariesInner
    """ # noqa: E501
    admin_status: Optional[StrictBool] = Field(default=None, alias="adminStatus")
    average_link_down_speed_kbps: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="averageLinkDownSpeedKbps")
    average_link_up_speed_kbps: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="averageLinkUpSpeedKbps")
    avg_mos: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="avgMos")
    config_link_down_speed_mbps: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="configLinkDownSpeedMbps")
    config_link_up_speed_mbps: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="configLinkUpSpeedMbps")
    connection_status: Optional[StrictStr] = Field(default=None, alias="connectionStatus")
    current_link_down_speed_kbps: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="currentLinkDownSpeedKbps")
    current_link_up_speed_kbps: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="currentLinkUpSpeedKbps")
    delay: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    jitter: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    loss: Optional[Union[StrictFloat, StrictInt]] = None
    mos: Optional[Union[StrictFloat, StrictInt]] = None
    name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["adminStatus", "averageLinkDownSpeedKbps", "averageLinkUpSpeedKbps", "avgMos", "configLinkDownSpeedMbps", "configLinkUpSpeedMbps", "connectionStatus", "currentLinkDownSpeedKbps", "currentLinkUpSpeedKbps", "delay", "jitter", "loss", "mos", "name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1MonitoringCircuitsSummaryPost200ResponseSummariesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1MonitoringCircuitsSummaryPost200ResponseSummariesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "adminStatus": obj.get("adminStatus"),
            "averageLinkDownSpeedKbps": obj.get("averageLinkDownSpeedKbps"),
            "averageLinkUpSpeedKbps": obj.get("averageLinkUpSpeedKbps"),
            "avgMos": obj.get("avgMos"),
            "configLinkDownSpeedMbps": obj.get("configLinkDownSpeedMbps"),
            "configLinkUpSpeedMbps": obj.get("configLinkUpSpeedMbps"),
            "connectionStatus": obj.get("connectionStatus"),
            "currentLinkDownSpeedKbps": obj.get("currentLinkDownSpeedKbps"),
            "currentLinkUpSpeedKbps": obj.get("currentLinkUpSpeedKbps"),
            "delay": obj.get("delay"),
            "jitter": obj.get("jitter"),
            "loss": obj.get("loss"),
            "mos": obj.get("mos"),
            "name": obj.get("name")
        })
        return _obj


