# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v1_alarm_history_get200_response_history_inner_time import V1AlarmHistoryGet200ResponseHistoryInnerTime
from graphiant_sdk.models.v1_backbone_health_device_device_id_post200_response_data_plane import V1BackboneHealthDeviceDeviceIdPost200ResponseDataPlane
from graphiant_sdk.models.v1_backbone_health_device_device_id_post200_response_issues_inner import V1BackboneHealthDeviceDeviceIdPost200ResponseIssuesInner
from graphiant_sdk.models.v1_edges_hardware_assigned_get200_response_edges_summary_inner_upgrade_summary_last_running_version import V1EdgesHardwareAssignedGet200ResponseEdgesSummaryInnerUpgradeSummaryLastRunningVersion
from graphiant_sdk.models.v1_troubleshooting_device_device_id_post200_response_control_plane import V1TroubleshootingDeviceDeviceIdPost200ResponseControlPlane
from graphiant_sdk.models.v1_troubleshooting_device_device_id_post200_response_system_plane import V1TroubleshootingDeviceDeviceIdPost200ResponseSystemPlane
from typing import Optional, Set
from typing_extensions import Self

class V1TroubleshootingDeviceDeviceIdPost200Response(BaseModel):
    """
    V1TroubleshootingDeviceDeviceIdPost200Response
    """ # noqa: E501
    maintenance_mode: Optional[StrictBool] = Field(default=None, alias="MaintenanceMode")
    colr_active: Optional[StrictBool] = Field(default=None, alias="colrActive")
    control_plane: Optional[V1TroubleshootingDeviceDeviceIdPost200ResponseControlPlane] = Field(default=None, alias="controlPlane")
    data_plane: Optional[V1BackboneHealthDeviceDeviceIdPost200ResponseDataPlane] = Field(default=None, alias="dataPlane")
    issues: Optional[List[V1BackboneHealthDeviceDeviceIdPost200ResponseIssuesInner]] = None
    lifecycle_status: Optional[StrictStr] = Field(default=None, alias="lifecycleStatus")
    status: Optional[StrictStr] = None
    sw_version: Optional[StrictStr] = Field(default=None, alias="swVersion")
    sw_version_v2: Optional[V1EdgesHardwareAssignedGet200ResponseEdgesSummaryInnerUpgradeSummaryLastRunningVersion] = Field(default=None, alias="swVersionV2")
    system_plane: Optional[V1TroubleshootingDeviceDeviceIdPost200ResponseSystemPlane] = Field(default=None, alias="systemPlane")
    up_since_ts: Optional[V1AlarmHistoryGet200ResponseHistoryInnerTime] = Field(default=None, alias="upSinceTs")
    __properties: ClassVar[List[str]] = ["MaintenanceMode", "colrActive", "controlPlane", "dataPlane", "issues", "lifecycleStatus", "status", "swVersion", "swVersionV2", "systemPlane", "upSinceTs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1TroubleshootingDeviceDeviceIdPost200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of control_plane
        if self.control_plane:
            _dict['controlPlane'] = self.control_plane.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data_plane
        if self.data_plane:
            _dict['dataPlane'] = self.data_plane.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in issues (list)
        _items = []
        if self.issues:
            for _item_issues in self.issues:
                if _item_issues:
                    _items.append(_item_issues.to_dict())
            _dict['issues'] = _items
        # override the default output from pydantic by calling `to_dict()` of sw_version_v2
        if self.sw_version_v2:
            _dict['swVersionV2'] = self.sw_version_v2.to_dict()
        # override the default output from pydantic by calling `to_dict()` of system_plane
        if self.system_plane:
            _dict['systemPlane'] = self.system_plane.to_dict()
        # override the default output from pydantic by calling `to_dict()` of up_since_ts
        if self.up_since_ts:
            _dict['upSinceTs'] = self.up_since_ts.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1TroubleshootingDeviceDeviceIdPost200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "MaintenanceMode": obj.get("MaintenanceMode"),
            "colrActive": obj.get("colrActive"),
            "controlPlane": V1TroubleshootingDeviceDeviceIdPost200ResponseControlPlane.from_dict(obj["controlPlane"]) if obj.get("controlPlane") is not None else None,
            "dataPlane": V1BackboneHealthDeviceDeviceIdPost200ResponseDataPlane.from_dict(obj["dataPlane"]) if obj.get("dataPlane") is not None else None,
            "issues": [V1BackboneHealthDeviceDeviceIdPost200ResponseIssuesInner.from_dict(_item) for _item in obj["issues"]] if obj.get("issues") is not None else None,
            "lifecycleStatus": obj.get("lifecycleStatus"),
            "status": obj.get("status"),
            "swVersion": obj.get("swVersion"),
            "swVersionV2": V1EdgesHardwareAssignedGet200ResponseEdgesSummaryInnerUpgradeSummaryLastRunningVersion.from_dict(obj["swVersionV2"]) if obj.get("swVersionV2") is not None else None,
            "systemPlane": V1TroubleshootingDeviceDeviceIdPost200ResponseSystemPlane.from_dict(obj["systemPlane"]) if obj.get("systemPlane") is not None else None,
            "upSinceTs": V1AlarmHistoryGet200ResponseHistoryInnerTime.from_dict(obj["upSinceTs"]) if obj.get("upSinceTs") is not None else None
        })
        return _obj


