# coding: utf-8

"""
    Graphiant APIs

    Graphiant API documentation.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from graphiant_sdk.models.v2_assurance_applicationdetailsbyname_post200_response_app_id_record import V2AssuranceApplicationdetailsbynamePost200ResponseAppIdRecord
from graphiant_sdk.models.v2_assurance_applicationdetailsbyname_post200_response_app_id_record_flex_algo_inner import V2AssuranceApplicationdetailsbynamePost200ResponseAppIdRecordFlexAlgoInner
from typing import Optional, Set
from typing_extensions import Self

class V2AssuranceApplicationdetailsbynamePost200ResponseAppNameRecord(BaseModel):
    """
    V2AssuranceApplicationdetailsbynamePost200ResponseAppNameRecord
    """ # noqa: E501
    affected_hosts: Optional[StrictInt] = Field(default=None, alias="affectedHosts")
    affected_regions: Optional[StrictInt] = Field(default=None, alias="affectedRegions")
    affected_sites: Optional[StrictInt] = Field(default=None, alias="affectedSites")
    affected_vrfs: Optional[StrictInt] = Field(default=None, alias="affectedVrfs")
    app_id: Optional[StrictInt] = Field(default=None, alias="appId")
    app_id_records: Optional[List[V2AssuranceApplicationdetailsbynamePost200ResponseAppIdRecord]] = Field(default=None, alias="appIdRecords")
    app_name: Optional[StrictStr] = Field(default=None, alias="appName")
    app_type: Optional[StrictStr] = Field(default=None, alias="appType")
    category: Optional[StrictStr] = None
    da_classified: Optional[StrictBool] = Field(default=None, alias="daClassified")
    flex_algo: Optional[List[V2AssuranceApplicationdetailsbynamePost200ResponseAppIdRecordFlexAlgoInner]] = Field(default=None, alias="flexAlgo")
    flows_analyzed: Optional[StrictInt] = Field(default=None, alias="flowsAnalyzed")
    recommendation: Optional[StrictStr] = None
    risk_status: Optional[StrictStr] = Field(default=None, alias="riskStatus")
    threat_score: Optional[StrictInt] = Field(default=None, alias="threatScore")
    __properties: ClassVar[List[str]] = ["affectedHosts", "affectedRegions", "affectedSites", "affectedVrfs", "appId", "appIdRecords", "appName", "appType", "category", "daClassified", "flexAlgo", "flowsAnalyzed", "recommendation", "riskStatus", "threatScore"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2AssuranceApplicationdetailsbynamePost200ResponseAppNameRecord from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in app_id_records (list)
        _items = []
        if self.app_id_records:
            for _item_app_id_records in self.app_id_records:
                if _item_app_id_records:
                    _items.append(_item_app_id_records.to_dict())
            _dict['appIdRecords'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in flex_algo (list)
        _items = []
        if self.flex_algo:
            for _item_flex_algo in self.flex_algo:
                if _item_flex_algo:
                    _items.append(_item_flex_algo.to_dict())
            _dict['flexAlgo'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2AssuranceApplicationdetailsbynamePost200ResponseAppNameRecord from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "affectedHosts": obj.get("affectedHosts"),
            "affectedRegions": obj.get("affectedRegions"),
            "affectedSites": obj.get("affectedSites"),
            "affectedVrfs": obj.get("affectedVrfs"),
            "appId": obj.get("appId"),
            "appIdRecords": [V2AssuranceApplicationdetailsbynamePost200ResponseAppIdRecord.from_dict(_item) for _item in obj["appIdRecords"]] if obj.get("appIdRecords") is not None else None,
            "appName": obj.get("appName"),
            "appType": obj.get("appType"),
            "category": obj.get("category"),
            "daClassified": obj.get("daClassified"),
            "flexAlgo": [V2AssuranceApplicationdetailsbynamePost200ResponseAppIdRecordFlexAlgoInner.from_dict(_item) for _item in obj["flexAlgo"]] if obj.get("flexAlgo") is not None else None,
            "flowsAnalyzed": obj.get("flowsAnalyzed"),
            "recommendation": obj.get("recommendation"),
            "riskStatus": obj.get("riskStatus"),
            "threatScore": obj.get("threatScore")
        })
        return _obj


